/*
 * Decompiled with CFR 0.152.
 */
package rbms;

import Jama.Matrix;
import java.util.Arrays;
import java.util.Random;

public abstract class Mat {
    public static double[] ones(int L) {
        double[] m = new double[L];
        Arrays.fill(m, 1.0);
        return m;
    }

    public static int[] sum(int[][] M2) {
        int[] s = new int[M2.length];
        for (int j = 0; j < M2.length; ++j) {
            for (int k = 0; k < M2[j].length; ++k) {
                int n = j;
                s[n] = s[n] + M2[j][k];
            }
        }
        return s;
    }

    public static double[] sum(double[][] M2) {
        double[] s = new double[M2.length];
        for (int j = 0; j < M2.length; ++j) {
            for (int k = 0; k < M2[j].length; ++k) {
                int n = j;
                s[n] = s[n] + M2[j][k];
            }
        }
        return s;
    }

    public static final void fillRow(double[][] M2, int k, double val) {
        for (int j = 0; j < M2[k].length; ++j) {
            M2[k][j] = val;
        }
    }

    public static final void fillCol(double[][] M2, int k, double val) {
        for (int i = 0; i < M2.length; ++i) {
            M2[i][k] = val;
        }
    }

    public static double[][] randn(int rows, int cols, Random r) {
        double[][] X = new double[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                X[i][j] = r.nextGaussian();
            }
        }
        return X;
    }

    public static Matrix randomn(int nrows, int ncols, Random r) {
        return new Matrix(Mat.randn(nrows, ncols, r));
    }

    public static final double[][] copy(double[][] P) {
        double[][] X = new double[P.length][P[0].length];
        for (int i = 0; i < P.length; ++i) {
            for (int j = 0; j < P[i].length; ++j) {
                X[i][j] = P[i][j];
            }
        }
        return X;
    }

    public static final double dsigma(double a) {
        double s = Mat.sigma(a);
        return s * (1.0 - s);
    }

    public static final double[] dsigma(double[] v) {
        double[] u = new double[v.length];
        for (int j = 0; j < v.length; ++j) {
            u[j] = Mat.dsigma(v[j]);
        }
        return u;
    }

    public static final double[][] dsigma(double[][] A2) {
        double[][] X = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                X[i][j] = Mat.dsigma(A2[i][j]);
            }
        }
        return X;
    }

    public static final Matrix dsigma(Matrix A2) {
        return new Matrix(Mat.dsigma(A2.getArray()));
    }

    public static final double sigma(double a) {
        return 1.0 / (1.0 + Math.exp(-a));
    }

    public static final double[] sigma(double[] v) {
        double[] u = new double[v.length];
        for (int j = 0; j < v.length; ++j) {
            u[j] = Mat.sigma(v[j]);
        }
        return u;
    }

    public static final double[][] sigma(double[][] A2) {
        double[][] X = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                X[i][j] = Mat.sigma(A2[i][j]);
            }
        }
        return X;
    }

    public static final Matrix sigma(Matrix A2) {
        return new Matrix(Mat.sigma(A2.getArray()));
    }

    public static final double[][] threshold(double[][] P, Random r) {
        double[][] X = new double[P.length][P[0].length];
        for (int i = 0; i < P.length; ++i) {
            for (int j = 0; j < P[i].length; ++j) {
                X[i][j] = P[i][j] > r.nextDouble() ? 1.0 : 0.0;
            }
        }
        return X;
    }

    public static final double[][] threshold(double[][] P, double t) {
        double[][] X = new double[P.length][P[0].length];
        for (int i = 0; i < P.length; ++i) {
            for (int j = 0; j < P[i].length; ++j) {
                X[i][j] = P[i][j] > t ? 1.0 : 0.0;
            }
        }
        return X;
    }

    public static final double[] threshold(double[] v, double t) {
        double[] u = new double[v.length];
        for (int j = 0; j < v.length; ++j) {
            u[j] = v[j] > t ? 1.0 : 0.0;
        }
        return u;
    }

    public static final Matrix threshold(Matrix M2, double t) {
        return new Matrix(Mat.threshold(M2.getArray(), t));
    }

    public static double[][] transposeMultiply(double[][] A2, double[][] B) {
        double[][] At = Mat.getTranspose(A2);
        return Mat.multiply(At, B);
    }

    public static double[][] multiplyTranspose(double[][] A2, double[][] B) {
        double[][] Bt = Mat.getTranspose(B);
        return Mat.multiply(A2, Bt);
    }

    public static double[][] getTranspose(double[][] M2) {
        double[][] C = new double[M2[0].length][];
        for (int i = 0; i < M2[0].length; ++i) {
            C[i] = Mat.getCol(M2, i);
        }
        return C;
    }

    public static double[][] multiply(double[][] A2, double[][] B) {
        int aRows = A2.length;
        int aCols = A2[0].length;
        int bRows = B.length;
        int bCols = B[0].length;
        if (aCols != bRows) {
            throw new IllegalArgumentException(" A.cols (" + aCols + ") != B.rows (" + bRows + ") ");
        }
        double[][] C = new double[aRows][bCols];
        for (int i = 0; i < aRows; ++i) {
            for (int k = 0; k < aCols; ++k) {
                for (int j = 0; j < bCols; ++j) {
                    double[] dArray = C[i];
                    int n = j;
                    dArray[n] = dArray[n] + A2[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static double[] multiply(double[] a, double[] b) throws Exception {
        Matrix a_ = new Matrix(a, 1);
        Matrix b_ = new Matrix(b, 1);
        Matrix c_ = a_.arrayTimes(b_);
        return c_.getArray()[0];
    }

    public static double[][] multiply(double[][] A2, double K) {
        double[][] C = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                C[i][j] = A2[i][j] * K;
            }
        }
        return C;
    }

    public static double[] addBias(double[] x) {
        double[] x2 = new double[x.length + 1];
        x2[0] = 1.0;
        for (int j = 0; j < x.length; ++j) {
            x2[j + 1] = x[j];
        }
        return x2;
    }

    public static double[][] addBias(double[][] M2) {
        double[][] C = new double[M2.length][M2[0].length + 1];
        for (int i = 0; i < M2.length; ++i) {
            C[i][0] = 1.0;
            for (int j = 0; j < M2[i].length; ++j) {
                C[i][j + 1] = M2[i][j];
            }
        }
        return C;
    }

    public static Matrix addBias(Matrix M2) {
        return new Matrix(Mat.addBias(M2.getArray()));
    }

    public static double[] removeBias(double[] x) {
        double[] x2 = new double[x.length - 1];
        for (int j = 1; j < x.length; ++j) {
            x2[j - 1] = x[j];
        }
        return x2;
    }

    public static double[][] removeBias(double[][] M2) {
        double[][] C = new double[M2.length][M2[0].length - 1];
        for (int i = 0; i < M2.length; ++i) {
            for (int j = 1; j < M2[i].length; ++j) {
                C[i][j - 1] = M2[i][j];
            }
        }
        return C;
    }

    public static Matrix removeBias(Matrix M2) {
        return new Matrix(Mat.removeBias(M2.getArray()));
    }

    public static double[] getCol(double[][] M2, int k) {
        double[] col_k = new double[M2.length];
        for (int i = 0; i < M2.length; ++i) {
            col_k[i] = M2[i][k];
        }
        return col_k;
    }

    public static int[] getCol(int[][] M2, int k) {
        int[] col_k = new int[M2.length];
        for (int i = 0; i < M2.length; ++i) {
            col_k[i] = M2[i][k];
        }
        return col_k;
    }

    public static double[][] add(double[][] A2, double[][] B) {
        double[][] C = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                C[i][j] = A2[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static double[][] add(double[][] A2, double v) {
        double[][] C = new double[A2.length][A2[0].length];
        for (int i = 0; i < A2.length; ++i) {
            for (int j = 0; j < A2[i].length; ++j) {
                C[i][j] = A2[i][j] + v;
            }
        }
        return C;
    }

    public static double squaredError(double[] vector1, double[] vector2) {
        double squaredError = 0.0;
        for (int i = 0; i < vector1.length; ++i) {
            squaredError += (vector1[i] - vector2[i]) * (vector1[i] - vector2[i]);
        }
        return squaredError;
    }

    public static double MSE(double[][] A2, double[][] B) {
        return Mat.meanSquaredError(A2, B);
    }

    public static double meanSquaredError(double[][] vectorBatch1, double[][] vectorBatch2) {
        double error = 0.0;
        for (int i = 0; i < vectorBatch1.length; ++i) {
            error += Mat.squaredError(vectorBatch1[i], vectorBatch2[i]);
        }
        return error / (double)vectorBatch1.length;
    }

    public static double dot(double[] v, double[] u) {
        double sum = 0.0;
        for (int i = 0; i < v.length; ++i) {
            sum += v[i] * u[i];
        }
        return sum;
    }

    public static double[][] sample(double[][] M2, Random r) {
        return Mat.threshold(M2, r);
    }

    public static double[] sample(double[] v, Random r) {
        return Mat.threshold((double[][])new double[][]{v}, r)[0];
    }

    public static Matrix sample(Matrix M2, Random r) {
        return new Matrix(Mat.sample(M2.getArray(), r));
    }

    public static String toString(Matrix M2) {
        return Mat.toString(M2.getArray());
    }

    public static String toString(double[][] M_, int adp) {
        int width = adp > 0 ? adp + 2 : 0;
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < M_.length; ++j) {
            for (int k = 0; k < M_[j].length; ++k) {
                double d = M_[j][k];
                String num = String.format("%6.2f", d);
                if (adp == 0) {
                    num = String.format("%2.0f", d);
                }
                sb.append(num);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(double[][] M_) {
        return Mat.toString(M_, 2);
    }

    public static String toString(int[][] M_) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < M_.length; ++j) {
            for (int k = 0; k < M_[j].length; ++k) {
                String num = String.format("%5d", M_[j][k]);
                sb.append(num);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void printMatrix(double[][] M_) {
        Matrix M2 = new Matrix(M_);
        M2.print(5, 3);
    }

    public static void printDim(Matrix M2) {
        Mat.printDim(M2.getArray());
    }

    public static void printDim(double[][] M2) {
        System.out.println("" + M2.length + " x " + M2[0].length + "     (rows x cols)");
    }

    public static String getDim(double[][] M2) {
        return "" + M2.length + " x " + M2[0].length + "     (rows x cols)";
    }

    public static String getDim(Matrix M2) {
        return Mat.getDim(M2.getArray());
    }

    public static int[] maxIndices(double[][] M2) {
        double max = Double.MIN_VALUE;
        int i_max = -1;
        int j_max = -1;
        for (int i = 0; i < M2.length; ++i) {
            for (int j = 0; j < M2[i].length; ++j) {
                if (!(M2[i][j] > max)) continue;
                max = M2[i][j];
                i_max = i;
                j_max = j;
            }
        }
        return new int[]{i_max, j_max};
    }

    public static void main(String[] args) {
        double E = 0.4;
        double Y = 0.6;
        System.out.println("dY " + E * Mat.dsigma(Y));
        double dY = E * (Mat.sigma(Y) * (1.0 - Mat.sigma(Y)));
        System.out.println("dY " + dY);
        System.out.println("" + Mat.sigma(1.0));
        System.out.println("" + Mat.sigma(-4.0));
        System.out.println("" + Mat.dsigma(-4.0));
        System.out.println("" + Mat.sigma(4.0));
        System.out.println("" + Mat.dsigma(4.0));
    }
}

