/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.ellipse;

import georegression.struct.point.Point2D_F32;
import georegression.struct.shapes.EllipseRotated_F32;

public class ClosestPointEllipseAngle_F32 {
    float tol;
    int maxIterations;
    Point2D_F32 closest = new Point2D_F32();
    EllipseRotated_F32 ellipse;
    float ce;
    float se;
    float theta;

    public ClosestPointEllipseAngle_F32(float tol, int maxIterations) {
        this.tol = tol;
        this.maxIterations = maxIterations;
    }

    public void setEllipse(EllipseRotated_F32 ellipse) {
        this.ellipse = ellipse;
        this.ce = (float)Math.cos(ellipse.phi);
        this.se = (float)Math.sin(ellipse.phi);
    }

    public void process(Point2D_F32 point) {
        float s;
        float c;
        float f;
        float xc = point.x - this.ellipse.center.x;
        float yc = point.y - this.ellipse.center.y;
        float x = this.ce * xc + this.se * yc;
        float y = -this.se * xc + this.ce * yc;
        this.theta = (float)Math.atan2(this.ellipse.a * y, this.ellipse.b * x);
        float a2_m_b2 = this.ellipse.a * this.ellipse.a - this.ellipse.b * this.ellipse.b;
        for (int i = 0; i < this.maxIterations && !(Math.abs(f = a2_m_b2 * (c = (float)Math.cos(this.theta)) * (s = (float)Math.sin(this.theta)) - x * this.ellipse.a * s + y * this.ellipse.b * c) < this.tol); ++i) {
            float d = a2_m_b2 * (c * c - s * s) - x * this.ellipse.a * c - y * this.ellipse.b * s;
            this.theta -= f / d;
        }
        x = this.ellipse.a * (float)Math.cos(this.theta);
        y = this.ellipse.b * (float)Math.sin(this.theta);
        this.closest.x = this.ce * x - this.se * y + this.ellipse.center.x;
        this.closest.y = this.se * x + this.ce * y + this.ellipse.center.y;
    }

    public Point2D_F32 getClosest() {
        return this.closest;
    }

    public float getTheta() {
        return this.theta;
    }
}

