/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Vector2D_F32;
import java.io.Serializable;

public class LineParametric2D_F32
implements Serializable {
    public Point2D_F32 p = new Point2D_F32();
    public Vector2D_F32 slope = new Vector2D_F32();

    public LineParametric2D_F32(float x_0, float y_0, float slopeX, float slopeY) {
        this.p.set(x_0, y_0);
        this.slope.set(slopeX, slopeY);
    }

    public LineParametric2D_F32(Point2D_F32 p, Vector2D_F32 slope) {
        this.setPoint(p);
        this.setSlope(slope);
    }

    public LineParametric2D_F32() {
    }

    public void set(LineParametric2D_F32 line) {
        this.p.set(line.p);
        this.slope.set(line.slope);
    }

    public void setPoint(Point2D_F32 pt) {
        this.p.set(pt);
    }

    public void setPoint(float x, float y) {
        this.p.x = x;
        this.p.y = y;
    }

    public void setSlope(Vector2D_F32 slope) {
        this.slope.set(slope);
    }

    public void setSlope(float slopeX, float slopeY) {
        this.slope.x = slopeX;
        this.slope.y = slopeY;
    }

    public void setAngle(float angle) {
        this.slope.set((float)Math.cos(angle), (float)Math.sin(angle));
    }

    public float getAngle() {
        return (float)Math.atan2(this.slope.y, this.slope.x);
    }

    public Point2D_F32 getPointOnLine(float t) {
        return new Point2D_F32(this.slope.x * t + this.p.x, this.slope.y * t + this.p.y);
    }

    public Point2D_F32 getPoint() {
        return this.p;
    }

    public final float getSlopeX() {
        return this.slope.x;
    }

    public final float getSlopeY() {
        return this.slope.y;
    }

    public final float getX() {
        return this.p.x;
    }

    public final float getY() {
        return this.p.y;
    }

    public Point2D_F32 getP() {
        return this.p;
    }

    public void setP(Point2D_F32 p) {
        this.p = p;
    }

    public Vector2D_F32 getSlope() {
        return this.slope;
    }

    public LineParametric2D_F32 copy() {
        return new LineParametric2D_F32(this.p, this.slope);
    }
}

