/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.concurrent.Future;
import org.jtransforms.dct.FloatDCT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;

public class FloatDCT_3D {
    private int slices;
    private long slicesl;
    private int rows;
    private long rowsl;
    private int columns;
    private long columnsl;
    private int sliceStride;
    private long sliceStridel;
    private int rowStride;
    private long rowStridel;
    private FloatDCT_1D dctSlices;
    private FloatDCT_1D dctRows;
    private FloatDCT_1D dctColumns;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDCT_3D(long l, long l2, long l3) {
        if (l <= 1L || l2 <= 1L || l3 <= 1L) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = (int)l;
        this.rows = (int)l2;
        this.columns = (int)l3;
        this.slicesl = l;
        this.rowsl = l2;
        this.columnsl = l3;
        this.sliceStride = (int)(l2 * l3);
        this.rowStride = (int)l3;
        this.sliceStridel = l2 * l3;
        this.rowStridel = l3;
        if (l * l2 * l3 >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(l) && ConcurrencyUtils.isPowerOf2(l2) && ConcurrencyUtils.isPowerOf2(l3)) {
            this.isPowerOfTwo = true;
        }
        long l4 = ConcurrencyUtils.getLargeArraysBeginN();
        if (l * l2 * l3 > 0x10000000L) {
            ConcurrencyUtils.setLargeArraysBeginN(Math.min(Math.min(l2, l3), l));
        }
        this.dctSlices = new FloatDCT_1D(l);
        this.dctRows = l == l2 ? this.dctSlices : new FloatDCT_1D(l2);
        this.dctColumns = l == l3 ? this.dctSlices : (l2 == l3 ? this.dctRows : new FloatDCT_1D(l3));
        ConcurrencyUtils.setLargeArraysBeginN(l4);
    }

    public void forward(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, fArray, bl);
                this.ddxt3db_subth(-1, fArray, bl);
            } else {
                this.ddxt3da_sub(-1, fArray, bl);
                this.ddxt3db_sub(-1, fArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.sliceStride;
                            for (int j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                FloatDCT_3D.this.dctColumns.forward(fArray, n + j * FloatDCT_3D.this.rowStride, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.sliceStride;
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < FloatDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * FloatDCT_3D.this.rowStride + j;
                                    fArray2[n32] = fArray[n22];
                                }
                                FloatDCT_3D.this.dctRows.forward(fArray2, bl);
                                for (n32 = 0; n32 < FloatDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * FloatDCT_3D.this.rowStride + j;
                                    fArray[n22] = fArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.rowStride;
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < FloatDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * FloatDCT_3D.this.sliceStride + n + j;
                                    fArray2[n32] = fArray[n22];
                                }
                                FloatDCT_3D.this.dctSlices.forward(fArray2, bl);
                                for (n32 = 0; n32 < FloatDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * FloatDCT_3D.this.sliceStride + n + j;
                                    fArray[n22] = fArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            for (int i = 0; i < this.slices; ++i) {
                n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dctColumns.forward(fArray, n10 + n9 * this.rowStride, bl);
                }
            }
            float[] fArray2 = new float[this.rows];
            for (n10 = 0; n10 < this.slices; ++n10) {
                n9 = n10 * this.sliceStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        fArray2[n7] = fArray[n6];
                    }
                    this.dctRows.forward(fArray2, bl);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        fArray[n6] = fArray2[n7];
                    }
                }
            }
            fArray2 = new float[this.slices];
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = n10 * this.rowStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        fArray2[n7] = fArray[n6];
                    }
                    this.dctSlices.forward(fArray2, bl);
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        fArray[n6] = fArray2[n7];
                    }
                }
            }
        }
    }

    public void forward(final FloatLargeArray floatLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, floatLargeArray, bl);
                this.ddxt3db_subth(-1, floatLargeArray, bl);
            } else {
                this.ddxt3da_sub(-1, floatLargeArray, bl);
                this.ddxt3db_sub(-1, floatLargeArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
            long l;
            long l2;
            int n2;
            Future[] futureArray = new Future[n];
            long l3 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.slicesl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l2; i < l; ++i) {
                            long l3 = i * FloatDCT_3D.this.sliceStridel;
                            for (long j = 0L; j < FloatDCT_3D.this.rowsl; ++j) {
                                FloatDCT_3D.this.dctColumns.forward(floatLargeArray, l3 + j * FloatDCT_3D.this.rowStridel, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.slicesl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(FloatDCT_3D.this.rowsl, false);
                        for (long i = l2; i < l; ++i) {
                            long l4 = i * FloatDCT_3D.this.sliceStridel;
                            for (long j = 0L; j < FloatDCT_3D.this.columnsl; ++j) {
                                long l22;
                                long l3;
                                for (l3 = 0L; l3 < FloatDCT_3D.this.rowsl; ++l3) {
                                    l22 = l4 + l3 * FloatDCT_3D.this.rowStridel + j;
                                    floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l22));
                                }
                                FloatDCT_3D.this.dctRows.forward(floatLargeArray2, bl);
                                for (l3 = 0L; l3 < FloatDCT_3D.this.rowsl; ++l3) {
                                    l22 = l4 + l3 * FloatDCT_3D.this.rowStridel + j;
                                    floatLargeArray.setFloat(l22, floatLargeArray2.getFloat(l3));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l3 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.rowsl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(FloatDCT_3D.this.slicesl, false);
                        for (long i = l2; i < l; ++i) {
                            long l4 = i * FloatDCT_3D.this.rowStridel;
                            for (long j = 0L; j < FloatDCT_3D.this.columnsl; ++j) {
                                long l22;
                                long l3;
                                for (l3 = 0L; l3 < FloatDCT_3D.this.slicesl; ++l3) {
                                    l22 = l3 * FloatDCT_3D.this.sliceStridel + l4 + j;
                                    floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l22));
                                }
                                FloatDCT_3D.this.dctSlices.forward(floatLargeArray2, bl);
                                for (l3 = 0L; l3 < FloatDCT_3D.this.slicesl; ++l3) {
                                    l22 = l3 * FloatDCT_3D.this.sliceStridel + l4 + j;
                                    floatLargeArray.setFloat(l22, floatLargeArray2.getFloat(l3));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l;
            long l4;
            long l5;
            long l6;
            long l7;
            for (long i = 0L; i < this.slicesl; ++i) {
                long l8 = i * this.sliceStridel;
                for (long j = 0L; j < this.rowsl; ++j) {
                    this.dctColumns.forward(floatLargeArray, l8 + j * this.rowStridel, bl);
                }
            }
            FloatLargeArray floatLargeArray2 = new FloatLargeArray(this.rowsl, false);
            for (l7 = 0L; l7 < this.slicesl; ++l7) {
                l6 = l7 * this.sliceStridel;
                for (l5 = 0L; l5 < this.columnsl; ++l5) {
                    for (l4 = 0L; l4 < this.rowsl; ++l4) {
                        l = l6 + l4 * this.rowStridel + l5;
                        floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l));
                    }
                    this.dctRows.forward(floatLargeArray2, bl);
                    for (l4 = 0L; l4 < this.rowsl; ++l4) {
                        l = l6 + l4 * this.rowStridel + l5;
                        floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l4));
                    }
                }
            }
            floatLargeArray2 = new FloatLargeArray(this.slicesl, false);
            for (l7 = 0L; l7 < this.rowsl; ++l7) {
                l6 = l7 * this.rowStridel;
                for (l5 = 0L; l5 < this.columnsl; ++l5) {
                    for (l4 = 0L; l4 < this.slicesl; ++l4) {
                        l = l4 * this.sliceStridel + l6 + l5;
                        floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l));
                    }
                    this.dctSlices.forward(floatLargeArray2, bl);
                    for (l4 = 0L; l4 < this.slicesl; ++l4) {
                        l = l4 * this.sliceStridel + l6 + l5;
                        floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l4));
                    }
                }
            }
        }
    }

    public void forward(final float[][][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, fArray, bl);
                this.ddxt3db_subth(-1, fArray, bl);
            } else {
                this.ddxt3da_sub(-1, fArray, bl);
                this.ddxt3db_sub(-1, fArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                FloatDCT_3D.this.dctColumns.forward(fArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < FloatDCT_3D.this.rows; ++n) {
                                    fArray2[n] = fArray[i][n][j];
                                }
                                FloatDCT_3D.this.dctRows.forward(fArray2, bl);
                                for (n = 0; n < FloatDCT_3D.this.rows; ++n) {
                                    fArray[i][n][j] = fArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < FloatDCT_3D.this.slices; ++n) {
                                    fArray2[n] = fArray[n][i][j];
                                }
                                FloatDCT_3D.this.dctSlices.forward(fArray2, bl);
                                for (n = 0; n < FloatDCT_3D.this.slices; ++n) {
                                    fArray[n][i][j] = fArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            for (int i = 0; i < this.slices; ++i) {
                for (n8 = 0; n8 < this.rows; ++n8) {
                    this.dctColumns.forward(fArray[i][n8], bl);
                }
            }
            float[] fArray2 = new float[this.rows];
            for (n8 = 0; n8 < this.slices; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray2[n6] = fArray[n8][n6][n7];
                    }
                    this.dctRows.forward(fArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray[n8][n6][n7] = fArray2[n6];
                    }
                }
            }
            fArray2 = new float[this.slices];
            for (n8 = 0; n8 < this.rows; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        fArray2[n6] = fArray[n6][n8][n7];
                    }
                    this.dctSlices.forward(fArray2, bl);
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        fArray[n6][n8][n7] = fArray2[n6];
                    }
                }
            }
        }
    }

    public void inverse(final float[] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, fArray, bl);
                this.ddxt3db_subth(1, fArray, bl);
            } else {
                this.ddxt3da_sub(1, fArray, bl);
                this.ddxt3db_sub(1, fArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.sliceStride;
                            for (int j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                FloatDCT_3D.this.dctColumns.inverse(fArray, n + j * FloatDCT_3D.this.rowStride, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.sliceStride;
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < FloatDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * FloatDCT_3D.this.rowStride + j;
                                    fArray2[n32] = fArray[n22];
                                }
                                FloatDCT_3D.this.dctRows.inverse(fArray2, bl);
                                for (n32 = 0; n32 < FloatDCT_3D.this.rows; ++n32) {
                                    n22 = n + n32 * FloatDCT_3D.this.rowStride + j;
                                    fArray[n22] = fArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            int n = i * FloatDCT_3D.this.rowStride;
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n22;
                                int n32;
                                for (n32 = 0; n32 < FloatDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * FloatDCT_3D.this.sliceStride + n + j;
                                    fArray2[n32] = fArray[n22];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(fArray2, bl);
                                for (n32 = 0; n32 < FloatDCT_3D.this.slices; ++n32) {
                                    n22 = n32 * FloatDCT_3D.this.sliceStride + n + j;
                                    fArray[n22] = fArray2[n32];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            for (int i = 0; i < this.slices; ++i) {
                n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dctColumns.inverse(fArray, n10 + n9 * this.rowStride, bl);
                }
            }
            float[] fArray2 = new float[this.rows];
            for (n10 = 0; n10 < this.slices; ++n10) {
                n9 = n10 * this.sliceStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        fArray2[n7] = fArray[n6];
                    }
                    this.dctRows.inverse(fArray2, bl);
                    for (n7 = 0; n7 < this.rows; ++n7) {
                        n6 = n9 + n7 * this.rowStride + n8;
                        fArray[n6] = fArray2[n7];
                    }
                }
            }
            fArray2 = new float[this.slices];
            for (n10 = 0; n10 < this.rows; ++n10) {
                n9 = n10 * this.rowStride;
                for (n8 = 0; n8 < this.columns; ++n8) {
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        fArray2[n7] = fArray[n6];
                    }
                    this.dctSlices.inverse(fArray2, bl);
                    for (n7 = 0; n7 < this.slices; ++n7) {
                        n6 = n7 * this.sliceStride + n9 + n8;
                        fArray[n6] = fArray2[n7];
                    }
                }
            }
        }
    }

    public void inverse(final FloatLargeArray floatLargeArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, floatLargeArray, bl);
                this.ddxt3db_subth(1, floatLargeArray, bl);
            } else {
                this.ddxt3da_sub(1, floatLargeArray, bl);
                this.ddxt3db_sub(1, floatLargeArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slicesl >= (long)n && this.rowsl >= (long)n && this.columnsl >= (long)n) {
            long l;
            long l2;
            int n2;
            Future[] futureArray = new Future[n];
            long l3 = this.slicesl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.slicesl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long i = l2; i < l; ++i) {
                            long l3 = i * FloatDCT_3D.this.sliceStridel;
                            for (long j = 0L; j < FloatDCT_3D.this.rowsl; ++j) {
                                FloatDCT_3D.this.dctColumns.inverse(floatLargeArray, l3 + j * FloatDCT_3D.this.rowStridel, bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.slicesl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(FloatDCT_3D.this.rowsl, false);
                        for (long i = l2; i < l; ++i) {
                            long l4 = i * FloatDCT_3D.this.sliceStridel;
                            for (long j = 0L; j < FloatDCT_3D.this.columnsl; ++j) {
                                long l22;
                                long l3;
                                for (l3 = 0L; l3 < FloatDCT_3D.this.rowsl; ++l3) {
                                    l22 = l4 + l3 * FloatDCT_3D.this.rowStridel + j;
                                    floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l22));
                                }
                                FloatDCT_3D.this.dctRows.inverse(floatLargeArray2, bl);
                                for (l3 = 0L; l3 < FloatDCT_3D.this.rowsl; ++l3) {
                                    l22 = l4 + l3 * FloatDCT_3D.this.rowStridel + j;
                                    floatLargeArray.setFloat(l22, floatLargeArray2.getFloat(l3));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            l3 = this.rowsl / (long)n;
            for (n2 = 0; n2 < n; ++n2) {
                l2 = (long)n2 * l3;
                l = n2 == n - 1 ? this.rowsl : l2 + l3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        FloatLargeArray floatLargeArray2 = new FloatLargeArray(FloatDCT_3D.this.slicesl, false);
                        for (long i = l2; i < l; ++i) {
                            long l4 = i * FloatDCT_3D.this.rowStridel;
                            for (long j = 0L; j < FloatDCT_3D.this.columnsl; ++j) {
                                long l22;
                                long l3;
                                for (l3 = 0L; l3 < FloatDCT_3D.this.slicesl; ++l3) {
                                    l22 = l3 * FloatDCT_3D.this.sliceStridel + l4 + j;
                                    floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l22));
                                }
                                FloatDCT_3D.this.dctSlices.inverse(floatLargeArray2, bl);
                                for (l3 = 0L; l3 < FloatDCT_3D.this.slicesl; ++l3) {
                                    l22 = l3 * FloatDCT_3D.this.sliceStridel + l4 + j;
                                    floatLargeArray.setFloat(l22, floatLargeArray2.getFloat(l3));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            long l;
            long l4;
            long l5;
            long l6;
            long l7;
            for (long i = 0L; i < this.slicesl; ++i) {
                long l8 = i * this.sliceStridel;
                for (long j = 0L; j < this.rowsl; ++j) {
                    this.dctColumns.inverse(floatLargeArray, l8 + j * this.rowStridel, bl);
                }
            }
            FloatLargeArray floatLargeArray2 = new FloatLargeArray(this.rowsl, false);
            for (l7 = 0L; l7 < this.slicesl; ++l7) {
                l6 = l7 * this.sliceStridel;
                for (l5 = 0L; l5 < this.columnsl; ++l5) {
                    for (l4 = 0L; l4 < this.rowsl; ++l4) {
                        l = l6 + l4 * this.rowStridel + l5;
                        floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l));
                    }
                    this.dctRows.inverse(floatLargeArray2, bl);
                    for (l4 = 0L; l4 < this.rowsl; ++l4) {
                        l = l6 + l4 * this.rowStridel + l5;
                        floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l4));
                    }
                }
            }
            floatLargeArray2 = new FloatLargeArray(this.slicesl, false);
            for (l7 = 0L; l7 < this.rowsl; ++l7) {
                l6 = l7 * this.rowStridel;
                for (l5 = 0L; l5 < this.columnsl; ++l5) {
                    for (l4 = 0L; l4 < this.slicesl; ++l4) {
                        l = l4 * this.sliceStridel + l6 + l5;
                        floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l));
                    }
                    this.dctSlices.inverse(floatLargeArray2, bl);
                    for (l4 = 0L; l4 < this.slicesl; ++l4) {
                        l = l4 * this.sliceStridel + l6 + l5;
                        floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l4));
                    }
                }
            }
        }
    }

    public void inverse(final float[][][] fArray, final boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (n > 1 && this.useThreads) {
                this.ddxt3da_subth(1, fArray, bl);
                this.ddxt3db_subth(1, fArray, bl);
            } else {
                this.ddxt3da_sub(1, fArray, bl);
                this.ddxt3db_sub(1, fArray, bl);
            }
        } else if (n > 1 && this.useThreads && this.slices >= n && this.rows >= n && this.columns >= n) {
            int n2;
            int n3;
            int n4;
            Future[] futureArray = new Future[n];
            int n5 = this.slices / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                FloatDCT_3D.this.dctColumns.inverse(fArray[i][j], bl);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.slices : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.rows];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < FloatDCT_3D.this.rows; ++n) {
                                    fArray2[n] = fArray[i][n][j];
                                }
                                FloatDCT_3D.this.dctRows.inverse(fArray2, bl);
                                for (n = 0; n < FloatDCT_3D.this.rows; ++n) {
                                    fArray[i][n][j] = fArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            n5 = this.rows / n;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = n4 * n5;
                n2 = n4 == n - 1 ? this.rows : n3 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] fArray2 = new float[FloatDCT_3D.this.slices];
                        for (int i = n3; i < n2; ++i) {
                            for (int j = 0; j < FloatDCT_3D.this.columns; ++j) {
                                int n;
                                for (n = 0; n < FloatDCT_3D.this.slices; ++n) {
                                    fArray2[n] = fArray[n][i][j];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(fArray2, bl);
                                for (n = 0; n < FloatDCT_3D.this.slices; ++n) {
                                    fArray[n][i][j] = fArray2[n];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6;
            int n7;
            int n8;
            for (int i = 0; i < this.slices; ++i) {
                for (n8 = 0; n8 < this.rows; ++n8) {
                    this.dctColumns.inverse(fArray[i][n8], bl);
                }
            }
            float[] fArray2 = new float[this.rows];
            for (n8 = 0; n8 < this.slices; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray2[n6] = fArray[n8][n6][n7];
                    }
                    this.dctRows.inverse(fArray2, bl);
                    for (n6 = 0; n6 < this.rows; ++n6) {
                        fArray[n8][n6][n7] = fArray2[n6];
                    }
                }
            }
            fArray2 = new float[this.slices];
            for (n8 = 0; n8 < this.rows; ++n8) {
                for (n7 = 0; n7 < this.columns; ++n7) {
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        fArray2[n6] = fArray[n6][n8][n7];
                    }
                    this.dctSlices.inverse(fArray2, bl);
                    for (n6 = 0; n6 < this.slices; ++n6) {
                        fArray[n6][n8][n7] = fArray2[n6];
                    }
                }
            }
        }
    }

    private void ddxt3da_sub(int n, float[] fArray, boolean bl) {
        int n2 = 4 * this.rows;
        if (this.columns == 2) {
            n2 >>= 1;
        }
        float[] fArray2 = new float[n2];
        if (n == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                int n4;
                int n5 = i * this.sliceStride;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    this.dctColumns.forward(fArray, n5 + n4 * this.rowStride, bl);
                }
                if (this.columns > 2) {
                    for (n4 = 0; n4 < this.columns; n4 += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n3 = n5 + n7 * this.rowStride + n4;
                            n6 = this.rows + n7;
                            fArray2[n7] = fArray[n3];
                            fArray2[n6] = fArray[n3 + 1];
                            fArray2[n6 + this.rows] = fArray[n3 + 2];
                            fArray2[n6 + 2 * this.rows] = fArray[n3 + 3];
                        }
                        this.dctRows.forward(fArray2, 0, bl);
                        this.dctRows.forward(fArray2, this.rows, bl);
                        this.dctRows.forward(fArray2, 2 * this.rows, bl);
                        this.dctRows.forward(fArray2, 3 * this.rows, bl);
                        for (n7 = 0; n7 < this.rows; ++n7) {
                            n3 = n5 + n7 * this.rowStride + n4;
                            n6 = this.rows + n7;
                            fArray[n3] = fArray2[n7];
                            fArray[n3 + 1] = fArray2[n6];
                            fArray[n3 + 2] = fArray2[n6 + this.rows];
                            fArray[n3 + 3] = fArray2[n6 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n5 + n4 * this.rowStride;
                    fArray2[n4] = fArray[n3];
                    fArray2[this.rows + n4] = fArray[n3 + 1];
                }
                this.dctRows.forward(fArray2, 0, bl);
                this.dctRows.forward(fArray2, this.rows, bl);
                for (n4 = 0; n4 < this.rows; ++n4) {
                    n3 = n5 + n4 * this.rowStride;
                    fArray[n3] = fArray2[n4];
                    fArray[n3 + 1] = fArray2[this.rows + n4];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n8;
                int n9;
                int n10 = i * this.sliceStride;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    this.dctColumns.inverse(fArray, n10 + n9 * this.rowStride, bl);
                }
                if (this.columns > 2) {
                    for (n9 = 0; n9 < this.columns; n9 += 4) {
                        int n11;
                        int n12;
                        for (n12 = 0; n12 < this.rows; ++n12) {
                            n8 = n10 + n12 * this.rowStride + n9;
                            n11 = this.rows + n12;
                            fArray2[n12] = fArray[n8];
                            fArray2[n11] = fArray[n8 + 1];
                            fArray2[n11 + this.rows] = fArray[n8 + 2];
                            fArray2[n11 + 2 * this.rows] = fArray[n8 + 3];
                        }
                        this.dctRows.inverse(fArray2, 0, bl);
                        this.dctRows.inverse(fArray2, this.rows, bl);
                        this.dctRows.inverse(fArray2, 2 * this.rows, bl);
                        this.dctRows.inverse(fArray2, 3 * this.rows, bl);
                        for (n12 = 0; n12 < this.rows; ++n12) {
                            n8 = n10 + n12 * this.rowStride + n9;
                            n11 = this.rows + n12;
                            fArray[n8] = fArray2[n12];
                            fArray[n8 + 1] = fArray2[n11];
                            fArray[n8 + 2] = fArray2[n11 + this.rows];
                            fArray[n8 + 3] = fArray2[n11 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n9 = 0; n9 < this.rows; ++n9) {
                    n8 = n10 + n9 * this.rowStride;
                    fArray2[n9] = fArray[n8];
                    fArray2[this.rows + n9] = fArray[n8 + 1];
                }
                this.dctRows.inverse(fArray2, 0, bl);
                this.dctRows.inverse(fArray2, this.rows, bl);
                for (n9 = 0; n9 < this.rows; ++n9) {
                    n8 = n10 + n9 * this.rowStride;
                    fArray[n8] = fArray2[n9];
                    fArray[n8 + 1] = fArray2[this.rows + n9];
                }
            }
        }
    }

    private void ddxt3da_sub(int n, FloatLargeArray floatLargeArray, boolean bl) {
        long l = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        FloatLargeArray floatLargeArray2 = new FloatLargeArray(l, false);
        if (n == -1) {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l2;
                long l3;
                long l4 = i * this.sliceStridel;
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    this.dctColumns.forward(floatLargeArray, l4 + l3 * this.rowStridel, bl);
                }
                if (this.columnsl > 2L) {
                    for (l3 = 0L; l3 < this.columnsl; l3 += 4L) {
                        long l5;
                        long l6;
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l2 = l4 + l6 * this.rowStridel + l3;
                            l5 = this.rowsl + l6;
                            floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l2));
                            floatLargeArray2.setFloat(l5, floatLargeArray.getFloat(l2 + 1L));
                            floatLargeArray2.setFloat(l5 + this.rowsl, floatLargeArray.getFloat(l2 + 2L));
                            floatLargeArray2.setFloat(l5 + 2L * this.rowsl, floatLargeArray.getFloat(l2 + 3L));
                        }
                        this.dctRows.forward(floatLargeArray2, 0L, bl);
                        this.dctRows.forward(floatLargeArray2, this.rowsl, bl);
                        this.dctRows.forward(floatLargeArray2, 2L * this.rowsl, bl);
                        this.dctRows.forward(floatLargeArray2, 3L * this.rowsl, bl);
                        for (l6 = 0L; l6 < this.rowsl; ++l6) {
                            l2 = l4 + l6 * this.rowStridel + l3;
                            l5 = this.rowsl + l6;
                            floatLargeArray.setFloat(l2, floatLargeArray2.getFloat(l6));
                            floatLargeArray.setFloat(l2 + 1L, floatLargeArray2.getFloat(l5));
                            floatLargeArray.setFloat(l2 + 2L, floatLargeArray2.getFloat(l5 + this.rowsl));
                            floatLargeArray.setFloat(l2 + 3L, floatLargeArray2.getFloat(l5 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l4 + l3 * this.rowStridel;
                    floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l2));
                    floatLargeArray2.setFloat(this.rowsl + l3, floatLargeArray.getFloat(l2 + 1L));
                }
                this.dctRows.forward(floatLargeArray2, 0L, bl);
                this.dctRows.forward(floatLargeArray2, this.rowsl, bl);
                for (l3 = 0L; l3 < this.rowsl; ++l3) {
                    l2 = l4 + l3 * this.rowStridel;
                    floatLargeArray.setFloat(l2, floatLargeArray2.getFloat(l3));
                    floatLargeArray.setFloat(l2 + 1L, floatLargeArray2.getFloat(this.rowsl + l3));
                }
            }
        } else {
            for (long i = 0L; i < this.slicesl; ++i) {
                long l7;
                long l8;
                long l9 = i * this.sliceStridel;
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    this.dctColumns.inverse(floatLargeArray, l9 + l8 * this.rowStridel, bl);
                }
                if (this.columnsl > 2L) {
                    for (l8 = 0L; l8 < this.columnsl; l8 += 4L) {
                        long l10;
                        long l11;
                        for (l11 = 0L; l11 < this.rowsl; ++l11) {
                            l7 = l9 + l11 * this.rowStridel + l8;
                            l10 = this.rowsl + l11;
                            floatLargeArray2.setFloat(l11, floatLargeArray.getFloat(l7));
                            floatLargeArray2.setFloat(l10, floatLargeArray.getFloat(l7 + 1L));
                            floatLargeArray2.setFloat(l10 + this.rowsl, floatLargeArray.getFloat(l7 + 2L));
                            floatLargeArray2.setFloat(l10 + 2L * this.rowsl, floatLargeArray.getFloat(l7 + 3L));
                        }
                        this.dctRows.inverse(floatLargeArray2, 0L, bl);
                        this.dctRows.inverse(floatLargeArray2, this.rowsl, bl);
                        this.dctRows.inverse(floatLargeArray2, 2L * this.rowsl, bl);
                        this.dctRows.inverse(floatLargeArray2, 3L * this.rowsl, bl);
                        for (l11 = 0L; l11 < this.rowsl; ++l11) {
                            l7 = l9 + l11 * this.rowStridel + l8;
                            l10 = this.rowsl + l11;
                            floatLargeArray.setFloat(l7, floatLargeArray2.getFloat(l11));
                            floatLargeArray.setFloat(l7 + 1L, floatLargeArray2.getFloat(l10));
                            floatLargeArray.setFloat(l7 + 2L, floatLargeArray2.getFloat(l10 + this.rowsl));
                            floatLargeArray.setFloat(l7 + 3L, floatLargeArray2.getFloat(l10 + 2L * this.rowsl));
                        }
                    }
                    continue;
                }
                if (this.columnsl != 2L) continue;
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    l7 = l9 + l8 * this.rowStridel;
                    floatLargeArray2.setFloat(l8, floatLargeArray.getFloat(l7));
                    floatLargeArray2.setFloat(this.rowsl + l8, floatLargeArray.getFloat(l7 + 1L));
                }
                this.dctRows.inverse(floatLargeArray2, 0L, bl);
                this.dctRows.inverse(floatLargeArray2, this.rowsl, bl);
                for (l8 = 0L; l8 < this.rowsl; ++l8) {
                    l7 = l9 + l8 * this.rowStridel;
                    floatLargeArray.setFloat(l7, floatLargeArray2.getFloat(l8));
                    floatLargeArray.setFloat(l7 + 1L, floatLargeArray2.getFloat(this.rowsl + l8));
                }
            }
        }
    }

    private void ddxt3da_sub(int n, float[][][] fArray, boolean bl) {
        int n2 = 4 * this.rows;
        if (this.columns == 2) {
            n2 >>= 1;
        }
        float[] fArray2 = new float[n2];
        if (n == -1) {
            for (int i = 0; i < this.slices; ++i) {
                int n3;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    this.dctColumns.forward(fArray[i][n3], bl);
                }
                if (this.columns > 2) {
                    for (n3 = 0; n3 < this.columns; n3 += 4) {
                        int n4;
                        int n5;
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            fArray2[n5] = fArray[i][n5][n3];
                            fArray2[n4] = fArray[i][n5][n3 + 1];
                            fArray2[n4 + this.rows] = fArray[i][n5][n3 + 2];
                            fArray2[n4 + 2 * this.rows] = fArray[i][n5][n3 + 3];
                        }
                        this.dctRows.forward(fArray2, 0, bl);
                        this.dctRows.forward(fArray2, this.rows, bl);
                        this.dctRows.forward(fArray2, 2 * this.rows, bl);
                        this.dctRows.forward(fArray2, 3 * this.rows, bl);
                        for (n5 = 0; n5 < this.rows; ++n5) {
                            n4 = this.rows + n5;
                            fArray[i][n5][n3] = fArray2[n5];
                            fArray[i][n5][n3 + 1] = fArray2[n4];
                            fArray[i][n5][n3 + 2] = fArray2[n4 + this.rows];
                            fArray[i][n5][n3 + 3] = fArray2[n4 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n3 = 0; n3 < this.rows; ++n3) {
                    fArray2[n3] = fArray[i][n3][0];
                    fArray2[this.rows + n3] = fArray[i][n3][1];
                }
                this.dctRows.forward(fArray2, 0, bl);
                this.dctRows.forward(fArray2, this.rows, bl);
                for (n3 = 0; n3 < this.rows; ++n3) {
                    fArray[i][n3][0] = fArray2[n3];
                    fArray[i][n3][1] = fArray2[this.rows + n3];
                }
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int n6;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    this.dctColumns.inverse(fArray[i][n6], bl);
                }
                if (this.columns > 2) {
                    for (n6 = 0; n6 < this.columns; n6 += 4) {
                        int n7;
                        int n8;
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n7 = this.rows + n8;
                            fArray2[n8] = fArray[i][n8][n6];
                            fArray2[n7] = fArray[i][n8][n6 + 1];
                            fArray2[n7 + this.rows] = fArray[i][n8][n6 + 2];
                            fArray2[n7 + 2 * this.rows] = fArray[i][n8][n6 + 3];
                        }
                        this.dctRows.inverse(fArray2, 0, bl);
                        this.dctRows.inverse(fArray2, this.rows, bl);
                        this.dctRows.inverse(fArray2, 2 * this.rows, bl);
                        this.dctRows.inverse(fArray2, 3 * this.rows, bl);
                        for (n8 = 0; n8 < this.rows; ++n8) {
                            n7 = this.rows + n8;
                            fArray[i][n8][n6] = fArray2[n8];
                            fArray[i][n8][n6 + 1] = fArray2[n7];
                            fArray[i][n8][n6 + 2] = fArray2[n7 + this.rows];
                            fArray[i][n8][n6 + 3] = fArray2[n7 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray2[n6] = fArray[i][n6][0];
                    fArray2[this.rows + n6] = fArray[i][n6][1];
                }
                this.dctRows.inverse(fArray2, 0, bl);
                this.dctRows.inverse(fArray2, this.rows, bl);
                for (n6 = 0; n6 < this.rows; ++n6) {
                    fArray[i][n6][0] = fArray2[n6];
                    fArray[i][n6][1] = fArray2[this.rows + n6];
                }
            }
        }
    }

    private void ddxt3db_sub(int n, float[] fArray, boolean bl) {
        block20: {
            float[] fArray2;
            block18: {
                block19: {
                    int n2 = 4 * this.slices;
                    if (this.columns == 2) {
                        n2 >>= 1;
                    }
                    fArray2 = new float[n2];
                    if (n != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int i = 0; i < this.rows; ++i) {
                        int n3 = i * this.rowStride;
                        for (int j = 0; j < this.columns; j += 4) {
                            int n4;
                            int n5;
                            int n6;
                            for (n6 = 0; n6 < this.slices; ++n6) {
                                n5 = n6 * this.sliceStride + n3 + j;
                                n4 = this.slices + n6;
                                fArray2[n6] = fArray[n5];
                                fArray2[n4] = fArray[n5 + 1];
                                fArray2[n4 + this.slices] = fArray[n5 + 2];
                                fArray2[n4 + 2 * this.slices] = fArray[n5 + 3];
                            }
                            this.dctSlices.forward(fArray2, 0, bl);
                            this.dctSlices.forward(fArray2, this.slices, bl);
                            this.dctSlices.forward(fArray2, 2 * this.slices, bl);
                            this.dctSlices.forward(fArray2, 3 * this.slices, bl);
                            for (n6 = 0; n6 < this.slices; ++n6) {
                                n5 = n6 * this.sliceStride + n3 + j;
                                n4 = this.slices + n6;
                                fArray[n5] = fArray2[n6];
                                fArray[n5 + 1] = fArray2[n4];
                                fArray[n5 + 2] = fArray2[n4 + this.slices];
                                fArray[n5 + 3] = fArray2[n4 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int i = 0; i < this.rows; ++i) {
                    int n7;
                    int n8;
                    int n9 = i * this.rowStride;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = n8 * this.sliceStride + n9;
                        fArray2[n8] = fArray[n7];
                        fArray2[this.slices + n8] = fArray[n7 + 1];
                    }
                    this.dctSlices.forward(fArray2, 0, bl);
                    this.dctSlices.forward(fArray2, this.slices, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        n7 = n8 * this.sliceStride + n9;
                        fArray[n7] = fArray2[n8];
                        fArray[n7 + 1] = fArray2[this.slices + n8];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n10 = i * this.rowStride;
                    for (int j = 0; j < this.columns; j += 4) {
                        int n11;
                        int n12;
                        int n13;
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n10 + j;
                            n11 = this.slices + n13;
                            fArray2[n13] = fArray[n12];
                            fArray2[n11] = fArray[n12 + 1];
                            fArray2[n11 + this.slices] = fArray[n12 + 2];
                            fArray2[n11 + 2 * this.slices] = fArray[n12 + 3];
                        }
                        this.dctSlices.inverse(fArray2, 0, bl);
                        this.dctSlices.inverse(fArray2, this.slices, bl);
                        this.dctSlices.inverse(fArray2, 2 * this.slices, bl);
                        this.dctSlices.inverse(fArray2, 3 * this.slices, bl);
                        for (n13 = 0; n13 < this.slices; ++n13) {
                            n12 = n13 * this.sliceStride + n10 + j;
                            n11 = this.slices + n13;
                            fArray[n12] = fArray2[n13];
                            fArray[n12 + 1] = fArray2[n11];
                            fArray[n12 + 2] = fArray2[n11 + this.slices];
                            fArray[n12 + 3] = fArray2[n11 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n14;
                    int n15;
                    int n16 = i * this.rowStride;
                    for (n15 = 0; n15 < this.slices; ++n15) {
                        n14 = n15 * this.sliceStride + n16;
                        fArray2[n15] = fArray[n14];
                        fArray2[this.slices + n15] = fArray[n14 + 1];
                    }
                    this.dctSlices.inverse(fArray2, 0, bl);
                    this.dctSlices.inverse(fArray2, this.slices, bl);
                    for (n15 = 0; n15 < this.slices; ++n15) {
                        n14 = n15 * this.sliceStride + n16;
                        fArray[n14] = fArray2[n15];
                        fArray[n14 + 1] = fArray2[this.slices + n15];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, FloatLargeArray floatLargeArray, boolean bl) {
        block20: {
            FloatLargeArray floatLargeArray2;
            block18: {
                block19: {
                    long l = 4L * this.slicesl;
                    if (this.columnsl == 2L) {
                        l >>= 1;
                    }
                    floatLargeArray2 = new FloatLargeArray(l, false);
                    if (n != -1) break block18;
                    if (this.columnsl <= 2L) break block19;
                    for (long i = 0L; i < this.rowsl; ++i) {
                        long l2 = i * this.rowStridel;
                        for (long j = 0L; j < this.columnsl; j += 4L) {
                            long l3;
                            long l4;
                            long l5;
                            for (l5 = 0L; l5 < this.slicesl; ++l5) {
                                l4 = l5 * this.sliceStridel + l2 + j;
                                l3 = this.slicesl + l5;
                                floatLargeArray2.setFloat(l5, floatLargeArray.getFloat(l4));
                                floatLargeArray2.setFloat(l3, floatLargeArray.getFloat(l4 + 1L));
                                floatLargeArray2.setFloat(l3 + this.slicesl, floatLargeArray.getFloat(l4 + 2L));
                                floatLargeArray2.setFloat(l3 + 2L * this.slicesl, floatLargeArray.getFloat(l4 + 3L));
                            }
                            this.dctSlices.forward(floatLargeArray2, 0L, bl);
                            this.dctSlices.forward(floatLargeArray2, this.slicesl, bl);
                            this.dctSlices.forward(floatLargeArray2, 2L * this.slicesl, bl);
                            this.dctSlices.forward(floatLargeArray2, 3L * this.slicesl, bl);
                            for (l5 = 0L; l5 < this.slicesl; ++l5) {
                                l4 = l5 * this.sliceStridel + l2 + j;
                                l3 = this.slicesl + l5;
                                floatLargeArray.setFloat(l4, floatLargeArray2.getFloat(l5));
                                floatLargeArray.setFloat(l4 + 1L, floatLargeArray2.getFloat(l3));
                                floatLargeArray.setFloat(l4 + 2L, floatLargeArray2.getFloat(l3 + this.slicesl));
                                floatLargeArray.setFloat(l4 + 3L, floatLargeArray2.getFloat(l3 + 2L * this.slicesl));
                            }
                        }
                    }
                    break block20;
                }
                if (this.columnsl != 2L) break block20;
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l6;
                    long l7 = i * this.rowStridel;
                    for (l6 = 0L; l6 < this.slicesl; ++l6) {
                        l = l6 * this.sliceStridel + l7;
                        floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l));
                        floatLargeArray2.setFloat(this.slicesl + l6, floatLargeArray.getFloat(l + 1L));
                    }
                    this.dctSlices.forward(floatLargeArray2, 0L, bl);
                    this.dctSlices.forward(floatLargeArray2, this.slicesl, bl);
                    for (l6 = 0L; l6 < this.slicesl; ++l6) {
                        l = l6 * this.sliceStridel + l7;
                        floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l6));
                        floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(this.slicesl + l6));
                    }
                }
                break block20;
            }
            if (this.columnsl > 2L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l = i * this.rowStridel;
                    for (long j = 0L; j < this.columnsl; j += 4L) {
                        long l8;
                        long l9;
                        long l10;
                        for (l10 = 0L; l10 < this.slicesl; ++l10) {
                            l9 = l10 * this.sliceStridel + l + j;
                            l8 = this.slicesl + l10;
                            floatLargeArray2.setFloat(l10, floatLargeArray.getFloat(l9));
                            floatLargeArray2.setFloat(l8, floatLargeArray.getFloat(l9 + 1L));
                            floatLargeArray2.setFloat(l8 + this.slicesl, floatLargeArray.getFloat(l9 + 2L));
                            floatLargeArray2.setFloat(l8 + 2L * this.slicesl, floatLargeArray.getFloat(l9 + 3L));
                        }
                        this.dctSlices.inverse(floatLargeArray2, 0L, bl);
                        this.dctSlices.inverse(floatLargeArray2, this.slicesl, bl);
                        this.dctSlices.inverse(floatLargeArray2, 2L * this.slicesl, bl);
                        this.dctSlices.inverse(floatLargeArray2, 3L * this.slicesl, bl);
                        for (l10 = 0L; l10 < this.slicesl; ++l10) {
                            l9 = l10 * this.sliceStridel + l + j;
                            l8 = this.slicesl + l10;
                            floatLargeArray.setFloat(l9, floatLargeArray2.getFloat(l10));
                            floatLargeArray.setFloat(l9 + 1L, floatLargeArray2.getFloat(l8));
                            floatLargeArray.setFloat(l9 + 2L, floatLargeArray2.getFloat(l8 + this.slicesl));
                            floatLargeArray.setFloat(l9 + 3L, floatLargeArray2.getFloat(l8 + 2L * this.slicesl));
                        }
                    }
                }
            } else if (this.columnsl == 2L) {
                for (long i = 0L; i < this.rowsl; ++i) {
                    long l;
                    long l11;
                    long l12 = i * this.rowStridel;
                    for (l11 = 0L; l11 < this.slicesl; ++l11) {
                        l = l11 * this.sliceStridel + l12;
                        floatLargeArray2.setFloat(l11, floatLargeArray.getFloat(l));
                        floatLargeArray2.setFloat(this.slicesl + l11, floatLargeArray.getFloat(l + 1L));
                    }
                    this.dctSlices.inverse(floatLargeArray2, 0L, bl);
                    this.dctSlices.inverse(floatLargeArray2, this.slicesl, bl);
                    for (l11 = 0L; l11 < this.slicesl; ++l11) {
                        l = l11 * this.sliceStridel + l12;
                        floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l11));
                        floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(this.slicesl + l11));
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int n, float[][][] fArray, boolean bl) {
        block20: {
            float[] fArray2;
            block18: {
                block19: {
                    int n2 = 4 * this.slices;
                    if (this.columns == 2) {
                        n2 >>= 1;
                    }
                    fArray2 = new float[n2];
                    if (n != -1) break block18;
                    if (this.columns <= 2) break block19;
                    for (int i = 0; i < this.rows; ++i) {
                        for (int j = 0; j < this.columns; j += 4) {
                            int n3;
                            int n4;
                            for (n4 = 0; n4 < this.slices; ++n4) {
                                n3 = this.slices + n4;
                                fArray2[n4] = fArray[n4][i][j];
                                fArray2[n3] = fArray[n4][i][j + 1];
                                fArray2[n3 + this.slices] = fArray[n4][i][j + 2];
                                fArray2[n3 + 2 * this.slices] = fArray[n4][i][j + 3];
                            }
                            this.dctSlices.forward(fArray2, 0, bl);
                            this.dctSlices.forward(fArray2, this.slices, bl);
                            this.dctSlices.forward(fArray2, 2 * this.slices, bl);
                            this.dctSlices.forward(fArray2, 3 * this.slices, bl);
                            for (n4 = 0; n4 < this.slices; ++n4) {
                                n3 = this.slices + n4;
                                fArray[n4][i][j] = fArray2[n4];
                                fArray[n4][i][j + 1] = fArray2[n3];
                                fArray[n4][i][j + 2] = fArray2[n3 + this.slices];
                                fArray[n4][i][j + 3] = fArray2[n3 + 2 * this.slices];
                            }
                        }
                    }
                    break block20;
                }
                if (this.columns != 2) break block20;
                for (int i = 0; i < this.rows; ++i) {
                    int n5;
                    for (n5 = 0; n5 < this.slices; ++n5) {
                        fArray2[n5] = fArray[n5][i][0];
                        fArray2[this.slices + n5] = fArray[n5][i][1];
                    }
                    this.dctSlices.forward(fArray2, 0, bl);
                    this.dctSlices.forward(fArray2, this.slices, bl);
                    for (n5 = 0; n5 < this.slices; ++n5) {
                        fArray[n5][i][0] = fArray2[n5];
                        fArray[n5][i][1] = fArray2[this.slices + n5];
                    }
                }
                break block20;
            }
            if (this.columns > 2) {
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.columns; j += 4) {
                        int n6;
                        int n7;
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = this.slices + n7;
                            fArray2[n7] = fArray[n7][i][j];
                            fArray2[n6] = fArray[n7][i][j + 1];
                            fArray2[n6 + this.slices] = fArray[n7][i][j + 2];
                            fArray2[n6 + 2 * this.slices] = fArray[n7][i][j + 3];
                        }
                        this.dctSlices.inverse(fArray2, 0, bl);
                        this.dctSlices.inverse(fArray2, this.slices, bl);
                        this.dctSlices.inverse(fArray2, 2 * this.slices, bl);
                        this.dctSlices.inverse(fArray2, 3 * this.slices, bl);
                        for (n7 = 0; n7 < this.slices; ++n7) {
                            n6 = this.slices + n7;
                            fArray[n7][i][j] = fArray2[n7];
                            fArray[n7][i][j + 1] = fArray2[n6];
                            fArray[n7][i][j + 2] = fArray2[n6 + this.slices];
                            fArray[n7][i][j + 3] = fArray2[n6 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int i = 0; i < this.rows; ++i) {
                    int n8;
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        fArray2[n8] = fArray[n8][i][0];
                        fArray2[this.slices + n8] = fArray[n8][i][1];
                    }
                    this.dctSlices.inverse(fArray2, 0, bl);
                    this.dctSlices.inverse(fArray2, this.slices, bl);
                    for (n8 = 0; n8 < this.slices; ++n8) {
                        fArray[n8][i][0] = fArray2[n8];
                        fArray[n8][i][1] = fArray2[this.slices + n8];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int n, final float[] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        Future[] futureArray = new Future[n2];
        final int n4 = n3;
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] fArray2 = new float[n4];
                    if (n == -1) {
                        for (int i = n5; i < FloatDCT_3D.this.slices; i += n2) {
                            int n10;
                            int n22;
                            int n3 = i * FloatDCT_3D.this.sliceStride;
                            for (n22 = 0; n22 < FloatDCT_3D.this.rows; ++n22) {
                                FloatDCT_3D.this.dctColumns.forward(fArray, n3 + n22 * FloatDCT_3D.this.rowStride, bl);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (n22 = 0; n22 < FloatDCT_3D.this.columns; n22 += 4) {
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < FloatDCT_3D.this.rows; ++n52) {
                                        n10 = n3 + n52 * FloatDCT_3D.this.rowStride + n22;
                                        n42 = FloatDCT_3D.this.rows + n52;
                                        fArray2[n52] = fArray[n10];
                                        fArray2[n42] = fArray[n10 + 1];
                                        fArray2[n42 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[n10 + 2];
                                        fArray2[n42 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[n10 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.forward(fArray2, 0, bl);
                                    FloatDCT_3D.this.dctRows.forward(fArray2, FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.forward(fArray2, 2 * FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.forward(fArray2, 3 * FloatDCT_3D.this.rows, bl);
                                    for (n52 = 0; n52 < FloatDCT_3D.this.rows; ++n52) {
                                        n10 = n3 + n52 * FloatDCT_3D.this.rowStride + n22;
                                        n42 = FloatDCT_3D.this.rows + n52;
                                        fArray[n10] = fArray2[n52];
                                        fArray[n10 + 1] = fArray2[n42];
                                        fArray[n10 + 2] = fArray2[n42 + FloatDCT_3D.this.rows];
                                        fArray[n10 + 3] = fArray2[n42 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (n22 = 0; n22 < FloatDCT_3D.this.rows; ++n22) {
                                n10 = n3 + n22 * FloatDCT_3D.this.rowStride;
                                fArray2[n22] = fArray[n10];
                                fArray2[((FloatDCT_3D)FloatDCT_3D.this).rows + n22] = fArray[n10 + 1];
                            }
                            FloatDCT_3D.this.dctRows.forward(fArray2, 0, bl);
                            FloatDCT_3D.this.dctRows.forward(fArray2, FloatDCT_3D.this.rows, bl);
                            for (n22 = 0; n22 < FloatDCT_3D.this.rows; ++n22) {
                                n10 = n3 + n22 * FloatDCT_3D.this.rowStride;
                                fArray[n10] = fArray2[n22];
                                fArray[n10 + 1] = fArray2[FloatDCT_3D.this.rows + n22];
                            }
                        }
                    } else {
                        for (int i = n5; i < FloatDCT_3D.this.slices; i += n2) {
                            int n11;
                            int n6;
                            int n7 = i * FloatDCT_3D.this.sliceStride;
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                FloatDCT_3D.this.dctColumns.inverse(fArray, n7 + n6 * FloatDCT_3D.this.rowStride, bl);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (n6 = 0; n6 < FloatDCT_3D.this.columns; n6 += 4) {
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < FloatDCT_3D.this.rows; ++n9) {
                                        n11 = n7 + n9 * FloatDCT_3D.this.rowStride + n6;
                                        n8 = FloatDCT_3D.this.rows + n9;
                                        fArray2[n9] = fArray[n11];
                                        fArray2[n8] = fArray[n11 + 1];
                                        fArray2[n8 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[n11 + 2];
                                        fArray2[n8 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[n11 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.inverse(fArray2, 0, bl);
                                    FloatDCT_3D.this.dctRows.inverse(fArray2, FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.inverse(fArray2, 2 * FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.inverse(fArray2, 3 * FloatDCT_3D.this.rows, bl);
                                    for (n9 = 0; n9 < FloatDCT_3D.this.rows; ++n9) {
                                        n11 = n7 + n9 * FloatDCT_3D.this.rowStride + n6;
                                        n8 = FloatDCT_3D.this.rows + n9;
                                        fArray[n11] = fArray2[n9];
                                        fArray[n11 + 1] = fArray2[n8];
                                        fArray[n11 + 2] = fArray2[n8 + FloatDCT_3D.this.rows];
                                        fArray[n11 + 3] = fArray2[n8 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                n11 = n7 + n6 * FloatDCT_3D.this.rowStride;
                                fArray2[n6] = fArray[n11];
                                fArray2[((FloatDCT_3D)FloatDCT_3D.this).rows + n6] = fArray[n11 + 1];
                            }
                            FloatDCT_3D.this.dctRows.inverse(fArray2, 0, bl);
                            FloatDCT_3D.this.dctRows.inverse(fArray2, FloatDCT_3D.this.rows, bl);
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                n11 = n7 + n6 * FloatDCT_3D.this.rowStride;
                                fArray[n11] = fArray2[n6];
                                fArray[n11 + 1] = fArray2[FloatDCT_3D.this.rows + n6];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3da_subth(final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.slicesl ? this.slicesl : (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 4L * this.rowsl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        Future[] futureArray = new Future[n2];
        final long l2 = l;
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    FloatLargeArray floatLargeArray2 = new FloatLargeArray(l2, false);
                    if (n == -1) {
                        for (long i = l3; i < FloatDCT_3D.this.slicesl; i += (long)n2) {
                            long l;
                            long l22;
                            long l32 = i * FloatDCT_3D.this.sliceStridel;
                            for (l22 = 0L; l22 < FloatDCT_3D.this.rowsl; ++l22) {
                                FloatDCT_3D.this.dctColumns.forward(floatLargeArray, l32 + l22 * FloatDCT_3D.this.rowStridel, bl);
                            }
                            if (FloatDCT_3D.this.columnsl > 2L) {
                                for (l22 = 0L; l22 < FloatDCT_3D.this.columnsl; l22 += 4L) {
                                    long l4;
                                    long l5;
                                    for (l5 = 0L; l5 < FloatDCT_3D.this.rowsl; ++l5) {
                                        l = l32 + l5 * FloatDCT_3D.this.rowStridel + l22;
                                        l4 = FloatDCT_3D.this.rowsl + l5;
                                        floatLargeArray2.setFloat(l5, floatLargeArray.getFloat(l));
                                        floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l + 1L));
                                        floatLargeArray2.setFloat(l4 + FloatDCT_3D.this.rowsl, floatLargeArray.getFloat(l + 2L));
                                        floatLargeArray2.setFloat(l4 + 2L * FloatDCT_3D.this.rowsl, floatLargeArray.getFloat(l + 3L));
                                    }
                                    FloatDCT_3D.this.dctRows.forward(floatLargeArray2, 0L, bl);
                                    FloatDCT_3D.this.dctRows.forward(floatLargeArray2, FloatDCT_3D.this.rowsl, bl);
                                    FloatDCT_3D.this.dctRows.forward(floatLargeArray2, 2L * FloatDCT_3D.this.rowsl, bl);
                                    FloatDCT_3D.this.dctRows.forward(floatLargeArray2, 3L * FloatDCT_3D.this.rowsl, bl);
                                    for (l5 = 0L; l5 < FloatDCT_3D.this.rowsl; ++l5) {
                                        l = l32 + l5 * FloatDCT_3D.this.rowStridel + l22;
                                        l4 = FloatDCT_3D.this.rowsl + l5;
                                        floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l5));
                                        floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(l4));
                                        floatLargeArray.setFloat(l + 2L, floatLargeArray2.getFloat(l4 + FloatDCT_3D.this.rowsl));
                                        floatLargeArray.setFloat(l + 3L, floatLargeArray2.getFloat(l4 + 2L * FloatDCT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columnsl != 2L) continue;
                            for (l22 = 0L; l22 < FloatDCT_3D.this.rowsl; ++l22) {
                                l = l32 + l22 * FloatDCT_3D.this.rowStridel;
                                floatLargeArray2.setFloat(l22, floatLargeArray.getFloat(l));
                                floatLargeArray2.setFloat(FloatDCT_3D.this.rowsl + l22, floatLargeArray.getFloat(l + 1L));
                            }
                            FloatDCT_3D.this.dctRows.forward(floatLargeArray2, 0L, bl);
                            FloatDCT_3D.this.dctRows.forward(floatLargeArray2, FloatDCT_3D.this.rowsl, bl);
                            for (l22 = 0L; l22 < FloatDCT_3D.this.rowsl; ++l22) {
                                l = l32 + l22 * FloatDCT_3D.this.rowStridel;
                                floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l22));
                                floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(FloatDCT_3D.this.rowsl + l22));
                            }
                        }
                    } else {
                        for (long i = l3; i < FloatDCT_3D.this.slicesl; i += (long)n2) {
                            long l;
                            long l6;
                            long l7 = i * FloatDCT_3D.this.sliceStridel;
                            for (l6 = 0L; l6 < FloatDCT_3D.this.rowsl; ++l6) {
                                FloatDCT_3D.this.dctColumns.inverse(floatLargeArray, l7 + l6 * FloatDCT_3D.this.rowStridel, bl);
                            }
                            if (FloatDCT_3D.this.columnsl > 2L) {
                                for (l6 = 0L; l6 < FloatDCT_3D.this.columnsl; l6 += 4L) {
                                    long l8;
                                    long l9;
                                    for (l9 = 0L; l9 < FloatDCT_3D.this.rowsl; ++l9) {
                                        l = l7 + l9 * FloatDCT_3D.this.rowStridel + l6;
                                        l8 = FloatDCT_3D.this.rowsl + l9;
                                        floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l));
                                        floatLargeArray2.setFloat(l8, floatLargeArray.getFloat(l + 1L));
                                        floatLargeArray2.setFloat(l8 + FloatDCT_3D.this.rowsl, floatLargeArray.getFloat(l + 2L));
                                        floatLargeArray2.setFloat(l8 + 2L * FloatDCT_3D.this.rowsl, floatLargeArray.getFloat(l + 3L));
                                    }
                                    FloatDCT_3D.this.dctRows.inverse(floatLargeArray2, 0L, bl);
                                    FloatDCT_3D.this.dctRows.inverse(floatLargeArray2, FloatDCT_3D.this.rowsl, bl);
                                    FloatDCT_3D.this.dctRows.inverse(floatLargeArray2, 2L * FloatDCT_3D.this.rowsl, bl);
                                    FloatDCT_3D.this.dctRows.inverse(floatLargeArray2, 3L * FloatDCT_3D.this.rowsl, bl);
                                    for (l9 = 0L; l9 < FloatDCT_3D.this.rowsl; ++l9) {
                                        l = l7 + l9 * FloatDCT_3D.this.rowStridel + l6;
                                        l8 = FloatDCT_3D.this.rowsl + l9;
                                        floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l9));
                                        floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(l8));
                                        floatLargeArray.setFloat(l + 2L, floatLargeArray2.getFloat(l8 + FloatDCT_3D.this.rowsl));
                                        floatLargeArray.setFloat(l + 3L, floatLargeArray2.getFloat(l8 + 2L * FloatDCT_3D.this.rowsl));
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columnsl != 2L) continue;
                            for (l6 = 0L; l6 < FloatDCT_3D.this.rowsl; ++l6) {
                                l = l7 + l6 * FloatDCT_3D.this.rowStridel;
                                floatLargeArray2.setFloat(l6, floatLargeArray.getFloat(l));
                                floatLargeArray2.setFloat(FloatDCT_3D.this.rowsl + l6, floatLargeArray.getFloat(l + 1L));
                            }
                            FloatDCT_3D.this.dctRows.inverse(floatLargeArray2, 0L, bl);
                            FloatDCT_3D.this.dctRows.inverse(floatLargeArray2, FloatDCT_3D.this.rowsl, bl);
                            for (l6 = 0L; l6 < FloatDCT_3D.this.rowsl; ++l6) {
                                l = l7 + l6 * FloatDCT_3D.this.rowStridel;
                                floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l6));
                                floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(FloatDCT_3D.this.rowsl + l6));
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3da_subth(final int n, final float[][][] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.rows;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    float[] fArray2 = new float[n4];
                    if (n == -1) {
                        for (int i = n5; i < FloatDCT_3D.this.slices; i += n2) {
                            int n6;
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                FloatDCT_3D.this.dctColumns.forward(fArray[i][n6], bl);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (n6 = 0; n6 < FloatDCT_3D.this.columns; n6 += 4) {
                                    int n22;
                                    int n3;
                                    for (n3 = 0; n3 < FloatDCT_3D.this.rows; ++n3) {
                                        n22 = FloatDCT_3D.this.rows + n3;
                                        fArray2[n3] = fArray[i][n3][n6];
                                        fArray2[n22] = fArray[i][n3][n6 + 1];
                                        fArray2[n22 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[i][n3][n6 + 2];
                                        fArray2[n22 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[i][n3][n6 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.forward(fArray2, 0, bl);
                                    FloatDCT_3D.this.dctRows.forward(fArray2, FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.forward(fArray2, 2 * FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.forward(fArray2, 3 * FloatDCT_3D.this.rows, bl);
                                    for (n3 = 0; n3 < FloatDCT_3D.this.rows; ++n3) {
                                        n22 = FloatDCT_3D.this.rows + n3;
                                        fArray[i][n3][n6] = fArray2[n3];
                                        fArray[i][n3][n6 + 1] = fArray2[n22];
                                        fArray[i][n3][n6 + 2] = fArray2[n22 + FloatDCT_3D.this.rows];
                                        fArray[i][n3][n6 + 3] = fArray2[n22 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                fArray2[n6] = fArray[i][n6][0];
                                fArray2[((FloatDCT_3D)FloatDCT_3D.this).rows + n6] = fArray[i][n6][1];
                            }
                            FloatDCT_3D.this.dctRows.forward(fArray2, 0, bl);
                            FloatDCT_3D.this.dctRows.forward(fArray2, FloatDCT_3D.this.rows, bl);
                            for (n6 = 0; n6 < FloatDCT_3D.this.rows; ++n6) {
                                fArray[i][n6][0] = fArray2[n6];
                                fArray[i][n6][1] = fArray2[FloatDCT_3D.this.rows + n6];
                            }
                        }
                    } else {
                        for (int i = n5; i < FloatDCT_3D.this.slices; i += n2) {
                            int n7;
                            for (n7 = 0; n7 < FloatDCT_3D.this.rows; ++n7) {
                                FloatDCT_3D.this.dctColumns.inverse(fArray[i][n7], bl);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (n7 = 0; n7 < FloatDCT_3D.this.columns; n7 += 4) {
                                    int n42;
                                    int n52;
                                    for (n52 = 0; n52 < FloatDCT_3D.this.rows; ++n52) {
                                        n42 = FloatDCT_3D.this.rows + n52;
                                        fArray2[n52] = fArray[i][n52][n7];
                                        fArray2[n42] = fArray[i][n52][n7 + 1];
                                        fArray2[n42 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[i][n52][n7 + 2];
                                        fArray2[n42 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = fArray[i][n52][n7 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.inverse(fArray2, 0, bl);
                                    FloatDCT_3D.this.dctRows.inverse(fArray2, FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.inverse(fArray2, 2 * FloatDCT_3D.this.rows, bl);
                                    FloatDCT_3D.this.dctRows.inverse(fArray2, 3 * FloatDCT_3D.this.rows, bl);
                                    for (n52 = 0; n52 < FloatDCT_3D.this.rows; ++n52) {
                                        n42 = FloatDCT_3D.this.rows + n52;
                                        fArray[i][n52][n7] = fArray2[n52];
                                        fArray[i][n52][n7 + 1] = fArray2[n42];
                                        fArray[i][n52][n7 + 2] = fArray2[n42 + FloatDCT_3D.this.rows];
                                        fArray[i][n52][n7 + 3] = fArray2[n42 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (n7 = 0; n7 < FloatDCT_3D.this.rows; ++n7) {
                                fArray2[n7] = fArray[i][n7][0];
                                fArray2[((FloatDCT_3D)FloatDCT_3D.this).rows + n7] = fArray[i][n7][1];
                            }
                            FloatDCT_3D.this.dctRows.inverse(fArray2, 0, bl);
                            FloatDCT_3D.this.dctRows.inverse(fArray2, FloatDCT_3D.this.rows, bl);
                            for (n7 = 0; n7 < FloatDCT_3D.this.rows; ++n7) {
                                fArray[i][n7][0] = fArray2[n7];
                                fArray[i][n7][1] = fArray2[FloatDCT_3D.this.rows + n7];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final float[] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.slices;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        float[] fArray2;
                        block17: {
                            block18: {
                                fArray2 = new float[n4];
                                if (n != -1) break block17;
                                if (FloatDCT_3D.this.columns <= 2) break block18;
                                for (int i = n5; i < FloatDCT_3D.this.rows; i += n2) {
                                    int n12 = i * FloatDCT_3D.this.rowStride;
                                    for (int j = 0; j < FloatDCT_3D.this.columns; j += 4) {
                                        int n22;
                                        int n3;
                                        int n42;
                                        for (n42 = 0; n42 < FloatDCT_3D.this.slices; ++n42) {
                                            n3 = n42 * FloatDCT_3D.this.sliceStride + n12 + j;
                                            n22 = FloatDCT_3D.this.slices + n42;
                                            fArray2[n42] = fArray[n3];
                                            fArray2[n22] = fArray[n3 + 1];
                                            fArray2[n22 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n3 + 2];
                                            fArray2[n22 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n3 + 3];
                                        }
                                        FloatDCT_3D.this.dctSlices.forward(fArray2, 0, bl);
                                        FloatDCT_3D.this.dctSlices.forward(fArray2, FloatDCT_3D.this.slices, bl);
                                        FloatDCT_3D.this.dctSlices.forward(fArray2, 2 * FloatDCT_3D.this.slices, bl);
                                        FloatDCT_3D.this.dctSlices.forward(fArray2, 3 * FloatDCT_3D.this.slices, bl);
                                        for (n42 = 0; n42 < FloatDCT_3D.this.slices; ++n42) {
                                            n3 = n42 * FloatDCT_3D.this.sliceStride + n12 + j;
                                            n22 = FloatDCT_3D.this.slices + n42;
                                            fArray[n3] = fArray2[n42];
                                            fArray[n3 + 1] = fArray2[n22];
                                            fArray[n3 + 2] = fArray2[n22 + FloatDCT_3D.this.slices];
                                            fArray[n3 + 3] = fArray2[n22 + 2 * FloatDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDCT_3D.this.columns != 2) break block19;
                            for (int i = n5; i < FloatDCT_3D.this.rows; i += n2) {
                                int n13;
                                int n52;
                                int n6 = i * FloatDCT_3D.this.rowStride;
                                for (n52 = 0; n52 < FloatDCT_3D.this.slices; ++n52) {
                                    n13 = n52 * FloatDCT_3D.this.sliceStride + n6;
                                    fArray2[n52] = fArray[n13];
                                    fArray2[((FloatDCT_3D)FloatDCT_3D.this).slices + n52] = fArray[n13 + 1];
                                }
                                FloatDCT_3D.this.dctSlices.forward(fArray2, 0, bl);
                                FloatDCT_3D.this.dctSlices.forward(fArray2, FloatDCT_3D.this.slices, bl);
                                for (n52 = 0; n52 < FloatDCT_3D.this.slices; ++n52) {
                                    n13 = n52 * FloatDCT_3D.this.sliceStride + n6;
                                    fArray[n13] = fArray2[n52];
                                    fArray[n13 + 1] = fArray2[FloatDCT_3D.this.slices + n52];
                                }
                            }
                            break block19;
                        }
                        if (FloatDCT_3D.this.columns > 2) {
                            for (int i = n5; i < FloatDCT_3D.this.rows; i += n2) {
                                int n14 = i * FloatDCT_3D.this.rowStride;
                                for (int j = 0; j < FloatDCT_3D.this.columns; j += 4) {
                                    int n7;
                                    int n8;
                                    int n9;
                                    for (n9 = 0; n9 < FloatDCT_3D.this.slices; ++n9) {
                                        n8 = n9 * FloatDCT_3D.this.sliceStride + n14 + j;
                                        n7 = FloatDCT_3D.this.slices + n9;
                                        fArray2[n9] = fArray[n8];
                                        fArray2[n7] = fArray[n8 + 1];
                                        fArray2[n7 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n8 + 2];
                                        fArray2[n7 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n8 + 3];
                                    }
                                    FloatDCT_3D.this.dctSlices.inverse(fArray2, 0, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(fArray2, FloatDCT_3D.this.slices, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(fArray2, 2 * FloatDCT_3D.this.slices, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(fArray2, 3 * FloatDCT_3D.this.slices, bl);
                                    for (n9 = 0; n9 < FloatDCT_3D.this.slices; ++n9) {
                                        n8 = n9 * FloatDCT_3D.this.sliceStride + n14 + j;
                                        n7 = FloatDCT_3D.this.slices + n9;
                                        fArray[n8] = fArray2[n9];
                                        fArray[n8 + 1] = fArray2[n7];
                                        fArray[n8 + 2] = fArray2[n7 + FloatDCT_3D.this.slices];
                                        fArray[n8 + 3] = fArray2[n7 + 2 * FloatDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (FloatDCT_3D.this.columns == 2) {
                            for (int i = n5; i < FloatDCT_3D.this.rows; i += n2) {
                                int n15;
                                int n10;
                                int n11 = i * FloatDCT_3D.this.rowStride;
                                for (n10 = 0; n10 < FloatDCT_3D.this.slices; ++n10) {
                                    n15 = n10 * FloatDCT_3D.this.sliceStride + n11;
                                    fArray2[n10] = fArray[n15];
                                    fArray2[((FloatDCT_3D)FloatDCT_3D.this).slices + n10] = fArray[n15 + 1];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(fArray2, 0, bl);
                                FloatDCT_3D.this.dctSlices.inverse(fArray2, FloatDCT_3D.this.slices, bl);
                                for (n10 = 0; n10 < FloatDCT_3D.this.slices; ++n10) {
                                    n15 = n10 * FloatDCT_3D.this.sliceStride + n11;
                                    fArray[n15] = fArray2[n10];
                                    fArray[n15 + 1] = fArray2[FloatDCT_3D.this.slices + n10];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final FloatLargeArray floatLargeArray, final boolean bl) {
        final int n2 = (int)((long)ConcurrencyUtils.getNumberOfThreads() > this.rowsl ? this.rowsl : (long)ConcurrencyUtils.getNumberOfThreads());
        long l = 4L * this.slicesl;
        if (this.columnsl == 2L) {
            l >>= 1;
        }
        final long l2 = l;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final long l3 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        FloatLargeArray floatLargeArray2;
                        block17: {
                            block18: {
                                floatLargeArray2 = new FloatLargeArray(l2, false);
                                if (n != -1) break block17;
                                if (FloatDCT_3D.this.columnsl <= 2L) break block18;
                                for (long i = l3; i < FloatDCT_3D.this.rowsl; i += (long)n2) {
                                    long l = i * FloatDCT_3D.this.rowStridel;
                                    for (long j = 0L; j < FloatDCT_3D.this.columnsl; j += 4L) {
                                        long l22;
                                        long l32;
                                        long l4;
                                        for (l4 = 0L; l4 < FloatDCT_3D.this.slicesl; ++l4) {
                                            l32 = l4 * FloatDCT_3D.this.sliceStridel + l + j;
                                            l22 = FloatDCT_3D.this.slicesl + l4;
                                            floatLargeArray2.setFloat(l4, floatLargeArray.getFloat(l32));
                                            floatLargeArray2.setFloat(l22, floatLargeArray.getFloat(l32 + 1L));
                                            floatLargeArray2.setFloat(l22 + FloatDCT_3D.this.slicesl, floatLargeArray.getFloat(l32 + 2L));
                                            floatLargeArray2.setFloat(l22 + 2L * FloatDCT_3D.this.slicesl, floatLargeArray.getFloat(l32 + 3L));
                                        }
                                        FloatDCT_3D.this.dctSlices.forward(floatLargeArray2, 0L, bl);
                                        FloatDCT_3D.this.dctSlices.forward(floatLargeArray2, FloatDCT_3D.this.slicesl, bl);
                                        FloatDCT_3D.this.dctSlices.forward(floatLargeArray2, 2L * FloatDCT_3D.this.slicesl, bl);
                                        FloatDCT_3D.this.dctSlices.forward(floatLargeArray2, 3L * FloatDCT_3D.this.slicesl, bl);
                                        for (l4 = 0L; l4 < FloatDCT_3D.this.slicesl; ++l4) {
                                            l32 = l4 * FloatDCT_3D.this.sliceStridel + l + j;
                                            l22 = FloatDCT_3D.this.slicesl + l4;
                                            floatLargeArray.setFloat(l32, floatLargeArray2.getFloat(l4));
                                            floatLargeArray.setFloat(l32 + 1L, floatLargeArray2.getFloat(l22));
                                            floatLargeArray.setFloat(l32 + 2L, floatLargeArray2.getFloat(l22 + FloatDCT_3D.this.slicesl));
                                            floatLargeArray.setFloat(l32 + 3L, floatLargeArray2.getFloat(l22 + 2L * FloatDCT_3D.this.slicesl));
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDCT_3D.this.columnsl != 2L) break block19;
                            for (long i = l3; i < FloatDCT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l5;
                                long l6 = i * FloatDCT_3D.this.rowStridel;
                                for (l5 = 0L; l5 < FloatDCT_3D.this.slicesl; ++l5) {
                                    l = l5 * FloatDCT_3D.this.sliceStridel + l6;
                                    floatLargeArray2.setFloat(l5, floatLargeArray.getFloat(l));
                                    floatLargeArray2.setFloat(FloatDCT_3D.this.slicesl + l5, floatLargeArray.getFloat(l + 1L));
                                }
                                FloatDCT_3D.this.dctSlices.forward(floatLargeArray2, 0L, bl);
                                FloatDCT_3D.this.dctSlices.forward(floatLargeArray2, FloatDCT_3D.this.slicesl, bl);
                                for (l5 = 0L; l5 < FloatDCT_3D.this.slicesl; ++l5) {
                                    l = l5 * FloatDCT_3D.this.sliceStridel + l6;
                                    floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l5));
                                    floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(FloatDCT_3D.this.slicesl + l5));
                                }
                            }
                            break block19;
                        }
                        if (FloatDCT_3D.this.columnsl > 2L) {
                            for (long i = l3; i < FloatDCT_3D.this.rowsl; i += (long)n2) {
                                long l = i * FloatDCT_3D.this.rowStridel;
                                for (long j = 0L; j < FloatDCT_3D.this.columnsl; j += 4L) {
                                    long l7;
                                    long l8;
                                    long l9;
                                    for (l9 = 0L; l9 < FloatDCT_3D.this.slicesl; ++l9) {
                                        l8 = l9 * FloatDCT_3D.this.sliceStridel + l + j;
                                        l7 = FloatDCT_3D.this.slicesl + l9;
                                        floatLargeArray2.setFloat(l9, floatLargeArray.getFloat(l8));
                                        floatLargeArray2.setFloat(l7, floatLargeArray.getFloat(l8 + 1L));
                                        floatLargeArray2.setFloat(l7 + FloatDCT_3D.this.slicesl, floatLargeArray.getFloat(l8 + 2L));
                                        floatLargeArray2.setFloat(l7 + 2L * FloatDCT_3D.this.slicesl, floatLargeArray.getFloat(l8 + 3L));
                                    }
                                    FloatDCT_3D.this.dctSlices.inverse(floatLargeArray2, 0L, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(floatLargeArray2, FloatDCT_3D.this.slicesl, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(floatLargeArray2, 2L * FloatDCT_3D.this.slicesl, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(floatLargeArray2, 3L * FloatDCT_3D.this.slicesl, bl);
                                    for (l9 = 0L; l9 < FloatDCT_3D.this.slicesl; ++l9) {
                                        l8 = l9 * FloatDCT_3D.this.sliceStridel + l + j;
                                        l7 = FloatDCT_3D.this.slicesl + l9;
                                        floatLargeArray.setFloat(l8, floatLargeArray2.getFloat(l9));
                                        floatLargeArray.setFloat(l8 + 1L, floatLargeArray2.getFloat(l7));
                                        floatLargeArray.setFloat(l8 + 2L, floatLargeArray2.getFloat(l7 + FloatDCT_3D.this.slicesl));
                                        floatLargeArray.setFloat(l8 + 3L, floatLargeArray2.getFloat(l7 + 2L * FloatDCT_3D.this.slicesl));
                                    }
                                }
                            }
                        } else if (FloatDCT_3D.this.columnsl == 2L) {
                            for (long i = l3; i < FloatDCT_3D.this.rowsl; i += (long)n2) {
                                long l;
                                long l10;
                                long l11 = i * FloatDCT_3D.this.rowStridel;
                                for (l10 = 0L; l10 < FloatDCT_3D.this.slicesl; ++l10) {
                                    l = l10 * FloatDCT_3D.this.sliceStridel + l11;
                                    floatLargeArray2.setFloat(l10, floatLargeArray.getFloat(l));
                                    floatLargeArray2.setFloat(FloatDCT_3D.this.slicesl + l10, floatLargeArray.getFloat(l + 1L));
                                }
                                FloatDCT_3D.this.dctSlices.inverse(floatLargeArray2, 0L, bl);
                                FloatDCT_3D.this.dctSlices.inverse(floatLargeArray2, FloatDCT_3D.this.slicesl, bl);
                                for (l10 = 0L; l10 < FloatDCT_3D.this.slicesl; ++l10) {
                                    l = l10 * FloatDCT_3D.this.sliceStridel + l11;
                                    floatLargeArray.setFloat(l, floatLargeArray2.getFloat(l10));
                                    floatLargeArray.setFloat(l + 1L, floatLargeArray2.getFloat(FloatDCT_3D.this.slicesl + l10));
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }

    private void ddxt3db_subth(final int n, final float[][][] fArray, final boolean bl) {
        final int n2 = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int n3 = 4 * this.slices;
        if (this.columns == 2) {
            n3 >>= 1;
        }
        final int n4 = n3;
        Future[] futureArray = new Future[n2];
        for (int i = 0; i < n2; ++i) {
            final int n5 = i;
            futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        float[] fArray2;
                        block17: {
                            block18: {
                                fArray2 = new float[n4];
                                if (n != -1) break block17;
                                if (FloatDCT_3D.this.columns <= 2) break block18;
                                for (int i = n5; i < FloatDCT_3D.this.rows; i += n2) {
                                    for (int j = 0; j < FloatDCT_3D.this.columns; j += 4) {
                                        int n6;
                                        int n22;
                                        for (n22 = 0; n22 < FloatDCT_3D.this.slices; ++n22) {
                                            n6 = FloatDCT_3D.this.slices + n22;
                                            fArray2[n22] = fArray[n22][i][j];
                                            fArray2[n6] = fArray[n22][i][j + 1];
                                            fArray2[n6 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n22][i][j + 2];
                                            fArray2[n6 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n22][i][j + 3];
                                        }
                                        FloatDCT_3D.this.dctSlices.forward(fArray2, 0, bl);
                                        FloatDCT_3D.this.dctSlices.forward(fArray2, FloatDCT_3D.this.slices, bl);
                                        FloatDCT_3D.this.dctSlices.forward(fArray2, 2 * FloatDCT_3D.this.slices, bl);
                                        FloatDCT_3D.this.dctSlices.forward(fArray2, 3 * FloatDCT_3D.this.slices, bl);
                                        for (n22 = 0; n22 < FloatDCT_3D.this.slices; ++n22) {
                                            n6 = FloatDCT_3D.this.slices + n22;
                                            fArray[n22][i][j] = fArray2[n22];
                                            fArray[n22][i][j + 1] = fArray2[n6];
                                            fArray[n22][i][j + 2] = fArray2[n6 + FloatDCT_3D.this.slices];
                                            fArray[n22][i][j + 3] = fArray2[n6 + 2 * FloatDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDCT_3D.this.columns != 2) break block19;
                            for (int i = n5; i < FloatDCT_3D.this.rows; i += n2) {
                                int n7;
                                for (n7 = 0; n7 < FloatDCT_3D.this.slices; ++n7) {
                                    fArray2[n7] = fArray[n7][i][0];
                                    fArray2[((FloatDCT_3D)FloatDCT_3D.this).slices + n7] = fArray[n7][i][1];
                                }
                                FloatDCT_3D.this.dctSlices.forward(fArray2, 0, bl);
                                FloatDCT_3D.this.dctSlices.forward(fArray2, FloatDCT_3D.this.slices, bl);
                                for (n7 = 0; n7 < FloatDCT_3D.this.slices; ++n7) {
                                    fArray[n7][i][0] = fArray2[n7];
                                    fArray[n7][i][1] = fArray2[FloatDCT_3D.this.slices + n7];
                                }
                            }
                            break block19;
                        }
                        if (FloatDCT_3D.this.columns > 2) {
                            for (int i = n5; i < FloatDCT_3D.this.rows; i += n2) {
                                for (int j = 0; j < FloatDCT_3D.this.columns; j += 4) {
                                    int n8;
                                    int n3;
                                    for (n3 = 0; n3 < FloatDCT_3D.this.slices; ++n3) {
                                        n8 = FloatDCT_3D.this.slices + n3;
                                        fArray2[n3] = fArray[n3][i][j];
                                        fArray2[n8] = fArray[n3][i][j + 1];
                                        fArray2[n8 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n3][i][j + 2];
                                        fArray2[n8 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = fArray[n3][i][j + 3];
                                    }
                                    FloatDCT_3D.this.dctSlices.inverse(fArray2, 0, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(fArray2, FloatDCT_3D.this.slices, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(fArray2, 2 * FloatDCT_3D.this.slices, bl);
                                    FloatDCT_3D.this.dctSlices.inverse(fArray2, 3 * FloatDCT_3D.this.slices, bl);
                                    for (n3 = 0; n3 < FloatDCT_3D.this.slices; ++n3) {
                                        n8 = FloatDCT_3D.this.slices + n3;
                                        fArray[n3][i][j] = fArray2[n3];
                                        fArray[n3][i][j + 1] = fArray2[n8];
                                        fArray[n3][i][j + 2] = fArray2[n8 + FloatDCT_3D.this.slices];
                                        fArray[n3][i][j + 3] = fArray2[n8 + 2 * FloatDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (FloatDCT_3D.this.columns == 2) {
                            for (int i = n5; i < FloatDCT_3D.this.rows; i += n2) {
                                int n9;
                                for (n9 = 0; n9 < FloatDCT_3D.this.slices; ++n9) {
                                    fArray2[n9] = fArray[n9][i][0];
                                    fArray2[((FloatDCT_3D)FloatDCT_3D.this).slices + n9] = fArray[n9][i][1];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(fArray2, 0, bl);
                                FloatDCT_3D.this.dctSlices.inverse(fArray2, FloatDCT_3D.this.slices, bl);
                                for (n9 = 0; n9 < FloatDCT_3D.this.slices; ++n9) {
                                    fArray[n9][i][0] = fArray2[n9];
                                    fArray[n9][i][1] = fArray2[FloatDCT_3D.this.slices + n9];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futureArray);
    }
}

