/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dst;

import java.util.concurrent.Future;
import org.jtransforms.dct.DoubleDCT_1D;
import org.jtransforms.utils.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.DoubleLargeArray;

public class DoubleDST_1D {
    private final int n;
    private final long nl;
    private final DoubleDCT_1D dct;
    private final boolean useLargeArrays;

    public DoubleDST_1D(long l) {
        this.n = (int)l;
        this.nl = l;
        this.useLargeArrays = l >= ConcurrencyUtils.getLargeArraysBeginN();
        this.dct = new DoubleDCT_1D(l);
    }

    public void forward(double[] dArray, boolean bl) {
        this.forward(dArray, 0, bl);
    }

    public void forward(DoubleLargeArray doubleLargeArray, boolean bl) {
        this.forward(doubleLargeArray, 0L, bl);
    }

    public void forward(final double[] dArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new DoubleLargeArray(dArray), (long)n, bl);
        } else {
            int n2;
            int n3 = this.n / 2;
            int n4 = 1 + n;
            int n5 = n + this.n;
            for (n2 = n4; n2 < n5; n2 += 2) {
                dArray[n2] = -dArray[n2];
            }
            this.dct.forward(dArray, n, bl);
            n2 = ConcurrencyUtils.getNumberOfThreads();
            if (n2 > 1 && (long)n3 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n2 = 2;
                int n6 = n3 / n2;
                Future[] futureArray = new Future[n2];
                for (int i = 0; i < n2; ++i) {
                    final int n7 = i * n6;
                    final int n8 = i == n2 - 1 ? n3 : n7 + n6;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int n4 = n + DoubleDST_1D.this.n - 1;
                            for (int i = n7; i < n8; ++i) {
                                int n2 = n + i;
                                double d = dArray[n2];
                                int n3 = n4 - i;
                                dArray[n2] = dArray[n3];
                                dArray[n3] = d;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n9 = n + this.n - 1;
                for (int i = 0; i < n3; ++i) {
                    int n10 = n + i;
                    double d = dArray[n10];
                    int n11 = n9 - i;
                    dArray[n10] = dArray[n11];
                    dArray[n11] = d;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final DoubleLargeArray doubleLargeArray, final long l, boolean bl) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(doubleLargeArray.getData(), (int)l, bl);
            return;
        } else {
            long l2 = this.nl / 2L;
            long l3 = 1L + l;
            long l4 = l + this.nl;
            for (long i = l3; i < l4; i += 2L) {
                doubleLargeArray.setDouble(i, -doubleLargeArray.getDouble(i));
            }
            this.dct.forward(doubleLargeArray, l, bl);
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && l2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                long l5 = l2 / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    final long l6 = (long)i * l5;
                    final long l7 = i == n - 1 ? l2 : l6 + l5;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            long l4 = l + DoubleDST_1D.this.nl - 1L;
                            for (long i = l6; i < l7; ++i) {
                                long l2 = l + i;
                                double d = doubleLargeArray.getDouble(l2);
                                long l3 = l4 - i;
                                doubleLargeArray.setDouble(l2, doubleLargeArray.getDouble(l3));
                                doubleLargeArray.setDouble(l3, d);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
                return;
            } else {
                long l8 = l + this.nl - 1L;
                for (long i = 0L; i < l2; ++i) {
                    long l9 = l + i;
                    double d = doubleLargeArray.getDouble(l9);
                    long l10 = l8 - i;
                    doubleLargeArray.setDouble(l9, doubleLargeArray.getDouble(l10));
                    doubleLargeArray.setDouble(l10, d);
                }
            }
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        this.inverse(dArray, 0, bl);
    }

    public void inverse(DoubleLargeArray doubleLargeArray, boolean bl) {
        this.inverse(doubleLargeArray, 0L, bl);
    }

    public void inverse(final double[] dArray, final int n, boolean bl) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new DoubleLargeArray(dArray), (long)n, bl);
        } else {
            int n2;
            int n3;
            int n4 = this.n / 2;
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && (long)n4 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n5 = 2;
                n3 = n4 / n5;
                Future[] futureArray = new Future[n5];
                for (n2 = 0; n2 < n5; ++n2) {
                    final int n6 = n2 * n3;
                    final int n7 = n2 == n5 - 1 ? n4 : n6 + n3;
                    futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            int n4 = n + DoubleDST_1D.this.n - 1;
                            for (int i = n6; i < n7; ++i) {
                                int n2 = n + i;
                                double d = dArray[n2];
                                int n3 = n4 - i;
                                dArray[n2] = dArray[n3];
                                dArray[n3] = d;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                n3 = n + this.n - 1;
                for (int i = 0; i < n4; ++i) {
                    double d = dArray[n + i];
                    dArray[n + i] = dArray[n3 - i];
                    dArray[n3 - i] = d;
                }
            }
            this.dct.inverse(dArray, n, bl);
            n3 = 1 + n;
            int n8 = n + this.n;
            for (n2 = n3; n2 < n8; n2 += 2) {
                dArray[n2] = -dArray[n2];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(final DoubleLargeArray doubleLargeArray, final long l, boolean bl) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (doubleLargeArray.getData() == null || l >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(doubleLargeArray.getData(), (int)l, bl);
            return;
        } else {
            long l2;
            long l3;
            long l4 = this.nl / 2L;
            int n = ConcurrencyUtils.getNumberOfThreads();
            if (n > 1 && l4 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                n = 2;
                l3 = l4 / (long)n;
                Future[] futureArray = new Future[n];
                for (int i = 0; i < n; ++i) {
                    l2 = (long)i * l3;
                    final long l5 = i == n - 1 ? l4 : l2 + l3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            long l4 = l + DoubleDST_1D.this.nl - 1L;
                            for (long i = l2; i < l5; ++i) {
                                long l22 = l + i;
                                double d = doubleLargeArray.getDouble(l22);
                                long l3 = l4 - i;
                                doubleLargeArray.setDouble(l22, doubleLargeArray.getDouble(l3));
                                doubleLargeArray.setDouble(l3, d);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                l3 = l + this.nl - 1L;
                for (long i = 0L; i < l4; ++i) {
                    double d = doubleLargeArray.getDouble(l + i);
                    doubleLargeArray.setDouble(l + i, doubleLargeArray.getDouble(l3 - i));
                    doubleLargeArray.setDouble(l3 - i, d);
                }
            }
            this.dct.inverse(doubleLargeArray, l, bl);
            l3 = 1L + l;
            long l6 = l + this.nl;
            for (l2 = l3; l2 < l6; l2 += 2L) {
                doubleLargeArray.setDouble(l2, -doubleLargeArray.getDouble(l2));
            }
        }
    }
}

