/*
 * Decompiled with CFR 0.152.
 */
package adams.data.boofcv.transformer;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.boofcv.BoofCVHelper;
import adams.data.boofcv.BoofCVImageContainer;
import adams.data.boofcv.BoofCVImageType;
import adams.data.boofcv.transformer.AbstractBoofCVTransformer;
import boofcv.alg.enhance.EnhanceImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageUInt8;

@MixedCopyright(author="Peter Abeles", license=License.APACHE2, url="http://boofcv.org/index.php?title=Example_Image_Enhancement", note="Example code taken from this URL")
public class HistogramBasedIntensityAdjustmentGray8
extends AbstractBoofCVTransformer {
    private static final long serialVersionUID = -465068613851000709L;

    public String globalInfo() {
        return "Histogram adjustment algorithms aim to spread out pixel intensity values (of gray-scale image) uniformly across the allowed range.";
    }

    protected BoofCVImageContainer[] doTransform(BoofCVImageContainer img) {
        ImageUInt8 gray = (ImageUInt8)BoofCVHelper.toBoofCVImage((ImageBase)img.getImage(), BoofCVImageType.UNSIGNED_INT_8);
        ImageUInt8 adjusted = new ImageUInt8(gray.width, gray.height);
        int[] histogram = new int[256];
        int[] transform = new int[256];
        ImageStatistics.histogram((ImageUInt8)gray, (int[])histogram);
        EnhanceImageOps.equalize((int[])histogram, (int[])transform);
        EnhanceImageOps.applyTransform((ImageUInt8)gray, (int[])transform, (ImageUInt8)adjusted);
        BoofCVImageContainer[] result = new BoofCVImageContainer[]{(BoofCVImageContainer)img.getHeader()};
        result[0].setImage(adjusted);
        return result;
    }
}

