/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.gui.core.ColorHelper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class CountColor
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected Color m_Color;
    protected boolean m_UsePercentage;

    public String globalInfo() {
        return "Counts the occurrences of a specific color (alpha channel gets ignored).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.WHITE);
        this.m_OptionManager.add("use-percentage", "usePercentage", (Object)false);
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to count.";
    }

    public void setUsePercentage(boolean value) {
        this.m_UsePercentage = value;
        this.reset();
    }

    public boolean getUsePercentage() {
        return this.m_UsePercentage;
    }

    public String usePercentageTipText() {
        return "If enabled, a percentage is output (0-1) rather than an absolute count.";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("Count-" + ColorHelper.toHex((Color)this.m_Color), DataType.NUMERIC);
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)6);
        int count = 0;
        int color = this.m_Color.getRGB() & 0xFFFFFF;
        int[] pixels = BufferedImageHelper.getPixels((BufferedImage)image);
        for (int i = 0; i < pixels.length; ++i) {
            if ((pixels[i] & 0xFFFFFF) != color) continue;
            ++count;
        }
        List[] result = new List[]{new ArrayList()};
        if (this.m_UsePercentage) {
            result[0].add((double)count / (double)pixels.length);
        } else {
            result[0].add(count);
        }
        return result;
    }
}

