/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagefilter;

import adams.data.imagefilter.AbstractImageFilterProvider;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import javax.swing.GrayFilter;

public class GrayFilterProvider
extends AbstractImageFilterProvider {
    private static final long serialVersionUID = -370613834879391406L;
    protected boolean m_BrightenPixels;
    protected int m_GrayPercentage;

    public String globalInfo() {
        return "Generates a " + GrayFilter.class.getName() + " image filter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("brighten-pixels", "brightenPixels", (Object)false);
        this.m_OptionManager.add("gray-percentage", "grayPercentage", (Object)0, (Number)0, (Number)100);
    }

    public void setBrightenPixels(boolean value) {
        this.m_BrightenPixels = value;
        this.reset();
    }

    public boolean getBrightenPixels() {
        return this.m_BrightenPixels;
    }

    public String brightenPixelsTipText() {
        return "If enabled, the pixels get brightened.";
    }

    public void setGrayPercentage(int value) {
        if (value >= 0 && value <= 100) {
            this.m_GrayPercentage = value;
            this.reset();
        } else {
            this.getLogger().warning("Gray percentage must be 0 <= x <= 100, provided: " + value);
        }
    }

    public int getGrayPercentage() {
        return this.m_GrayPercentage;
    }

    public String grayPercentageTipText() {
        return "The gray percentage: 0 = lightest, 100 = darkest.";
    }

    @Override
    protected ImageFilter doGenerate(BufferedImage img) {
        return new GrayFilter(this.m_BrightenPixels, this.m_GrayPercentage);
    }
}

