/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingObject;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.SanselanImageReader;
import adams.data.io.output.AbstractImageWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.Sanselan;

public class SanselanImageWriter
extends AbstractImageWriter<BufferedImageContainer> {
    private static final long serialVersionUID = 6385191315392140321L;

    public String globalInfo() {
        return "Sanselan image writer for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ");
    }

    public String getFormatDescription() {
        return "Sanselan image writer";
    }

    public String[] getFormatExtensions() {
        return new String[]{"bmp", "gif", "ico", "pbm", "pgm", "png", "pnm", "ppm", "tif", "tiff"};
    }

    public AbstractImageReader getCorrespondingReader() {
        return new SanselanImageReader();
    }

    protected String doWrite(PlaceholderFile file, BufferedImageContainer cont) {
        String result = null;
        String ext = FileUtils.getExtension((File)file);
        Object format = ext.equals("bmp") ? ImageFormat.IMAGE_FORMAT_BMP : (ext.equals("gif") ? ImageFormat.IMAGE_FORMAT_GIF : (ext.equals("ico") ? ImageFormat.IMAGE_FORMAT_ICO : (ext.equals("jpg") || ext.equals("jpeg") ? ImageFormat.IMAGE_FORMAT_JPEG : (ext.equals("pbm") ? ImageFormat.IMAGE_FORMAT_PBM : (ext.equals("pgm") ? ImageFormat.IMAGE_FORMAT_PGM : (ext.equals("png") ? ImageFormat.IMAGE_FORMAT_PNG : (ext.equals("pnm") ? ImageFormat.IMAGE_FORMAT_PNM : (ext.equals("ppm") ? ImageFormat.IMAGE_FORMAT_PPM : (ext.equals("tif") || ext.equals("tiff") ? ImageFormat.IMAGE_FORMAT_TIFF : null)))))))));
        if (format == null) {
            result = "Unhandled file extension: " + ext;
        }
        if (result == null) {
            try {
                Sanselan.writeImage((BufferedImage)cont.toBufferedImage(), (File)file.getAbsoluteFile(), (ImageFormat)format, new HashMap());
            }
            catch (Exception e) {
                result = Utils.handleException((LoggingObject)this, (String)("Failed to write image to: " + file), (Throwable)e);
            }
        }
        return result;
    }
}

