/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.gui.visualization.image.AbstractImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class ObjectLocationsOverlayFromReport
extends AbstractImageOverlay {
    private static final long serialVersionUID = 6356419097401574024L;
    protected String m_Prefix;
    protected Color m_Color;
    protected List<Rectangle> m_Locations;

    public String globalInfo() {
        return "Displays the locations of objects in the image, using data from the attached report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix of fields in the report to identify as object location, eg 'Object.'.";
    }

    public void setColor(Color value) {
        this.m_Color = value;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "The color to use for the objects.";
    }

    protected synchronized void doImageChanged(ImagePanel.PaintPanel panel) {
        this.m_Locations = null;
    }

    protected void determineLocations(Report report) {
        if (this.m_Locations != null) {
            return;
        }
        List fields = report.getFields();
        this.m_Locations = new ArrayList<Rectangle>();
        for (AbstractField field : fields) {
            if (!field.getName().startsWith(this.m_Prefix)) continue;
            try {
                String current = field.getName().substring(0, field.getName().lastIndexOf(46));
                if (!report.hasValue(current + ".x") || !report.hasValue(current + ".y") || !report.hasValue(current + ".width") || !report.hasValue(current + ".height")) continue;
                int x = report.getDoubleValue(current + ".x").intValue();
                int y = report.getDoubleValue(current + ".y").intValue();
                int width = report.getDoubleValue(current + ".width").intValue();
                int height = report.getDoubleValue(current + ".height").intValue();
                Rectangle rect = new Rectangle(new Point(x, y), new Dimension(width, height));
                this.m_Locations.add(rect);
            }
            catch (Exception exception) {}
        }
    }

    protected synchronized void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        this.determineLocations(panel.getOwner().getAdditionalProperties());
        if (this.m_Locations.size() > 0) {
            for (Rectangle rect : this.m_Locations) {
                g.setColor(this.m_Color);
                g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            }
        }
    }
}

