/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetAddRowID;
import adams.data.conversion.TransposeSpreadSheet;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.ByContentType;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import adams.flow.control.Flow;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SpreadSheetColumnFilter;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.tools.spreadsheetviewer.chart.LinePlot;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesViewerPluginWithGOE;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingWorker;

public abstract class AbstractSelectedImagesFeatureGenerator
extends AbstractSelectedImagesViewerPluginWithGOE {
    private static final long serialVersionUID = -3111612432359476318L;
    protected String m_FilterError;
    protected List<Row> m_Collected;

    public boolean canExecute(ImagePanel panel) {
        return panel != null && panel.getCurrentImage() != null;
    }

    protected String getDialogTitle() {
        String result = this.getLastSetup().getClass().getSimpleName();
        if (((ImagePanel)this.m_CurrentPanel).getCurrentFile() != null) {
            result = result + " [" + ((ImagePanel)this.m_CurrentPanel).getCurrentFile().getName() + " -- " + ((ImagePanel)this.m_CurrentPanel).getCurrentFile().getParent() + "]";
        }
        return result;
    }

    protected Dimension getDialogSize() {
        return new Dimension(800, 600);
    }

    protected String processInit() {
        String result = super.processInit();
        if (result == null) {
            this.m_Collected = new ArrayList<Row>();
        }
        return result;
    }

    protected abstract Row[] generateFeatures(BufferedImage var1);

    protected String process(ImagePanel panel) {
        String result = null;
        BufferedImage input = panel.getCurrentImage();
        try {
            Row[] output = this.generateFeatures(input);
            this.m_Collected.addAll(Arrays.asList(output));
            if (this.m_CanceledByUser) {
                return result;
            }
            if (output == null) {
                result = "Failed to generate features: ";
                result = this.m_FilterError == null ? result + "unknown reason" : result + this.m_FilterError;
            }
        }
        catch (Exception e) {
            this.m_FilterError = e.toString();
            result = "Failed to generate features: ";
            this.getLogger().log(Level.SEVERE, result, e);
            result = result + this.m_FilterError;
        }
        return result;
    }

    protected SpreadSheet collate() throws Exception {
        SpreadSheet result = this.m_Collected.get(0).getOwner().getClone();
        result.clear();
        for (Row row : this.m_Collected) {
            result.addRow().assign(row);
        }
        SubProcess sub = new SubProcess();
        ByContentType finder = new ByContentType();
        finder.setContentTypes(new Cell.ContentType[]{Cell.ContentType.LONG, Cell.ContentType.DOUBLE});
        SpreadSheetColumnFilter filter = new SpreadSheetColumnFilter();
        filter.setFinder((ColumnFinder)finder);
        sub.add((AbstractActor)filter);
        TransposeSpreadSheet transpose = new TransposeSpreadSheet();
        Convert conv = new Convert();
        conv.setConversion((Conversion)transpose);
        sub.add((AbstractActor)conv);
        SpreadSheetAddRowID id = new SpreadSheetAddRowID();
        id.setHeader("features");
        conv = new Convert();
        conv.setConversion((Conversion)id);
        sub.add((AbstractActor)conv);
        List list = ActorUtils.transform((AbstractActor)sub, (Object)result);
        if (list == null || list.size() != 1) {
            throw new IllegalStateException("Failed to collate data from generated features!");
        }
        result = (SpreadSheet)list.get(0);
        return result;
    }

    protected String processFinish() {
        String result = super.processFinish();
        SpreadSheet sheet = null;
        if (this.m_Collected.size() == 0) {
            return result;
        }
        if (result == null) {
            try {
                sheet = this.collate();
                LinePlot plot = new LinePlot();
                plot.setXColumn("1");
                plot.setYColumns("2-last");
                final Flow flow = plot.generate(this.getCaption(), sheet);
                flow.setParentComponent((Component)this.m_CurrentPanel);
                SwingWorker worker = new SwingWorker(){
                    String msg = null;

                    protected Object doInBackground() throws Exception {
                        this.msg = flow.setUp();
                        if (this.msg != null) {
                            this.msg = "Failed to setup flow for displaying generated features:\n" + this.msg;
                        }
                        if (this.msg == null) {
                            this.msg = flow.execute();
                            if (this.msg != null) {
                                this.msg = "Failed to execute flow for displaying generated features:\n" + this.msg;
                            }
                        }
                        if (this.msg == null) {
                            flow.wrapUp();
                            if (flow.hasStopMessage()) {
                                this.msg = "Flow execution for displaying generated features was stopped:\n" + flow.getStopMessage();
                            }
                        }
                        return this.msg;
                    }

                    @Override
                    protected void done() {
                        super.done();
                        if (this.msg != null) {
                            GUIHelper.showErrorMessage((Component)AbstractSelectedImagesFeatureGenerator.this.m_CurrentPanel, (String)this.msg);
                            ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, this.msg + "\n");
                            ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, flow.toCommandLine() + "\n");
                            flow.destroy();
                        } else {
                            ((ImagePanel)AbstractSelectedImagesFeatureGenerator.this.m_CurrentPanel).addDependentFlow(flow);
                        }
                    }
                };
                worker.execute();
            }
            catch (Exception e) {
                result = e.toString();
            }
        }
        return result;
    }
}

