/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.plugins;

import adams.core.option.OptionUtils;
import adams.data.conversion.BufferedImageToImageJ;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.SpreadSheet;
import adams.data.image.BufferedImageContainer;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.features.AbstractImageJFeatureGenerator;
import adams.data.imagej.features.Histogram;
import adams.data.spreadsheet.Row;
import adams.gui.visualization.image.plugins.AbstractSelectedImagesFeatureGenerator;
import java.awt.image.BufferedImage;

public class ImageJFeatureGenerator
extends AbstractSelectedImagesFeatureGenerator {
    private static final long serialVersionUID = 6721788085343201024L;

    public String getMenu() {
        return "Features";
    }

    public String getCaption() {
        return "ImageJ feature generator...";
    }

    public String getIconName() {
        return "imagej.gif";
    }

    protected Class getEditorType() {
        return AbstractImageJFeatureGenerator.class;
    }

    protected Object getDefaultValue() {
        return new Histogram();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    @Override
    protected Row[] generateFeatures(BufferedImage image) {
        Row[] result = null;
        BufferedImageContainer input = new BufferedImageContainer();
        input.setImage((Object)image);
        BufferedImageToImageJ conv = new BufferedImageToImageJ();
        conv.setInput(input);
        this.m_FilterError = conv.convert();
        if (this.m_FilterError == null) {
            this.setLastSetup(this.m_Editor.getValue());
            AbstractImageJFeatureGenerator generator = (AbstractImageJFeatureGenerator)this.m_Editor.getValue();
            generator.setConverter((AbstractFeatureConverter)new SpreadSheet());
            Row[] features = (Row[])generator.generate((ImagePlusContainer)((Object)conv.getOutput()));
            if (features.length == 0) {
                this.m_FilterError = "No features generated!";
            }
            if (features.length > 0) {
                result = features;
            }
        }
        conv.cleanUp();
        return result;
    }
}

