/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class CannyEdgeDynamic<T extends ImageSingleBand, D extends ImageSingleBand>
extends CannyEdge<T, D> {
    public CannyEdgeDynamic(BlurFilter<T> blur, ImageGradient<T, D> gradient, boolean saveTrace) {
        super(blur, gradient, saveTrace);
    }

    @Override
    protected void performThresholding(float threshLow, float threshHigh, ImageUInt8 output) {
        if (threshLow < 0.0f || threshLow > 1.0f || threshHigh < 0.0f || threshHigh > 1.0f) {
            throw new IllegalArgumentException("Relative thresholds must be from 0 to 1, inclusive.");
        }
        float max = ImageStatistics.max((ImageFloat32)this.suppressed);
        threshLow = max * threshLow;
        threshHigh = max * threshHigh;
        if (threshLow <= 0.0f && threshHigh <= 0.0f) {
            if (this.hysteresisPts != null) {
                this.hysteresisPts.getContours().clear();
            }
            if (output != null) {
                ImageMiscOps.fill((ImageInt8)output, (int)0);
            }
        } else {
            super.performThresholding(threshLow, threshHigh, output);
        }
    }
}

