/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.template;

import boofcv.alg.feature.detect.template.TemplateDiffSquared;
import boofcv.alg.feature.detect.template.TemplateMatching;
import boofcv.alg.feature.detect.template.TemplateMatchingIntensity;
import boofcv.alg.feature.detect.template.TemplateNCC;
import boofcv.factory.feature.detect.template.TemplateScoreType;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class FactoryTemplateMatching {
    public static <T extends ImageSingleBand> TemplateMatchingIntensity<T> createIntensity(TemplateScoreType type, Class<T> imageType) {
        switch (type) {
            case SUM_DIFF_SQ: {
                if (imageType == ImageUInt8.class) {
                    return new TemplateDiffSquared.U8();
                }
                if (imageType == ImageFloat32.class) {
                    return new TemplateDiffSquared.F32();
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            case NCC: {
                if (imageType == ImageUInt8.class) {
                    return new TemplateNCC.U8();
                }
                if (imageType == ImageFloat32.class) {
                    return new TemplateNCC.F32();
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
        }
        throw new IllegalArgumentException("Type not found: " + (Object)((Object)type));
    }

    public static <T extends ImageSingleBand> TemplateMatching<T> createMatcher(TemplateScoreType type, Class<T> imageType) {
        TemplateMatchingIntensity<T> intensity = FactoryTemplateMatching.createIntensity(type, imageType);
        return new TemplateMatching<T>(intensity);
    }
}

