/*
 * Decompiled with CFR 0.152.
 */
package weka.utils;

import java.io.File;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.meta.CVParameterSelectionAUC;
import weka.classifiers.meta.CVParameterSelectionAUCMulti;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class IterativeEvaluationExistingPropArffs {
    private String FILE_EXTENSION;
    private Classifier m_classifier;
    private int m_folds = 10;
    private String dirName;
    private String[] dirNames;
    private String modeString;
    private static String TRAINING_FILE_START = "model_prop_";
    private static String TEST_FILE_START = "test_model_prop_";
    private int fileNumberOffset = 0;
    private int maxOffset = 0;
    private int m_iterationSteps = 1;
    private Range modeRange = new Range();
    private Remove cutClass = new Remove();
    private boolean useGZipFile;
    private boolean adjustIterationNumbers;
    private int[] limits;
    public String classifierName;

    public IterativeEvaluationExistingPropArffs() {
        this.cutClass.setAttributeIndices("last");
        this.useGZipFile = false;
        this.FILE_EXTENSION = ".arff";
        this.adjustIterationNumbers = false;
    }

    public String[] getOptions() throws Exception {
        Vector<String> result = new Vector<String>();
        result.add("-F");
        result.add("" + this.getFolds());
        result.add("-O");
        result.add("" + this.getFileNumberOffset());
        result.add("-U");
        result.add("" + this.getMaxOffset());
        if (this.isUseGZipFile()) {
            result.add("-Z");
        }
        result.add("-M");
        result.add("" + this.modeString);
        result.add("-D");
        result.add("" + this.getDirName());
        result.add("-L");
        result.add("" + this.getIterationSteps());
        result.add("-W");
        result.add("" + this.getClassifier().getClass().getName());
        String[] classifierOptions = ((OptionHandler)this.getClassifier()).getOptions();
        for (int i = 0; i < classifierOptions.length; ++i) {
            result.add(classifierOptions[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String iterationStepsString;
        String minNumString = Utils.getOption((char)'F', (String[])options);
        this.m_folds = minNumString.length() != 0 ? Integer.parseInt(minNumString) : 10;
        String offsetString = Utils.getOption((char)'O', (String[])options);
        this.fileNumberOffset = offsetString.length() != 0 ? Integer.parseInt(offsetString) : 0;
        offsetString = Utils.getOption((char)'U', (String[])options);
        this.maxOffset = offsetString.length() != 0 ? Integer.parseInt(offsetString) : 0;
        this.useGZipFile = Utils.getFlag((char)'Z', (String[])options);
        this.FILE_EXTENSION = this.useGZipFile ? ".arff.gz" : ".arff";
        String modeList = Utils.getOption((char)'M', (String[])options);
        if (modeList.length() == 0) {
            throw new IllegalArgumentException("No propositionalisation mode provided");
        }
        this.setAttributeIndices(modeList);
        this.getPropSettings();
        String nameOfDirs = Utils.getOption((char)'D', (String[])options);
        this.dirNames = nameOfDirs.split(",");
        for (int i = 0; i < this.dirNames.length; ++i) {
            if (this.dirNames[i].lastIndexOf("/") == this.dirNames[i].length() - 1) continue;
            this.dirNames[i] = this.dirNames[i] + "/";
        }
        String limitString = Utils.getOption((char)'L', (String[])options);
        if (limitString.length() != 0) {
            this.adjustIterationNumbers = true;
            String[] individualLimits = limitString.split(",");
            this.limits = new int[individualLimits.length];
            for (int i = 0; i < individualLimits.length; ++i) {
                this.limits[i] = Integer.parseInt(individualLimits[i]);
            }
        }
        this.m_iterationSteps = (iterationStepsString = Utils.getOption((char)'S', (String[])options)).length() != 0 ? Integer.parseInt(iterationStepsString) : 1;
        this.classifierName = Utils.getOption((char)'W', (String[])options);
        if (this.classifierName.length() <= 0) {
            throw new Exception("no classifier given");
        }
        this.setClassifier(AbstractClassifier.forName((String)this.classifierName, null));
        this.setClassifier(AbstractClassifier.forName((String)this.classifierName, (String[])Utils.partitionOptions((String[])options)));
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_classifier = newClassifier;
    }

    public Classifier getClassifier() {
        return this.m_classifier;
    }

    private Instances getFullSet(int fileNumber) throws Exception {
        Instances fullSet = null;
        Instances rememberClass = null;
        for (int j = 0; j < this.dirNames.length; ++j) {
            int k;
            if (this.adjustIterationNumbers) {
                fileNumber = this.adjustFileNumber(j, fileNumber);
            }
            this.dirName = this.dirNames[j];
            String modeStringCopy = new String(this.modeString);
            this.modeString = modeStringCopy.charAt(0) + "";
            String fileName = this.dirName + this.modeString + "/" + TRAINING_FILE_START + fileNumber + "_" + this.modeString + this.FILE_EXTENSION;
            ArffLoader loader = new ArffLoader();
            loader.setFile(new File(fileName));
            Instances tempFullSet = loader.getDataSet();
            fileName = this.dirName + this.modeString + "/" + TEST_FILE_START + fileNumber + "_" + this.modeString + this.FILE_EXTENSION;
            loader = new ArffLoader();
            loader.setFile(new File(fileName));
            Instances testSet = loader.getDataSet();
            for (k = 0; k < testSet.numInstances(); ++k) {
                tempFullSet.add(testSet.instance(k));
            }
            if (j == 0) {
                rememberClass = new Instances(tempFullSet);
                for (k = 0; k < tempFullSet.numAttributes() - 1; ++k) {
                    rememberClass.deleteAttributeAt(0);
                }
            }
            this.cutClass.setInputFormat(tempFullSet);
            tempFullSet = Filter.useFilter((Instances)tempFullSet, (Filter)this.cutClass);
            for (k = 0; k < tempFullSet.numAttributes(); ++k) {
                tempFullSet.renameAttribute(k, tempFullSet.attribute(k).name() + "_" + j);
            }
            testSet = null;
            for (int i = 1; i < modeStringCopy.length(); ++i) {
                int k2;
                this.modeString = modeStringCopy.charAt(i) + "";
                fileName = this.dirName + this.modeString + "/" + TRAINING_FILE_START + fileNumber + "_" + this.modeString + this.FILE_EXTENSION;
                loader = new ArffLoader();
                loader.setFile(new File(fileName));
                Instances secondfullSet = loader.getDataSet();
                fileName = this.dirName + this.modeString + "/" + TEST_FILE_START + fileNumber + "_" + this.modeString + this.FILE_EXTENSION;
                loader = new ArffLoader();
                loader.setFile(new File(fileName));
                testSet = loader.getDataSet();
                this.cutClass.setInputFormat(secondfullSet);
                secondfullSet = Filter.useFilter((Instances)secondfullSet, (Filter)this.cutClass);
                this.cutClass.setInputFormat(testSet);
                testSet = Filter.useFilter((Instances)testSet, (Filter)this.cutClass);
                for (k2 = 0; k2 < testSet.numInstances(); ++k2) {
                    secondfullSet.add(testSet.instance(k2));
                }
                for (k2 = 0; k2 < secondfullSet.numAttributes(); ++k2) {
                    secondfullSet.renameAttribute(k2, secondfullSet.attribute(k2).name() + "_" + j);
                }
                testSet = null;
                tempFullSet = Instances.mergeInstances((Instances)tempFullSet, (Instances)secondfullSet);
            }
            this.modeString = modeStringCopy;
            fullSet = j == 0 ? tempFullSet : Instances.mergeInstances((Instances)fullSet, (Instances)tempFullSet);
            tempFullSet = null;
        }
        fullSet = Instances.mergeInstances(fullSet, rememberClass);
        return fullSet;
    }

    private Instances getTrainingSet(int fileNumber) throws Exception {
        Instances fullSet = null;
        Instances rememberClass = null;
        for (int j = 0; j < this.dirNames.length; ++j) {
            int k;
            if (this.adjustIterationNumbers) {
                fileNumber = this.adjustFileNumber(j, fileNumber);
            }
            this.dirName = this.dirNames[j];
            String modeStringCopy = new String(this.modeString);
            this.modeString = modeStringCopy.charAt(0) + "";
            String fileName = this.dirName + this.modeString + "/" + TRAINING_FILE_START + fileNumber + "_" + this.modeString + this.FILE_EXTENSION;
            ArffLoader loader = new ArffLoader();
            loader.setFile(new File(fileName));
            Instances tempFullSet = loader.getDataSet();
            if (j == 0) {
                rememberClass = new Instances(tempFullSet);
                for (k = 0; k < tempFullSet.numAttributes() - 1; ++k) {
                    rememberClass.deleteAttributeAt(0);
                }
            }
            this.cutClass.setInputFormat(tempFullSet);
            tempFullSet = Filter.useFilter((Instances)tempFullSet, (Filter)this.cutClass);
            for (k = 0; k < tempFullSet.numAttributes(); ++k) {
                tempFullSet.renameAttribute(k, tempFullSet.attribute(k).name() + "_" + j);
            }
            for (int i = 1; i < modeStringCopy.length(); ++i) {
                this.modeString = modeStringCopy.charAt(i) + "";
                fileName = this.dirName + this.modeString + "/" + TRAINING_FILE_START + fileNumber + "_" + this.modeString + this.FILE_EXTENSION;
                loader = new ArffLoader();
                loader.setFile(new File(fileName));
                Instances secondfullSet = loader.getDataSet();
                this.cutClass.setInputFormat(secondfullSet);
                secondfullSet = Filter.useFilter((Instances)secondfullSet, (Filter)this.cutClass);
                for (int k2 = 0; k2 < secondfullSet.numAttributes(); ++k2) {
                    secondfullSet.renameAttribute(k2, secondfullSet.attribute(k2).name() + "_" + j);
                }
                tempFullSet = Instances.mergeInstances((Instances)tempFullSet, (Instances)secondfullSet);
            }
            this.modeString = modeStringCopy;
            fullSet = j == 0 ? tempFullSet : Instances.mergeInstances((Instances)fullSet, (Instances)tempFullSet);
            tempFullSet = null;
        }
        fullSet = Instances.mergeInstances(fullSet, rememberClass);
        return fullSet;
    }

    private int adjustFileNumber(int j, int fileNumber) {
        if (fileNumber <= this.limits[j]) {
            return fileNumber;
        }
        int reminder = fileNumber % 10;
        if (reminder == 0) {
            return this.limits[j];
        }
        return this.limits[j] - 10 + reminder;
    }

    private Instances getTestSet(int fileNumber) throws Exception {
        Instances fullSet = null;
        Instances rememberClass = null;
        for (int j = 0; j < this.dirNames.length; ++j) {
            int k;
            if (this.adjustIterationNumbers) {
                fileNumber = this.adjustFileNumber(j, fileNumber);
            }
            this.dirName = this.dirNames[j];
            String modeStringCopy = new String(this.modeString);
            this.modeString = modeStringCopy.charAt(0) + "";
            String fileName = this.dirName + this.modeString + "/" + TEST_FILE_START + fileNumber + "_" + this.modeString + this.FILE_EXTENSION;
            ArffLoader loader = new ArffLoader();
            loader.setFile(new File(fileName));
            Instances tempFullSet = loader.getDataSet();
            if (j == 0) {
                rememberClass = new Instances(tempFullSet);
                for (k = 0; k < tempFullSet.numAttributes() - 1; ++k) {
                    rememberClass.deleteAttributeAt(0);
                }
            }
            this.cutClass.setInputFormat(tempFullSet);
            tempFullSet = Filter.useFilter((Instances)tempFullSet, (Filter)this.cutClass);
            for (k = 0; k < tempFullSet.numAttributes(); ++k) {
                tempFullSet.renameAttribute(k, tempFullSet.attribute(k).name() + "_" + j);
            }
            for (int i = 1; i < modeStringCopy.length(); ++i) {
                this.modeString = modeStringCopy.charAt(i) + "";
                fileName = this.dirName + this.modeString + "/" + TEST_FILE_START + fileNumber + "_" + this.modeString + this.FILE_EXTENSION;
                loader = new ArffLoader();
                loader.setFile(new File(fileName));
                Instances secondfullSet = loader.getDataSet();
                this.cutClass.setInputFormat(secondfullSet);
                secondfullSet = Filter.useFilter((Instances)secondfullSet, (Filter)this.cutClass);
                for (int k2 = 0; k2 < secondfullSet.numAttributes(); ++k2) {
                    secondfullSet.renameAttribute(k2, secondfullSet.attribute(k2).name() + "_" + j);
                }
                tempFullSet = Instances.mergeInstances((Instances)tempFullSet, (Instances)secondfullSet);
            }
            this.modeString = modeStringCopy;
            fullSet = j == 0 ? tempFullSet : Instances.mergeInstances((Instances)fullSet, (Instances)tempFullSet);
            tempFullSet = null;
        }
        fullSet = Instances.mergeInstances(fullSet, rememberClass);
        return fullSet;
    }

    public static void main(String[] args) throws Exception {
        IterativeEvaluationExistingPropArffs itEval = new IterativeEvaluationExistingPropArffs();
        itEval.setOptions(args);
        Classifier actualClassifier = itEval.getClassifier();
        System.out.println("Classifier: " + actualClassifier.toString());
        String[] classifierOptions = ((OptionHandler)actualClassifier).getOptions();
        String options = "";
        for (int i = 0; i < classifierOptions.length; ++i) {
            options = options + classifierOptions[i] + " ";
        }
        int stepSizeIteration = itEval.getIterationSteps();
        int folds = itEval.getFolds();
        int fileNumberOffset = itEval.getFileNumberOffset();
        int maxOffset = itEval.getMaxOffset();
        Vector<Classifier> classifiersForAllFolds = new Vector<Classifier>();
        for (int i = 0; i < folds; ++i) {
            classifiersForAllFolds.add(i, AbstractClassifier.makeCopy((Classifier)actualClassifier));
        }
        long timeStart = System.currentTimeMillis();
        int iteration = 0;
        Vector<Object> pos = null;
        Vector<Object> neg = null;
        while (iteration * 10 + 1 + fileNumberOffset <= maxOffset) {
            int i;
            int fileNumber = iteration * 10 + 1 + fileNumberOffset;
            Instances fullSet = itEval.getFullSet(fileNumber);
            fullSet.setClassIndex(fullSet.numAttributes() - 1);
            Evaluation eval = new Evaluation(fullSet);
            if (iteration == 0) {
                System.out.println("Dataset: " + fullSet.relationName());
                System.out.println("Mode: " + itEval.modeString);
            }
            for (int n = 0; n < folds; ++n) {
                int fileFoldNumber = fileNumber + n;
                Instances train = itEval.getTrainingSet(fileFoldNumber);
                train.setClassIndex(train.numAttributes() - 1);
                Instances test = itEval.getTestSet(fileFoldNumber);
                test.setClassIndex(test.numAttributes() - 1);
                Classifier trainNow = (Classifier)classifiersForAllFolds.get(n);
                trainNow.buildClassifier(train);
                eval.evaluateModel(trainNow, test, new Object[0]);
                classifiersForAllFolds.set(n, trainNow);
                if (trainNow instanceof CVParameterSelectionAUC) {
                    System.out.println(((CVParameterSelectionAUC)trainNow).toSummaryString());
                }
                if (!(trainNow instanceof CVParameterSelectionAUCMulti)) continue;
                System.out.println(((CVParameterSelectionAUCMulti)trainNow).toSummaryString());
            }
            FastVector pred = new FastVector();
            pred = eval.predictions();
            pos = new Vector<Object>();
            neg = new Vector<Object>();
            String classifierInfo = itEval.classifierName + " " + options + " " + itEval.modeString;
            classifierInfo = classifierInfo.replaceAll(" +", "_");
            pos.add(classifierInfo);
            neg.add(classifierInfo);
            for (i = 0; i < pred.size(); ++i) {
                NominalPrediction pred4Instance = (NominalPrediction)pred.elementAt(i);
                double prob = pred4Instance.distribution()[0];
                if (pred4Instance.actual() == 0.0) {
                    pos.add(prob);
                    continue;
                }
                neg.add(prob);
            }
            if (iteration == 0) {
                for (i = 0; i < pos.size(); ++i) {
                    System.out.println(">score for positiv instance " + i + "\t" + pos.elementAt(i));
                }
                System.out.println("\n\n");
                for (i = 0; i < neg.size(); ++i) {
                    System.out.println(">score for negative instance " + i + "\t" + neg.elementAt(i));
                }
            }
            System.out.println("Iterative Evaluation for Iteration: " + (iteration + fileNumberOffset / 10 + 1));
            System.out.println(eval.toSummaryString());
            System.out.println(eval.toClassDetailsString() + "\n\n");
            ++iteration;
        }
        if (iteration != 0) {
            int i;
            for (i = 0; i < pos.size(); ++i) {
                System.out.println(">>score for positiv instance " + i + "\t" + pos.elementAt(i));
            }
            System.out.println("\n\n");
            for (i = 0; i < neg.size(); ++i) {
                System.out.println(">>score for negative instance " + i + "\t" + neg.elementAt(i));
            }
        }
        long timeEnd = System.currentTimeMillis();
        System.out.println("Time elapsed in milliseconds: " + (timeEnd - timeStart));
    }

    public int getFolds() {
        return this.m_folds;
    }

    public void setFolds(int folds) {
        this.m_folds = folds;
    }

    public String getDirName() {
        return this.dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public int getIterationSteps() {
        return this.m_iterationSteps;
    }

    public void setIterationSteps(int steps) {
        this.m_iterationSteps = steps;
    }

    public int getFileNumberOffset() {
        return this.fileNumberOffset;
    }

    public void setFileNumberOffset(int fileNumberOffset) {
        this.fileNumberOffset = fileNumberOffset;
    }

    public int getMaxOffset() {
        return this.maxOffset;
    }

    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
    }

    public void setAttributeIndices(String rangeList) {
        this.modeRange.setRanges(rangeList);
    }

    private void getPropSettings() {
        this.modeString = "";
        this.modeRange.setUpper(6);
        int[] selectedMode = this.modeRange.getSelection();
        for (int i = 0; i < selectedMode.length; ++i) {
            int currentMode = selectedMode[i];
            this.modeString = this.modeString + (currentMode + 1);
        }
    }

    public boolean isUseGZipFile() {
        return this.useGZipFile;
    }

    public void setUseGZipFile(boolean useGZipFile) {
        this.useGZipFile = useGZipFile;
    }
}

