/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.OutputStream;
import java.util.logging.Level;
import weka.core.Instances;
import weka.core.converters.AbstractFileSaver;

public abstract class AbstractWekaSpreadSheetWriter
extends AbstractSpreadSheetWriter {
    private static final long serialVersionUID = -8635190668122194492L;
    protected AbstractFileSaver m_Saver;

    protected void initialize() {
        super.initialize();
        this.m_Saver = this.newSaver();
    }

    protected abstract AbstractFileSaver newSaver();

    protected AbstractSpreadSheetWriter.OutputType getOutputType() {
        return AbstractSpreadSheetWriter.OutputType.STREAM;
    }

    public String getFormatDescription() {
        return this.m_Saver.getFileDescription();
    }

    public String[] getFormatExtensions() {
        return this.m_Saver.getFileExtensions();
    }

    protected boolean doWrite(SpreadSheet content, OutputStream out) {
        boolean result = false;
        try {
            SpreadSheetToWekaInstances convert = new SpreadSheetToWekaInstances();
            convert.setInput(content);
            String msg = convert.convert();
            if (msg == null) {
                Instances data = (Instances)convert.getOutput();
                this.m_Saver.setInstances(data);
                this.m_Saver.setDestination(out);
                this.m_Saver.writeBatch();
                result = true;
            } else {
                this.getLogger().severe("Failed to convert spreadsheet into WEKA Instances:\n" + msg);
                result = false;
            }
            convert.cleanUp();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to save dataset!", e);
            result = false;
        }
        return result;
    }
}

