/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseString;
import adams.core.option.OptionUtils;
import adams.flow.source.AbstractSelectObjects;
import adams.gui.dialog.ApprovalDialog;
import java.awt.Dialog;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import weka.gui.GenericArrayEditor;

public class WekaSelectObjects
extends AbstractSelectObjects {
    private static final long serialVersionUID = 8941008707409028350L;
    protected ApprovalDialog m_Dialog;
    protected GenericArrayEditor m_ArrayEditor;

    public String globalInfo() {
        return "Allows the user to select an arbitrary number of Weka objects from the specified class hierarchy using the GenericObjectArray.";
    }

    public String outputArrayTipText() {
        return "If enabled, the objects get output as array rather than one-by-one.";
    }

    protected Class getItemClass() {
        try {
            return this.m_SuperClass.classValue();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    protected Object commandlineToObject(String cmdline) {
        try {
            return OptionUtils.forAnyCommandLine((Class)this.getItemClass(), (String)cmdline);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to convert commandline: " + cmdline, e);
            return null;
        }
    }

    protected void initializeDialog() {
        if (this.m_Dialog == null) {
            this.m_Dialog = new ApprovalDialog(null, Dialog.ModalityType.DOCUMENT_MODAL);
            if (this.m_ShortTitle) {
                this.m_Dialog.setTitle(this.getName());
            } else {
                this.m_Dialog.setTitle(this.getFullName());
            }
            this.m_ArrayEditor = new GenericArrayEditor();
            this.m_Dialog.getContentPane().add(this.m_ArrayEditor.getCustomEditor(), "Center");
            this.m_Dialog.setSize(600, 400);
            this.m_Dialog.setLocationRelativeTo(null);
        }
        ArrayList<Object> current = new ArrayList<Object>();
        for (BaseString initial : this.m_InitialObjects) {
            Object obj = this.commandlineToObject(initial.getValue());
            if (obj == null) {
                this.getLogger().warning("Failed to convert commandline: " + initial);
            }
            current.add(obj);
        }
        Object array = Array.newInstance(this.getItemClass(), current.size());
        for (int i = 0; i < current.size(); ++i) {
            Array.set(array, i, current.get(i));
        }
        this.m_ArrayEditor.setValue(array);
    }

    protected Object[] showDialog() {
        this.m_Dialog.setVisible(true);
        if (this.m_Dialog.getOption() != 0) {
            return null;
        }
        Object array = this.m_ArrayEditor.getValue();
        Object[] result = new Object[Array.getLength(array)];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Array.get(array, i);
        }
        return result;
    }

    public void stopExecution() {
        if (this.m_Dialog != null) {
            this.m_Dialog.setVisible(false);
        }
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_Dialog != null) {
            final ApprovalDialog dialog = this.m_Dialog;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    dialog.dispose();
                }
            };
            this.m_Dialog = null;
            SwingUtilities.invokeLater(run);
        }
        if (this.m_ArrayEditor != null) {
            this.m_ArrayEditor = null;
        }
        super.wrapUp();
    }
}

