/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.License;
import adams.core.QuickInfoHelper;
import adams.core.annotation.ThirdPartyCopyright;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.PublicPrincipalComponents;

@ThirdPartyCopyright(author="Michael Fowke", license=License.GPL3, copyright="2014 Dutch Sprouts, Wageningen, NL")
public class WekaPrincipalComponents
extends AbstractTransformer {
    private static final long serialVersionUID = -3079556702775500196L;
    protected double m_CoverVariance;
    protected int m_MaxAttributes;
    protected ArrayList<Integer> m_Kept;
    protected int m_NumAttributes;

    public String globalInfo() {
        return "Actor that takes an instances object and carries out principal component analysis to build a model. The coefficients for the model are output in a spreadsheet";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variance-covered", "varianceCovered", (Object)0.95);
        this.m_OptionManager.add("max-attributes", "maximumAttributes", (Object)-1, (Number)-1, null);
    }

    public void setVarianceCovered(double value) {
        this.m_CoverVariance = value;
        this.reset();
    }

    public double getVarianceCovered() {
        return this.m_CoverVariance;
    }

    public String varianceCoveredTipText() {
        return "Retain enough PC attributes to account for this proportion of variance.";
    }

    public void setMaximumAttributes(int value) {
        this.m_MaxAttributes = value;
        this.reset();
    }

    public int getMaximumAttributes() {
        return this.m_MaxAttributes;
    }

    public String maximumAttributesTipText() {
        return "The maximum number of PC attributes to retain.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"varianceCovered", (Object)this.m_CoverVariance, (String)"var: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maxAttributes", (Object)this.m_MaxAttributes, (String)", max attr: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instances.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected SpreadSheet createSpreadSheet(ArrayList<ArrayList<Double>> in) {
        SpreadSheet result = new SpreadSheet();
        HeaderRow rw = result.getHeaderRow();
        Cell c = rw.addCell(0);
        c.setContent("variable");
        for (int i = 0; i < in.size(); ++i) {
            String s = String.valueOf(i);
            c = rw.addCell(s);
            c.setContent(Integer.valueOf(i + 1));
        }
        for (int n = 0; n < this.m_NumAttributes; ++n) {
            DataRow row = result.addRow();
            Cell cell = row.addCell(0);
            cell.setContent(Integer.valueOf(n % 120 + 10));
        }
        for (int i = 0; i < in.size(); ++i) {
            for (int n = 0; n < this.m_NumAttributes; ++n) {
                DataRow row = result.getRow(n);
                if (this.m_Kept.contains(n)) {
                    int index = this.m_Kept.indexOf(n);
                    double value = in.get(i).get(index);
                    Cell cell = row.addCell(i + 1);
                    cell.setContent(Double.valueOf(value));
                    continue;
                }
                Cell cell = row.addCell(i + 1);
                cell.setContent(Integer.valueOf(0));
            }
        }
        return result;
    }

    protected String doExecute() {
        String toReturn = null;
        Instances input = (Instances)this.m_InputToken.getPayload();
        this.m_NumAttributes = input.numAttributes();
        if (input.classIndex() > -1) {
            --this.m_NumAttributes;
        }
        this.m_Kept = new ArrayList();
        for (int i = 0; i < input.numAttributes(); ++i) {
            if (input.classIndex() == i || input.numDistinctValues(i) <= 1) continue;
            this.m_Kept.add(i);
        }
        PublicPrincipalComponents p = new PublicPrincipalComponents();
        p.setMaximumAttributes(this.m_MaxAttributes);
        p.setVarianceCovered(this.m_CoverVariance);
        try {
            p.setInputFormat(input);
        }
        catch (Exception e) {
            toReturn = this.handleException("Failed to set input format", e);
        }
        if (toReturn == null) {
            try {
                Filter.useFilter((Instances)input, (Filter)p);
            }
            catch (Exception e) {
                toReturn = this.handleException("Failed to apply filter", e);
            }
        }
        if (toReturn == null) {
            ArrayList<ArrayList<Double>> coeff = p.getCoefficients();
            SpreadSheet ss = this.createSpreadSheet(coeff);
            this.m_OutputToken = new Token((Object)ss);
        }
        return toReturn;
    }
}

