/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import adams.flow.container.WekaTrainTestSetContainer;
import java.util.NoSuchElementException;
import weka.classifiers.AbstractSplitGenerator;
import weka.core.Instances;

public class CrossValidationFoldGenerator
extends AbstractSplitGenerator {
    private static final long serialVersionUID = -8387205583429213079L;
    public static final String PLACEHOLDER_ORIGINAL = "@";
    public static final String PLACEHOLDER_TYPE = "$T";
    public static final String PLACEHOLDER_CURRENTFOLD = "$N";
    protected int m_NumFolds;
    protected boolean m_Stratify;
    protected int m_CurrentFold;
    protected String m_RelationName;

    public CrossValidationFoldGenerator(Instances data, int numFolds, long seed, boolean stratify) {
        this(data, numFolds, seed, stratify, null);
    }

    public CrossValidationFoldGenerator(Instances data, int numFolds, long seed, boolean stratify, String relName) {
        super(data, seed);
        if (data.classIndex() == -1) {
            throw new IllegalArgumentException("No class attribute set!");
        }
        this.m_NumFolds = numFolds < 2 ? data.numInstances() : numFolds;
        if (data.numInstances() < this.m_NumFolds) {
            throw new IllegalArgumentException("Cannot have less data than folds: required=" + this.m_NumFolds + ", provided=" + data.numInstances());
        }
        if (relName == null || relName.length() == 0) {
            relName = PLACEHOLDER_ORIGINAL;
        }
        this.m_RelationName = relName;
        this.m_CurrentFold = 1;
        this.m_Random = null;
        this.m_Stratify = stratify;
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public boolean getStratify() {
        return this.m_Stratify;
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    @Override
    protected boolean canRandomize() {
        return true;
    }

    @Override
    protected boolean checkNext() {
        return this.m_CurrentFold <= this.m_NumFolds;
    }

    protected String createRelationName(boolean train) {
        StringBuilder result = new StringBuilder();
        String name = this.m_RelationName;
        while (name.length() > 0) {
            int len;
            if (name.startsWith(PLACEHOLDER_ORIGINAL)) {
                len = 1;
                result.append(this.m_Data.relationName());
            } else if (name.startsWith(PLACEHOLDER_TYPE)) {
                len = 2;
                if (train) {
                    result.append("train");
                } else {
                    result.append("test");
                }
            } else if (name.startsWith(PLACEHOLDER_CURRENTFOLD)) {
                len = 2;
                result.append(Integer.toString(this.m_CurrentFold));
            } else {
                len = 1;
                result.append(name.charAt(0));
            }
            name = name.substring(len);
        }
        return result.toString();
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (this.m_Stratify && this.m_Data.classAttribute().isNominal() && this.m_NumFolds < this.m_Data.numInstances()) {
            this.m_Data.stratify(this.m_NumFolds);
        }
    }

    @Override
    protected WekaTrainTestSetContainer createNext() {
        if (this.m_CurrentFold > this.m_NumFolds) {
            throw new NoSuchElementException("No more folds available!");
        }
        Instances train = this.m_Data.trainCV(this.m_NumFolds, this.m_CurrentFold - 1, this.m_Random);
        Instances test = this.m_Data.testCV(this.m_NumFolds, this.m_CurrentFold - 1);
        train.setRelationName(this.createRelationName(true));
        test.setRelationName(this.createRelationName(false));
        WekaTrainTestSetContainer result = new WekaTrainTestSetContainer(train, test, this.m_Seed, this.m_CurrentFold, this.m_NumFolds);
        ++this.m_CurrentFold;
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + ", numFolds=" + this.m_NumFolds + ", relName=" + this.m_RelationName;
    }
}

