/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.NormalizeAdaptive;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class GaussianProcessesAdaptive
extends AbstractClassifier
implements OptionHandler,
IntervalEstimator,
TechnicalInformationHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -8620066941167678545L;
    protected NominalToBinary m_NominalToBinary;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_checksTurnedOff = true;
    protected double m_delta = 1.0;
    protected double m_deltaClass = 1.0;
    protected int m_classIndex = -1;
    protected double m_Alin;
    protected double m_Blin;
    protected Kernel m_kernel = new RBFKernel();
    protected int m_NumTrain = 0;
    protected double m_avg_target;
    public double[][] m_L;
    protected Matrix m_t;
    protected boolean m_KernelIsLinear = false;
    double m_fDev = 0.0;

    public GaussianProcessesAdaptive() {
        ((RBFKernel)this.m_kernel).setGamma(1.0);
    }

    public String globalInfo() {
        return "Implements Gaussian Processes for regression without hyperparameter-tuning. For more information see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "David J.C. Mackay");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Introduction to Gaussian Processes");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Dept. of Physics, Cambridge University, UK");
        result.setValue(TechnicalInformation.Field.PS, "http://wol.ra.phy.cam.ac.uk/mackay/gpB.ps.gz");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = this.getKernel().getCapabilities();
        result.setOwner((CapabilitiesHandler)this);
        result.enableAllAttributeDependencies();
        if (result.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances insts) throws Exception {
        this.buildClassifier2(insts);
    }

    public void buildClassifier2(Instances insts) throws Exception {
        int i;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(insts);
            insts = new Instances(insts);
            insts.deleteWithMissingClass();
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean onlyNumeric = true;
            if (!this.m_checksTurnedOff) {
                for (int i2 = 0; i2 < insts.numAttributes(); ++i2) {
                    if (i2 == insts.classIndex() || insts.attribute(i2).isNumeric()) continue;
                    onlyNumeric = false;
                    break;
                }
            }
            if (!onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(insts);
                insts = Filter.useFilter((Instances)insts, (Filter)this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        this.m_classIndex = insts.classIndex();
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            ((Standardize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new NormalizeAdaptive();
            ((NormalizeAdaptive)this.m_Filter).setIgnoreClass(true);
            ((NormalizeAdaptive)this.m_Filter).setScale(this.m_fDev);
            ((NormalizeAdaptive)this.m_Filter).setClassIndex(insts.classIndex());
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter((Instances)insts, (Filter)this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_NumTrain = insts.numInstances();
        if (this.m_Filter != null) {
            Instance witness = (Instance)insts.instance(0).copy();
            witness.setValue(this.m_classIndex, 0.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            Instance res = this.m_Filter.output();
            this.m_Blin = res.value(this.m_classIndex);
            witness.setValue(this.m_classIndex, 1.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            res = this.m_Filter.output();
            this.m_Alin = res.value(this.m_classIndex) - this.m_Blin;
        } else {
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
        }
        try {
            CachedKernel cachedKernel = (CachedKernel)this.m_kernel;
            cachedKernel.setCacheSize(0);
        }
        catch (Exception cachedKernel) {
            // empty catch block
        }
        this.m_kernel.buildKernel(insts);
        this.m_KernelIsLinear = this.m_kernel instanceof PolyKernel && ((PolyKernel)this.m_kernel).getExponent() == 1.0;
        double sum = 0.0;
        for (int i3 = 0; i3 < insts.numInstances(); ++i3) {
            sum += insts.instance(i3).classValue();
        }
        this.m_avg_target = sum / (double)insts.numInstances();
        int n = insts.numInstances();
        this.m_L = new double[n][];
        for (int i4 = 0; i4 < n; ++i4) {
            this.m_L[i4] = new double[i4 + 1];
        }
        double kv = 0.0;
        for (int i5 = 0; i5 < n; ++i5) {
            for (int j = 0; j < i5; ++j) {
                this.m_L[i5][j] = kv = this.m_kernel.eval(i5, j, insts.instance(i5));
            }
            kv = this.m_kernel.eval(i5, i5, insts.instance(i5));
            this.m_L[i5][i5] = kv + this.m_delta * this.m_delta;
        }
        double[] tmprow = new double[n];
        double tmp2 = 0.0;
        double tmp = 0.0;
        for (int i6 = 0; i6 < n; ++i6) {
            int j;
            tmp = -this.m_L[i6][i6];
            this.m_L[i6][i6] = 1.0 / tmp;
            for (j = 0; j < n; ++j) {
                if (j == i6) continue;
                if (j < i6) {
                    tmprow[j] = this.m_L[i6][j];
                    double[] dArray = this.m_L[i6];
                    int n2 = j;
                    dArray[n2] = dArray[n2] / tmp;
                    tmp2 = this.m_L[i6][j];
                    double[] dArray2 = this.m_L[j];
                    int n3 = j;
                    dArray2[n3] = dArray2[n3] + tmp2 * tmp2 * tmp;
                    continue;
                }
                if (j <= i6) continue;
                tmprow[j] = this.m_L[j][i6];
                double[] dArray = this.m_L[j];
                int n4 = i6;
                dArray[n4] = dArray[n4] / tmp;
                tmp2 = this.m_L[j][i6];
                double[] dArray3 = this.m_L[j];
                int n5 = j;
                dArray3[n5] = dArray3[n5] + tmp2 * tmp2 * tmp;
            }
            for (j = 0; j < n; ++j) {
                int k;
                if (j == i6) continue;
                if (i6 < j) {
                    for (k = 0; k < i6; ++k) {
                        double[] dArray = this.m_L[j];
                        int n6 = k;
                        dArray[n6] = dArray[n6] + tmprow[j] * this.m_L[i6][k];
                    }
                } else {
                    for (k = 0; k < j; ++k) {
                        double[] dArray = this.m_L[j];
                        int n7 = k;
                        dArray[n7] = dArray[n7] + tmprow[j] * this.m_L[i6][k];
                    }
                }
                for (k = i6 + 1; k < j; ++k) {
                    double[] dArray = this.m_L[j];
                    int n8 = k;
                    dArray[n8] = dArray[n8] + tmprow[j] * this.m_L[k][i6];
                }
            }
        }
        this.m_t = new Matrix(insts.numInstances(), 1);
        double[] tt = new double[n];
        for (i = 0; i < n; ++i) {
            tt[i] = insts.instance(i).classValue() - this.m_avg_target;
        }
        for (i = 0; i < n; ++i) {
            int k;
            double s = 0.0;
            for (k = 0; k < i; ++k) {
                s -= this.m_L[i][k] * tt[k];
            }
            for (k = i; k < n; ++k) {
                s -= this.m_L[k][i] * tt[k];
            }
            this.m_t.set(i, 0, s);
        }
    }

    public double classifyInstance(Instance inst) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        Matrix k = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
        }
        double result = k.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        result = (result - this.m_Blin) / this.m_Alin;
        return result;
    }

    public double[][] predictIntervals(Instance inst, double confidenceLevel) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        Matrix k = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
        }
        double estimate = k.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        double kappa = this.m_kernel.eval(-1, -1, inst) + this.m_deltaClass * this.m_deltaClass;
        double s = 0.0;
        int n = this.m_L.length;
        for (int i = 0; i < n; ++i) {
            double t = 0.0;
            for (int j = 0; j < n; ++j) {
                t -= k.get(j, 0) * (i > j ? this.m_L[i][j] : this.m_L[j][i]);
            }
            s += t * k.get(i, 0);
        }
        double sigma = Math.sqrt(kappa - s);
        confidenceLevel = 1.0 - (1.0 - confidenceLevel) / 2.0;
        double z = Statistics.normalInverse((double)confidenceLevel);
        double[][] interval = new double[1][2];
        interval[0][0] = estimate - z * sigma;
        interval[0][1] = estimate + z * sigma;
        interval[0][0] = (interval[0][0] - this.m_Blin) / this.m_Alin;
        interval[0][1] = (interval[0][1] - this.m_Blin) / this.m_Alin;
        return interval;
    }

    public double getStandardDeviation(Instance inst) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        Matrix k = new Matrix(this.m_NumTrain, 1);
        for (int i = 0; i < this.m_NumTrain; ++i) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
        }
        double kappa = this.m_kernel.eval(-1, -1, inst) + this.m_deltaClass * this.m_deltaClass;
        double s = 0.0;
        int n = this.m_L.length;
        for (int i = 0; i < n; ++i) {
            double t = 0.0;
            for (int j = 0; j < n; ++j) {
                t -= k.get(j, 0) * (i > j ? this.m_L[i][j] : this.m_L[j][i]);
            }
            s += t * k.get(i, 0);
        }
        double var = kappa - s;
        if (var < 0.0) {
            System.out.println("Aiaiai: variance is negative (" + var + ")!!!");
        }
        double sigma = Math.sqrt(var);
        return sigma /= this.m_Alin;
    }

    double getLogLikelihood(Instances instances, GaussianProcessesAdaptive GP) throws Exception {
        double L = 0.0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            double m = GP.classifyInstance(instance);
            double v = GP.getStandardDeviation(instance);
            double c = instance.classValue();
            L += -0.5 * Math.log(Math.PI * 2) - Math.log(v) - (m - c) * (m - c) / (2.0 * v * v);
        }
        return L;
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tLevel of Gaussian Noise. (default 0.1)", "L", 1, "-L <double>"));
        result.addElement(new Option("\tLevel of Gaussian Noise for the class. (default 0.1)", "M", 1, "-M <double>"));
        result.addElement(new Option("\tLevel of fDev. (default 0.0)", "F", 1, "-F <double>"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. (default 0=normalize)", "N", 1, "-N"));
        result.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enm = this.getKernel().listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'L', (String[])options);
        if (tmpStr.length() != 0) {
            this.setNoise(Double.parseDouble(tmpStr));
        } else {
            this.setNoise(0.1);
        }
        tmpStr = Utils.getOption((char)'M', (String[])options);
        if (tmpStr.length() != 0) {
            this.setClassNoise(Double.parseDouble(tmpStr));
        } else {
            this.setClassNoise(0.1);
        }
        tmpStr = Utils.getOption((char)'F', (String[])options);
        if (tmpStr.length() != 0) {
            this.setDev(Double.parseDouble(tmpStr));
        } else {
            this.setDev(0.0);
        }
        tmpStr = Utils.getOption((char)'N', (String[])options);
        if (tmpStr.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(tmpStr), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        tmpStr = Utils.getOption((char)'K', (String[])options);
        String[] tmpOptions = Utils.splitOptions((String)tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setKernel(Kernel.forName((String)tmpStr, (String[])tmpOptions));
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-L");
        result.add("" + this.getNoise());
        result.add("-M");
        result.add("" + this.getClassNoise());
        result.add("-F");
        result.add("" + this.getDev());
        result.add("-N");
        result.add("" + this.m_filterType);
        result.add("-K");
        result.add("" + this.m_kernel.getClass().getName() + " " + Utils.joinOptions((String[])this.m_kernel.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public void setKernel(Kernel value) {
        this.m_kernel = value;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String noiseTipText() {
        return "The level of Gaussian Noise (added to the diagonal of the Covariance Matrix).";
    }

    public double getNoise() {
        return this.m_delta;
    }

    public void setNoise(double v) {
        this.m_delta = v;
    }

    public String devTipText() {
        return "dev";
    }

    public void setDev(double v) {
        this.m_fDev = v;
    }

    public double getDev() {
        return this.m_fDev;
    }

    public String classNoiseTipText() {
        return "The level of class noise.";
    }

    public double getClassNoise() {
        return this.m_deltaClass;
    }

    public void setClassNoise(double v) {
        this.m_deltaClass = v;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_t == null) {
            return "Gaussian Processes: No model built yet.";
        }
        try {
            int i;
            text.append("Gaussian Processes\n\n");
            text.append("Kernel used:\n  " + this.m_kernel.toString() + "\n\n");
            text.append("Average Target Value : " + this.m_avg_target + "\n");
            text.append("Inverted Covariance Matrix:\n");
            double min = -this.m_L[0][0];
            double max = -this.m_L[0][0];
            for (i = 0; i < this.m_NumTrain; ++i) {
                for (int j = 0; j <= i; ++j) {
                    if (-this.m_L[i][j] < min) {
                        min = -this.m_L[i][j];
                        continue;
                    }
                    if (!(-this.m_L[i][j] > max)) continue;
                    max = -this.m_L[i][j];
                }
            }
            text.append("    Lowest Value = " + min + "\n");
            text.append("    Highest Value = " + max + "\n");
            text.append("Inverted Covariance Matrix * Target-value Vector:\n");
            min = this.m_t.get(0, 0);
            max = this.m_t.get(0, 0);
            for (i = 0; i < this.m_NumTrain; ++i) {
                if (this.m_t.get(i, 0) < min) {
                    min = this.m_t.get(i, 0);
                    continue;
                }
                if (!(this.m_t.get(i, 0) > max)) continue;
                max = this.m_t.get(i, 0);
            }
            text.append("    Lowest Value = " + min + "\n");
            text.append("    Highest Value = " + max + "\n \n");
            text.append("Dev = " + this.getDev());
        }
        catch (Exception e) {
            return "Can't print the classifier.";
        }
        return text.toString();
    }

    public static void main(String[] argv) {
        GaussianProcessesAdaptive.runClassifier((Classifier)new GaussianProcessesAdaptive(), (String[])argv);
    }

    public String getRevision() {
        return "$Revision: 10824 $";
    }
}

