/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;
import weka.filters.UnsupervisedFilter;

public class Scale
extends SimpleStreamFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 6812351429964183179L;
    protected double m_Min = 0.0;
    protected double m_Max = 1.0;

    public String globalInfo() {
        return "Scales all numeric attributes between the specified min/max.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecifies the minimum that the values should have. (default: 0.0)\n", "min", 1, "-min <double>"));
        result.addElement(new Option("\tSpecifies the maximum that the values should have. (default: 1.0)\n", "max", 1, "-max <double>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"min", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMin(Double.parseDouble(tmpStr));
        } else {
            this.setMin(0.0);
        }
        tmpStr = Utils.getOption((String)"max", (String[])options);
        if (tmpStr.length() != 0) {
            this.setMax(Double.parseDouble(tmpStr));
        } else {
            this.setMax(1.0);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-min");
        result.add("" + this.getMin());
        result.add("-max");
        result.add("" + this.getMax());
        return result.toArray(new String[result.size()]);
    }

    public void setMin(double value) {
        this.m_Min = value;
    }

    public double getMin() {
        return this.m_Min;
    }

    public String minTipText() {
        return "The minimum for the values.";
    }

    public void setMax(double value) {
        this.m_Max = value;
    }

    public double getMax() {
        return this.m_Max;
    }

    public String maxTipText() {
        return "The maximum for the values.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return new Instances(inputFormat, 0);
    }

    protected Instance process(Instance instance) throws Exception {
        int i;
        double[] values = instance.toDoubleArray();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (i = 0; i < values.length; ++i) {
            if (i == instance.classIndex()) continue;
            if (values[i] < min) {
                min = values[i];
            }
            if (!(values[i] > max)) continue;
            max = values[i];
        }
        for (i = 0; i < values.length; ++i) {
            if (i == instance.classIndex()) continue;
            values[i] = max == min ? Utils.missingValue() : this.m_Min + (values[i] - min) / (max - min) * (this.m_Max - this.m_Min);
        }
        Instance result = (Instance)instance.copy();
        for (i = 0; i < values.length; ++i) {
            if (i == instance.classIndex()) continue;
            result.setValue(i, values[i]);
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10824 $");
    }

    public static void main(String[] args) {
        Scale.runFilter((Filter)new Scale(), (String[])args);
    }
}

