/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment.ext;

import adams.core.Utils;
import adams.env.Environment;
import adams.gui.core.AbstractNamedHistoryPanel;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import weka.core.Memory;
import weka.core.logging.Logger;
import weka.gui.GenericObjectEditor;
import weka.gui.LookAndFeel;
import weka.gui.experiment.ext.ExperimenterEntryPanel;
import weka.gui.experiment.ext.ExperimenterPanel;

public class MultiExperimenter
extends BasePanel
implements AbstractNamedHistoryPanel.PopupCustomizer {
    private static final long serialVersionUID = -20320489406680254L;
    public static final String DEFAULT_NAME = "Experiment";
    protected JSplitPane m_SplitPane;
    protected ExperimenterEntryPanel m_History;
    protected BasePanel m_PanelExperimenter;
    protected BasePanel m_PanelHistory;
    protected BasePanel m_PanelButtons;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    private static MultiExperimenter m_Experimenter;
    protected static Memory m_Memory;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new JSplitPane();
        this.add(this.m_SplitPane, "Center");
        this.m_PanelExperimenter = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PanelExperimenter.setMinimumSize(new Dimension(100, 0));
        this.m_SplitPane.setBottomComponent((Component)this.m_PanelExperimenter);
        this.m_History = new ExperimenterEntryPanel();
        this.m_History.setPanel(this.m_PanelExperimenter);
        this.m_History.setPopupCustomizer(this);
        this.m_PanelHistory = new BasePanel((LayoutManager)new BorderLayout());
        this.m_PanelHistory.setMinimumSize(new Dimension(100, 0));
        this.m_PanelHistory.add((Component)((Object)this.m_History), (Object)"Center");
        this.m_PanelButtons = new BasePanel((LayoutManager)new FlowLayout(0));
        this.m_PanelHistory.add((Component)this.m_PanelButtons, (Object)"South");
        this.m_SplitPane.setTopComponent((Component)this.m_PanelHistory);
        this.m_ButtonAdd = new JButton(GUIHelper.getIcon((String)"add.gif"));
        int height = this.m_ButtonAdd.getHeight();
        this.m_ButtonAdd.setSize(height, height);
        this.m_ButtonAdd.setToolTipText("Adds a new Experimenter panel");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String initial = MultiExperimenter.this.m_History.newEntryName(MultiExperimenter.DEFAULT_NAME);
                String name = GUIHelper.showInputDialog((Component)((Object)MultiExperimenter.this), (String)"Please enter the name for the Experimenter panel:", (String)initial);
                if (name == null) {
                    return;
                }
                MultiExperimenter.this.addPanel(new ExperimenterPanel(), name);
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonAdd);
        this.m_ButtonRemove = new JButton(GUIHelper.getIcon((String)"remove.gif"));
        this.m_ButtonRemove.setSize(height, height);
        this.m_ButtonRemove.setToolTipText("Removes all selected Experimenter panels");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = MultiExperimenter.this.m_History.getSelectedIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    MultiExperimenter.this.removePanel(indices[i]);
                }
            }
        });
        this.m_PanelButtons.add((Component)this.m_ButtonRemove);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(0.0);
        this.m_SplitPane.setDividerLocation(250);
    }

    protected void finishInit() {
        super.finishInit();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                MultiExperimenter.this.addPanel(new ExperimenterPanel(), MultiExperimenter.DEFAULT_NAME);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void clear() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                MultiExperimenter.this.m_History.clear();
                MultiExperimenter.this.m_PanelExperimenter.removeAll();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public int count() {
        return this.m_History.count();
    }

    public ExperimenterEntryPanel getHistory() {
        return this.m_History;
    }

    public synchronized void addPanel(ExperimenterPanel panel, String name) {
        this.m_History.addEntry(this.m_History.newEntryName(name), (Object)panel);
        this.m_History.setSelectedIndex(this.count() - 1);
    }

    public synchronized boolean removePanel(String name) {
        boolean result = false;
        if (!this.m_History.hasEntry(name)) {
            return result;
        }
        int index = this.m_History.indexOfEntry(name);
        boolean bl = result = this.m_History.removeEntry(name) != null;
        if (this.m_History.count() > 0) {
            if (this.m_History.count() <= index) {
                --index;
            }
            this.m_History.updateEntry(this.m_History.getEntryName(index));
        }
        return result;
    }

    public synchronized boolean removePanel(int index) {
        return this.removePanel(this.m_History.getEntryName(index));
    }

    public ExperimenterPanel getPanel(String name) {
        return (ExperimenterPanel)((Object)this.m_History.getEntry(name));
    }

    public void load(File file) {
        this.load(new File[]{file});
    }

    public void load(File[] files) {
        for (final File file : files) {
            String name = file.getName();
            if (name.lastIndexOf(46) > -1) {
                name = name.substring(0, name.lastIndexOf(46));
            }
            final ExperimenterPanel panel = new ExperimenterPanel();
            this.addPanel(panel, name);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    panel.openSetup(file);
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    public void customizePopup(final String[] entries, JPopupMenu menu) {
        if (entries.length == 1) {
            JMenuItem menuitem = new JMenuItem("Rename...");
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newName = GUIHelper.showInputDialog((Component)((Object)MultiExperimenter.this), (String)"Please enter the new name:", (String)entries[0]);
                    if (newName == null) {
                        return;
                    }
                    if (entries[0].equals(newName)) {
                        return;
                    }
                    String msg = MultiExperimenter.this.m_History.renameEntry(entries[0], newName);
                    if (msg != null) {
                        GUIHelper.showErrorMessage((Component)((Object)MultiExperimenter.this), (String)msg);
                    }
                }
            });
            menu.add(menuitem);
        }
    }

    public ExperimenterEntryPanel getEntryPanel() {
        return this.m_History;
    }

    public static void runExperimenter(String[] args) {
        String env = "";
        try {
            env = weka.core.Utils.getOption((String)"env", (String[])args);
        }
        catch (Exception e) {
            env = "";
        }
        if (env.isEmpty()) {
            env = Environment.class.getName();
        }
        try {
            Environment.setEnvironmentClass(Class.forName(env));
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate environment class: " + env);
            e.printStackTrace();
            Environment.setEnvironmentClass(Environment.class);
        }
        Logger.log((Logger.Level)Logger.Level.INFO, (String)"Logging started");
        LookAndFeel.setLookAndFeel();
        GenericObjectEditor.determineClasses();
        try {
            m_Experimenter = new MultiExperimenter();
            final BaseFrame frame = new BaseFrame("Multi-Experimenter");
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)((Object)m_Experimenter), "Center");
            frame.pack();
            frame.setSize(1000, 800);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (!m_Memory.isOutOfMemory()) {
                            continue;
                        }
                        frame.dispose();
                        m_Experimenter = null;
                        System.gc();
                        System.err.println("\ndisplayed message:");
                        m_Memory.showOutOfMemory();
                        System.err.println("\nexiting");
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(10);
            memMonitor.start();
        }
        catch (Exception ex) {
            Logger.log((Logger.Level)Logger.Level.SEVERE, (String)Utils.throwableToString((Throwable)ex));
            System.err.println("An Exception occurred: ");
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MultiExperimenter.runExperimenter(args);
    }

    static {
        m_Memory = new Memory(true);
    }
}

