/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jooq;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.data.jooq.AbstractJOOQCodeGeneratorProvider;
import adams.data.jooq.JavaCodeGeneratorProvider;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import java.util.logging.Level;

public abstract class AbstractJOOQConfigurationGenerator
extends AbstractOptionHandler
implements DatabaseConnectionHandler,
QuickInfoSupporter {
    private static final long serialVersionUID = -6440641992533849403L;
    protected PlaceholderFile m_Output;
    protected AbstractJOOQCodeGeneratorProvider m_Provider;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("provider", "provider", (Object)new JavaCodeGeneratorProvider());
    }

    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = null;
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The file to store the XML configuration in.";
    }

    public void setProvider(AbstractJOOQCodeGeneratorProvider value) {
        this.m_Provider = value;
        this.reset();
    }

    public AbstractJOOQCodeGeneratorProvider getProvider() {
        return this.m_Provider;
    }

    public String providerTipText() {
        return "The provider for the jOOQ code generator to use.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"output", (Object)this.m_Output, (String)"output: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"provider", (Object)((Object)this.m_Provider), (String)", provider: ");
        return result;
    }

    protected void check() {
        if (this.m_DatabaseConnection == null) {
            throw new IllegalStateException("No database connection set!");
        }
        if (this.m_Provider == null) {
            throw new IllegalStateException("No jOOQ code generator set!");
        }
        if (this.m_Output.isDirectory()) {
            throw new IllegalStateException("Output points to directory: " + this.m_Output);
        }
        if (!this.m_Output.getParentFile().exists() || !this.m_Output.getParentFile().isDirectory()) {
            throw new IllegalStateException("Output directory either does not exist or is not a directory: " + this.m_Output.getParentFile());
        }
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection = value;
    }

    protected abstract String doGenerate() throws Exception;

    public PlaceholderFile generate() {
        String content;
        this.check();
        try {
            content = this.doGenerate();
        }
        catch (Exception e) {
            Object content2 = null;
            this.getLogger().log(Level.SEVERE, "Failed to generate XML configuration", e);
            return null;
        }
        if (content == null) {
            this.getLogger().severe("Failed to generate XML configuration");
            return null;
        }
        if (!FileUtils.writeToFile((String)this.m_Output.getAbsolutePath(), (Object)content, (boolean)false)) {
            this.getLogger().severe("Failed to write XML configuration to: " + this.m_Output);
            return null;
        }
        return this.m_Output;
    }
}

