/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class BinaryPatternsPyramid
implements LireFeature {
    static ColorConvertOp grayscale = new ColorConvertOp(ColorSpace.getInstance(1003), null);
    int[] tmp255 = new int[]{255};
    int[] tmp128 = new int[]{128};
    int[] tmp000 = new int[]{0};
    int[] tmpPixel = new int[]{0};
    double thresholdLow = 80.0;
    double thresholdHigh = 100.0;
    static int[] binTranslate = new int[256];
    int bins = 36;
    double[] histogram = new double[this.bins + 4 * this.bins + 16 * this.bins];

    @Override
    public void extract(BufferedImage bimg) {
        int y;
        int x;
        int y2;
        int x2;
        double[][] gx = null;
        double[][] gy = null;
        BufferedImage imgEdges = grayscale.filter(bimg, new BufferedImage(bimg.getWidth(), bimg.getHeight(), 10));
        BufferedImage imgGray = grayscale.filter(bimg, new BufferedImage(bimg.getWidth(), bimg.getHeight(), 10));
        gx = new double[imgEdges.getWidth()][imgEdges.getHeight()];
        gy = new double[imgEdges.getWidth()][imgEdges.getHeight()];
        this.sobelFilter(imgEdges, gx, gy);
        int width = imgEdges.getWidth();
        int height = imgEdges.getHeight();
        double[][] gd = new double[width][height];
        double[][] gm = new double[width][height];
        for (x2 = 0; x2 < width; ++x2) {
            for (y2 = 0; y2 < height; ++y2) {
                gd[x2][y2] = gx[x2][y2] != 0.0 ? Math.atan(gy[x2][y2] / gx[x2][y2]) : 1.5707963267948966;
                gm[x2][y2] = Math.hypot(gy[x2][y2], gx[x2][y2]);
            }
        }
        for (x2 = 0; x2 < width; ++x2) {
            imgEdges.getRaster().setPixel(x2, 0, new int[]{255});
            imgEdges.getRaster().setPixel(x2, height - 1, new int[]{255});
        }
        for (int y3 = 0; y3 < height; ++y3) {
            imgEdges.getRaster().setPixel(0, y3, new int[]{255});
            imgEdges.getRaster().setPixel(width - 1, y3, new int[]{255});
        }
        for (x2 = 1; x2 < width - 1; ++x2) {
            for (y2 = 1; y2 < height - 1; ++y2) {
                if (gd[x2][y2] < 0.39269908169872414 && gd[x2][y2] >= -0.39269908169872414) {
                    if (gm[x2][y2] > gm[x2 + 1][y2] && gm[x2][y2] > gm[x2 - 1][y2]) {
                        this.setPixel(x2, y2, imgEdges, gm[x2][y2]);
                        continue;
                    }
                    imgEdges.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < 1.1780972450961724 && gd[x2][y2] >= 0.39269908169872414) {
                    if (gm[x2][y2] > gm[x2 - 1][y2 - 1] && gm[x2][y2] > gm[x2 - 1][y2 - 1]) {
                        this.setPixel(x2, y2, imgEdges, gm[x2][y2]);
                        continue;
                    }
                    imgEdges.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < -1.1780972450961724 || gd[x2][y2] >= 1.1780972450961724) {
                    if (gm[x2][y2] > gm[x2][y2 + 1] && gm[x2][y2] > gm[x2][y2 + 1]) {
                        this.setPixel(x2, y2, imgEdges, gm[x2][y2]);
                        continue;
                    }
                    imgEdges.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < -0.39269908169872414 && gd[x2][y2] >= -1.1780972450961724) {
                    if (gm[x2][y2] > gm[x2 + 1][y2 - 1] && gm[x2][y2] > gm[x2 - 1][y2 + 1]) {
                        this.setPixel(x2, y2, imgEdges, gm[x2][y2]);
                        continue;
                    }
                    imgEdges.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                imgEdges.getRaster().setPixel(x2, y2, this.tmp255);
            }
        }
        int[] tmp = new int[]{0};
        for (x = 1; x < width - 1; ++x) {
            for (y = 1; y < height - 1; ++y) {
                if (imgEdges.getRaster().getPixel(x, y, tmp)[0] >= 50) continue;
                this.trackWeakOnes(x, y, imgEdges);
            }
        }
        for (x = 2; x < width - 2; ++x) {
            for (y = 2; y < height - 2; ++y) {
                if (imgEdges.getRaster().getPixel(x, y, tmp)[0] <= 50) continue;
                imgEdges.getRaster().setPixel(x, y, this.tmp255);
            }
        }
        System.arraycopy(this.getHistogram(0, 0, width, height, imgEdges, imgGray, gd), 0, this.histogram, 0, this.bins);
        System.arraycopy(this.getHistogram(0, 0, width / 2, height / 2, imgEdges, imgGray, gd), 0, this.histogram, this.bins, this.bins);
        System.arraycopy(this.getHistogram(width / 2, 0, width / 2, height / 2, imgEdges, imgGray, gd), 0, this.histogram, 2 * this.bins, this.bins);
        System.arraycopy(this.getHistogram(0, height / 2, width / 2, height / 2, imgEdges, imgGray, gd), 0, this.histogram, 3 * this.bins, this.bins);
        System.arraycopy(this.getHistogram(width / 2, height / 2, width / 2, height / 2, imgEdges, imgGray, gd), 0, this.histogram, 4 * this.bins, this.bins);
        int wstep = width / 4;
        int hstep = height / 4;
        int binPos = 5;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                System.arraycopy(this.getHistogram(i * wstep, j * hstep, wstep, hstep, imgEdges, imgGray, gd), 0, this.histogram, binPos * this.bins, this.bins);
                ++binPos;
            }
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.histogram.length / 2];
        for (int i = 0; i < result.length; ++i) {
            int tmp = (int)this.histogram[i << 1] << 4;
            result[i] = (byte)((tmp |= (int)this.histogram[2 * i + 1]) - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            int tmp = in[i] + 128;
            this.histogram[(i - offset << 1) + 1] = tmp & 0xF;
            this.histogram[i - offset << 1] = tmp >> 4;
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.histogram;
    }

    @Override
    public float getDistance(LireFeature feature) {
        return (float)MetricsUtils.distL1(this.histogram, ((BinaryPatternsPyramid)feature).histogram);
    }

    @Override
    public String getStringRepresentation() {
        return null;
    }

    @Override
    public void setStringRepresentation(String s) {
    }

    private int getBin(int[] pattern) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            min = Math.min(this.getNumber(pattern), min);
            int tmp = pattern[7];
            for (int j = pattern.length - 1; j > 0; --j) {
                pattern[j] = pattern[j - 1];
            }
            pattern[0] = tmp;
        }
        return binTranslate[min];
    }

    private int getNumber(int[] pattern) {
        int result = 0;
        int current = 1;
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] > 0) {
                result += current;
            }
            current *= 2;
        }
        return result;
    }

    private double[] getHistogram(int startX, int startY, int width, int height, BufferedImage edges, BufferedImage original, double[][] gd) {
        int i;
        int[] tmp = new int[]{0};
        double[] result = new double[36];
        double actual = 0.0;
        int[] pixel = new int[9];
        int[] pattern = new int[8];
        Arrays.fill(result, 0.0);
        for (int x = startX; x < startX + width - 2; ++x) {
            for (int y = startY; y < startY + height - 2; ++y) {
                if (edges.getRaster().getPixel(x, y, tmp)[0] >= 50) continue;
                Arrays.fill(pattern, 0);
                original.getRaster().getPixels(x, y, 3, 3, pixel);
                if (pixel[0] >= pixel[4]) {
                    pattern[0] = 1;
                }
                if (pixel[1] >= pixel[4]) {
                    pattern[1] = 1;
                }
                if (pixel[2] >= pixel[4]) {
                    pattern[2] = 1;
                }
                if (pixel[5] >= pixel[4]) {
                    pattern[3] = 1;
                }
                if (pixel[8] >= pixel[4]) {
                    pattern[4] = 1;
                }
                if (pixel[7] >= pixel[4]) {
                    pattern[5] = 1;
                }
                if (pixel[6] >= pixel[4]) {
                    pattern[6] = 1;
                }
                if (pixel[3] >= pixel[4]) {
                    pattern[7] = 1;
                }
                int n = this.getBin(pattern);
                result[n] = result[n] + 1.0;
            }
        }
        double max = 0.0;
        for (i = 0; i < result.length; ++i) {
            max = Math.max(result[i], max);
        }
        if (max > 0.0) {
            for (i = 0; i < result.length; ++i) {
                result[i] = Math.floor(16.0 * result[i] / max);
                result[i] = Math.min(15.0, result[i]);
            }
        }
        return result;
    }

    private void trackWeakOnes(int x, int y, BufferedImage gray) {
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                if (!this.isWeak(xx, yy, gray)) continue;
                gray.getRaster().setPixel(xx, yy, this.tmp000);
                this.trackWeakOnes(xx, yy, gray);
            }
        }
    }

    private boolean isWeak(int x, int y, BufferedImage gray) {
        return gray.getRaster().getPixel(x, y, this.tmpPixel)[0] > 0 && gray.getRaster().getPixel(x, y, this.tmpPixel)[0] < 255;
    }

    private void setPixel(int x, int y, BufferedImage gray, double v) {
        if (v > this.thresholdLow) {
            gray.getRaster().setPixel(x, y, this.tmp000);
        } else if (v > this.thresholdHigh) {
            gray.getRaster().setPixel(x, y, this.tmp128);
        } else {
            gray.getRaster().setPixel(x, y, this.tmp255);
        }
    }

    private void sobelFilter(BufferedImage gray, double[][] gx, double[][] gy) {
        int x;
        int[] tmp = new int[4];
        int tmpSumX = 0;
        int tmpSumY = 0;
        for (x = 1; x < gray.getWidth() - 1; ++x) {
            for (int y = 1; y < gray.getHeight() - 1; ++y) {
                tmpSumX = 0;
                tmpSumY = 0;
                int pix = gray.getRaster().getPixel(x - 1, y - 1, tmp)[0];
                tmpSumX += pix;
                tmpSumY += pix;
                pix = gray.getRaster().getPixel(x - 1, y, tmp)[0];
                tmpSumX += 2 * pix;
                pix = gray.getRaster().getPixel(x - 1, y + 1, tmp)[0];
                tmpSumX += pix;
                tmpSumY -= pix;
                pix = gray.getRaster().getPixel(x + 1, y - 1, tmp)[0];
                tmpSumX -= pix;
                tmpSumY += pix;
                pix = gray.getRaster().getPixel(x + 1, y, tmp)[0];
                tmpSumX -= 2 * pix;
                pix = gray.getRaster().getPixel(x + 1, y + 1, tmp)[0];
                tmpSumY -= pix;
                gx[x][y] = tmpSumX -= pix;
                tmpSumY += 2 * gray.getRaster().getPixel(x, y - 1, tmp)[0];
                gy[x][y] = tmpSumY -= 2 * gray.getRaster().getPixel(x, y + 1, tmp)[0];
            }
        }
        for (x = 0; x < gray.getWidth(); ++x) {
            gx[x][0] = 0.0;
            gx[x][gray.getHeight() - 1] = 0.0;
            gy[x][0] = 0.0;
            gy[x][gray.getHeight() - 1] = 0.0;
        }
        for (int y = 0; y < gray.getHeight(); ++y) {
            gx[0][y] = 0.0;
            gx[gray.getWidth() - 1][y] = 0.0;
            gy[0][y] = 0.0;
            gy[gray.getWidth() - 1][y] = 0.0;
        }
    }

    @Override
    public String getFeatureName() {
        return "Spatial Pyramid of Local Binary Patterns";
    }

    @Override
    public String getFieldName() {
        return "feat_bpp";
    }

    static {
        Arrays.fill(binTranslate, 0);
        BinaryPatternsPyramid.binTranslate[0] = 0;
        BinaryPatternsPyramid.binTranslate[1] = 1;
        BinaryPatternsPyramid.binTranslate[3] = 2;
        BinaryPatternsPyramid.binTranslate[5] = 3;
        BinaryPatternsPyramid.binTranslate[7] = 4;
        BinaryPatternsPyramid.binTranslate[9] = 5;
        BinaryPatternsPyramid.binTranslate[11] = 6;
        BinaryPatternsPyramid.binTranslate[13] = 7;
        BinaryPatternsPyramid.binTranslate[15] = 8;
        BinaryPatternsPyramid.binTranslate[17] = 9;
        BinaryPatternsPyramid.binTranslate[19] = 10;
        BinaryPatternsPyramid.binTranslate[21] = 11;
        BinaryPatternsPyramid.binTranslate[23] = 12;
        BinaryPatternsPyramid.binTranslate[25] = 13;
        BinaryPatternsPyramid.binTranslate[27] = 14;
        BinaryPatternsPyramid.binTranslate[29] = 15;
        BinaryPatternsPyramid.binTranslate[31] = 16;
        BinaryPatternsPyramid.binTranslate[37] = 17;
        BinaryPatternsPyramid.binTranslate[39] = 18;
        BinaryPatternsPyramid.binTranslate[43] = 19;
        BinaryPatternsPyramid.binTranslate[45] = 20;
        BinaryPatternsPyramid.binTranslate[47] = 21;
        BinaryPatternsPyramid.binTranslate[51] = 22;
        BinaryPatternsPyramid.binTranslate[53] = 23;
        BinaryPatternsPyramid.binTranslate[55] = 24;
        BinaryPatternsPyramid.binTranslate[59] = 25;
        BinaryPatternsPyramid.binTranslate[61] = 26;
        BinaryPatternsPyramid.binTranslate[63] = 27;
        BinaryPatternsPyramid.binTranslate[85] = 28;
        BinaryPatternsPyramid.binTranslate[87] = 29;
        BinaryPatternsPyramid.binTranslate[91] = 30;
        BinaryPatternsPyramid.binTranslate[95] = 31;
        BinaryPatternsPyramid.binTranslate[111] = 32;
        BinaryPatternsPyramid.binTranslate[119] = 33;
        BinaryPatternsPyramid.binTranslate[127] = 34;
        BinaryPatternsPyramid.binTranslate[255] = 35;
    }
}

