/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.mpeg7.ColorLayoutImpl;

public class ColorLayout
extends ColorLayoutImpl
implements LireFeature {
    @Override
    public byte[] getByteArrayRepresentation() {
        int i;
        byte[] result = new byte[2 + this.numYCoeff + 2 * this.numCCoeff];
        result[0] = (byte)this.numYCoeff;
        result[1] = (byte)this.numCCoeff;
        for (i = 0; i < this.numYCoeff; ++i) {
            result[2 + i] = (byte)this.YCoeff[i];
        }
        for (i = 0; i < this.numCCoeff; ++i) {
            result[2 + this.numYCoeff + i] = (byte)this.CbCoeff[i];
            result[2 + this.numYCoeff + this.numCCoeff + i] = (byte)this.CrCoeff[i];
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        int i;
        this.numYCoeff = in[0];
        this.numCCoeff = in[1];
        for (i = 0; i < this.numYCoeff; ++i) {
            this.YCoeff[i] = in[2 + i];
        }
        for (i = 0; i < this.numCCoeff; ++i) {
            this.CbCoeff[i] = in[i + 2 + this.numYCoeff];
            this.CrCoeff[i] = in[i + 2 + this.numYCoeff + this.numCCoeff];
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        int i;
        this.numYCoeff = in[0 + offset];
        this.numCCoeff = in[1 + offset];
        for (i = 0; i < this.numYCoeff; ++i) {
            this.YCoeff[i] = in[2 + i + offset];
        }
        for (i = 0; i < this.numCCoeff; ++i) {
            this.CbCoeff[i] = in[i + 2 + this.numYCoeff + offset];
            this.CrCoeff[i] = in[i + 2 + this.numYCoeff + this.numCCoeff + offset];
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        int i;
        double[] result = new double[this.numYCoeff + this.numCCoeff * 2];
        for (i = 0; i < this.numYCoeff; ++i) {
            result[i] = this.YCoeff[i];
        }
        for (i = 0; i < this.numCCoeff; ++i) {
            result[i + this.numYCoeff] = this.CbCoeff[i];
            result[i + this.numCCoeff + this.numYCoeff] = this.CrCoeff[i];
        }
        return result;
    }

    @Override
    public float getDistance(LireFeature descriptor) {
        if (!(descriptor instanceof ColorLayoutImpl)) {
            return -1.0f;
        }
        ColorLayoutImpl cl = (ColorLayoutImpl)((Object)descriptor);
        return (float)ColorLayout.getSimilarity(this.YCoeff, this.CbCoeff, this.CrCoeff, cl.YCoeff, cl.CbCoeff, cl.CrCoeff);
    }

    @Override
    public String getFeatureName() {
        return "MPEG-7 Color Layout";
    }

    @Override
    public String getFieldName() {
        return "descriptorColorLayout";
    }
}

