/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser;

import net.semanticmetadata.lire.imageanalysis.mser.ImagePoint;

public class BoundaryPixel {
    public static final int RIGHT_EDGE = 0;
    public static final int BOTTOM_EDGE = 2;
    public static final int LEFT_EDGE = 4;
    public static final int TOP_EDGE = 6;
    public static final int NO_EDGE = 8;
    protected int imageWidth;
    protected int imageHeight;
    protected ImagePoint point;
    protected int nextEdge;

    public BoundaryPixel(ImagePoint point, int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.point = point;
        this.nextEdge = 0;
    }

    public ImagePoint getPoint() {
        return this.point;
    }

    public int getIndex() {
        return this.point.getIndex();
    }

    public int getX() {
        return this.point.getX();
    }

    public int getY() {
        return this.point.getY();
    }

    public ImagePoint calcNextEdge() {
        switch (this.nextEdge) {
            case 0: {
                ImagePoint nextEdgePoint = this.getRightNeighbor();
                if (nextEdgePoint != null) {
                    this.nextEdge = 2;
                    return nextEdgePoint;
                }
            }
            case 2: {
                ImagePoint nextEdgePoint = this.getBottomNeighbor();
                if (nextEdgePoint != null) {
                    this.nextEdge = 4;
                    return nextEdgePoint;
                }
            }
            case 4: {
                ImagePoint nextEdgePoint = this.getLeftNeighbor();
                if (nextEdgePoint != null) {
                    this.nextEdge = 6;
                    return nextEdgePoint;
                }
            }
            case 6: {
                ImagePoint nextEdgePoint = this.getTopNeighbor();
                if (nextEdgePoint == null) break;
                this.nextEdge = 8;
                return nextEdgePoint;
            }
        }
        this.nextEdge = 8;
        return null;
    }

    public BoundaryPixel getNextBoundary() {
        ImagePoint nextEdge = this.calcNextEdge();
        if (nextEdge != null) {
            return new BoundaryPixel(nextEdge, this.imageWidth, this.imageHeight);
        }
        return null;
    }

    protected ImagePoint getTopNeighbor() {
        if (this.getY() == 0) {
            return null;
        }
        return new ImagePoint(this.getIndex() - this.imageWidth, this.imageWidth);
    }

    protected ImagePoint getLeftNeighbor() {
        if (this.getX() == 0) {
            return null;
        }
        return new ImagePoint(this.getIndex() - 1, this.imageWidth);
    }

    protected ImagePoint getBottomNeighbor() {
        if (this.getY() == this.imageHeight - 1) {
            return null;
        }
        return new ImagePoint(this.getIndex() + this.imageWidth, this.imageWidth);
    }

    protected ImagePoint getRightNeighbor() {
        if (this.getX() == this.imageWidth - 1) {
            return null;
        }
        return new ImagePoint(this.getIndex() + 1, this.imageWidth);
    }
}

