/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.sift;

import java.util.List;
import java.util.Vector;
import net.semanticmetadata.lire.imageanalysis.sift.Feature;
import net.semanticmetadata.lire.imageanalysis.sift.Filter;
import net.semanticmetadata.lire.imageanalysis.sift.FloatArray2D;
import net.semanticmetadata.lire.imageanalysis.sift.FloatArray2DScaleOctave;
import net.semanticmetadata.lire.imageanalysis.sift.FloatArray2DScaleOctaveDoGDetector;
import net.semanticmetadata.lire.imageanalysis.sift.Model;
import net.semanticmetadata.lire.imageanalysis.sift.Point;
import net.semanticmetadata.lire.imageanalysis.sift.PointMatch;

public class FloatArray2DSIFT {
    private int FEATURE_DESCRIPTOR_SIZE;
    private int FEATURE_DESCRIPTOR_WIDTH;
    private int FEATURE_DESCRIPTOR_ORIENTATION_BINS = 0;
    private float FEATURE_DESCRIPTOR_ORIENTATION_BIN_SIZE = 0.0f;
    private float[][] descriptorMask;
    private FloatArray2DScaleOctave[] octaves = null;
    private FloatArray2DScaleOctaveDoGDetector dog = new FloatArray2DScaleOctaveDoGDetector();

    public long getFeatureObjectSize() {
        return FloatArray2DSIFT.getFeatureObjectSize(this.FEATURE_DESCRIPTOR_SIZE, this.FEATURE_DESCRIPTOR_ORIENTATION_BINS);
    }

    public static long getFeatureObjectSize(int fdsize, int fdbins) {
        return 48 + fdsize * fdsize * fdbins * 4 + 32 + 32;
    }

    public FloatArray2DScaleOctave[] getOctaves() {
        return this.octaves;
    }

    public FloatArray2DScaleOctave getOctave(int i) {
        return this.octaves[i];
    }

    public FloatArray2DSIFT(int feature_descriptor_size, int feature_descriptor_orientation_bins) {
        this.FEATURE_DESCRIPTOR_SIZE = feature_descriptor_size;
        this.FEATURE_DESCRIPTOR_WIDTH = 4 * this.FEATURE_DESCRIPTOR_SIZE;
        this.FEATURE_DESCRIPTOR_ORIENTATION_BINS = feature_descriptor_orientation_bins;
        this.FEATURE_DESCRIPTOR_ORIENTATION_BIN_SIZE = (float)Math.PI * 2 / (float)this.FEATURE_DESCRIPTOR_ORIENTATION_BINS;
        this.descriptorMask = new float[this.FEATURE_DESCRIPTOR_SIZE * 4][this.FEATURE_DESCRIPTOR_SIZE * 4];
        float two_sq_sigma = this.FEATURE_DESCRIPTOR_SIZE * this.FEATURE_DESCRIPTOR_SIZE * 8;
        for (int y = this.FEATURE_DESCRIPTOR_SIZE * 2 - 1; y >= 0; --y) {
            float fy = (float)y + 0.5f;
            for (int x = this.FEATURE_DESCRIPTOR_SIZE * 2 - 1; x >= 0; --x) {
                float val;
                float fx = (float)x + 0.5f;
                this.descriptorMask[2 * this.FEATURE_DESCRIPTOR_SIZE - 1 - y][2 * this.FEATURE_DESCRIPTOR_SIZE - 1 - x] = val = (float)Math.exp(-(fy * fy + fx * fx) / two_sq_sigma);
                this.descriptorMask[2 * this.FEATURE_DESCRIPTOR_SIZE + y][2 * this.FEATURE_DESCRIPTOR_SIZE - 1 - x] = val;
                this.descriptorMask[2 * this.FEATURE_DESCRIPTOR_SIZE - 1 - y][2 * this.FEATURE_DESCRIPTOR_SIZE + x] = val;
                this.descriptorMask[2 * this.FEATURE_DESCRIPTOR_SIZE + y][2 * this.FEATURE_DESCRIPTOR_SIZE + x] = val;
            }
        }
    }

    public void init(FloatArray2D src, int steps, float initial_sigma, int min_size, int max_size) {
        int o = 0;
        float w = src.width;
        float h = src.height;
        while (w > (float)min_size && h > (float)min_size) {
            w /= 2.0f;
            h /= 2.0f;
            ++o;
        }
        this.octaves = new FloatArray2DScaleOctave[o];
        float[] sigma = new float[steps + 3];
        sigma[0] = initial_sigma;
        float[] sigma_diff = new float[steps + 3];
        sigma_diff[0] = 0.0f;
        float[][] kernel_diff = new float[steps + 3][];
        for (int i = 1; i < steps + 3; ++i) {
            sigma[i] = initial_sigma * (float)Math.pow(2.0, (float)i / (float)steps);
            sigma_diff[i] = (float)Math.sqrt(sigma[i] * sigma[i] - initial_sigma * initial_sigma);
            kernel_diff[i] = Filter.createGaussianKernel1D(sigma_diff[i], true);
        }
        for (int i = 0; i < this.octaves.length; ++i) {
            this.octaves[i] = new FloatArray2DScaleOctave(src, sigma, sigma_diff, kernel_diff);
            this.octaves[i].buildStub();
            FloatArray2D next = new FloatArray2D(src.width / 2 + src.width % 2, src.height / 2 + src.height % 2);
            FloatArray2DScaleOctave.downsample(this.octaves[i].getL(1), next);
            if (src.width > max_size || src.height > max_size) {
                this.octaves[i].clear();
            }
            src = next;
        }
    }

    private float[] createDescriptor(float[] c, int o, float octave_sigma, float orientation) {
        FloatArray2DScaleOctave octave = this.octaves[o];
        FloatArray2D[] gradients = octave.getL1(Math.round(c[2]));
        FloatArray2D[] region = new FloatArray2D[]{new FloatArray2D(this.FEATURE_DESCRIPTOR_WIDTH, this.FEATURE_DESCRIPTOR_WIDTH), new FloatArray2D(this.FEATURE_DESCRIPTOR_WIDTH, this.FEATURE_DESCRIPTOR_WIDTH)};
        float cos_o = (float)Math.cos(orientation);
        float sin_o = (float)Math.sin(orientation);
        for (int y = this.FEATURE_DESCRIPTOR_WIDTH - 1; y >= 0; --y) {
            float ys = ((float)y - 2.0f * (float)this.FEATURE_DESCRIPTOR_SIZE + 0.5f) * octave_sigma;
            for (int x = this.FEATURE_DESCRIPTOR_WIDTH - 1; x >= 0; --x) {
                float xs = ((float)x - 2.0f * (float)this.FEATURE_DESCRIPTOR_SIZE + 0.5f) * octave_sigma;
                float yr = cos_o * ys + sin_o * xs;
                float xr = cos_o * xs - sin_o * ys;
                int yg = Filter.flipInRange(Math.round(yr + c[1]), gradients[0].height);
                int xg = Filter.flipInRange(Math.round(xr + c[0]), gradients[0].width);
                int region_p = this.FEATURE_DESCRIPTOR_WIDTH * y + x;
                int gradient_p = gradients[0].width * yg + xg;
                region[0].data[region_p] = gradients[0].data[gradient_p] * this.descriptorMask[y][x];
                region[1].data[region_p] = gradients[1].data[gradient_p] - orientation;
            }
        }
        float[][][] hist = new float[this.FEATURE_DESCRIPTOR_SIZE][this.FEATURE_DESCRIPTOR_SIZE][this.FEATURE_DESCRIPTOR_ORIENTATION_BINS];
        for (int y = this.FEATURE_DESCRIPTOR_SIZE - 1; y >= 0; --y) {
            int yp = this.FEATURE_DESCRIPTOR_SIZE * 16 * y;
            for (int x = this.FEATURE_DESCRIPTOR_SIZE - 1; x >= 0; --x) {
                int xp = 4 * x;
                for (int ysr = 3; ysr >= 0; --ysr) {
                    int ysrp = 4 * this.FEATURE_DESCRIPTOR_SIZE * ysr;
                    for (int xsr = 3; xsr >= 0; --xsr) {
                        float bin_location = (region[1].data[yp + xp + ysrp + xsr] + (float)Math.PI) / this.FEATURE_DESCRIPTOR_ORIENTATION_BIN_SIZE;
                        int bin_b = (int)bin_location;
                        int bin_t = bin_b + 1;
                        float d = bin_location - (float)bin_b;
                        bin_b = (bin_b + 2 * this.FEATURE_DESCRIPTOR_ORIENTATION_BINS) % this.FEATURE_DESCRIPTOR_ORIENTATION_BINS;
                        bin_t = (bin_t + 2 * this.FEATURE_DESCRIPTOR_ORIENTATION_BINS) % this.FEATURE_DESCRIPTOR_ORIENTATION_BINS;
                        float t = region[0].data[yp + xp + ysrp + xsr];
                        float[] fArray = hist[y][x];
                        int n = bin_b;
                        fArray[n] = fArray[n] + t * (1.0f - d);
                        float[] fArray2 = hist[y][x];
                        int n2 = bin_t;
                        fArray2[n2] = fArray2[n2] + t * d;
                    }
                }
            }
        }
        float[] desc = new float[this.FEATURE_DESCRIPTOR_SIZE * this.FEATURE_DESCRIPTOR_SIZE * this.FEATURE_DESCRIPTOR_ORIENTATION_BINS];
        float max_bin_val = 0.0f;
        int i = 0;
        for (int y = this.FEATURE_DESCRIPTOR_SIZE - 1; y >= 0; --y) {
            for (int x = this.FEATURE_DESCRIPTOR_SIZE - 1; x >= 0; --x) {
                for (int b = this.FEATURE_DESCRIPTOR_ORIENTATION_BINS - 1; b >= 0; --b) {
                    desc[i] = hist[y][x][b];
                    if (desc[i] > max_bin_val) {
                        max_bin_val = desc[i];
                    }
                    ++i;
                }
            }
        }
        max_bin_val = (float)((double)max_bin_val / 0.2);
        for (i = 0; i < desc.length; ++i) {
            desc[i] = (float)Math.min(1.0, (double)(desc[i] / max_bin_val));
        }
        return desc;
    }

    void processCandidate(float[] c, int o, Vector<Feature> features) {
        int i;
        int ORIENTATION_BINS = 36;
        float ORIENTATION_BIN_SIZE = 0.17453294f;
        float[] histogram_bins = new float[36];
        int scale = (int)Math.pow(2.0, o);
        FloatArray2DScaleOctave octave = this.octaves[o];
        float octave_sigma = octave.SIGMA[0] * (float)Math.pow(2.0, c[2] / (float)octave.STEPS);
        FloatArray2D gaussianMask = Filter.create_gaussian_kernel_2D_offset(octave_sigma * 1.5f, c[0] - (float)Math.floor(c[0]), c[1] - (float)Math.floor(c[1]), false);
        FloatArray2D[] src = octave.getL1(Math.round(c[2]));
        FloatArray2D[] gradientROI = new FloatArray2D[]{new FloatArray2D(gaussianMask.width, gaussianMask.width), new FloatArray2D(gaussianMask.width, gaussianMask.width)};
        int half_size = gaussianMask.width / 2;
        int p = gaussianMask.width * gaussianMask.width - 1;
        for (int yi = gaussianMask.width - 1; yi >= 0; --yi) {
            int ra_y = src[0].width * Math.max(0, Math.min(src[0].height - 1, (int)c[1] + yi - half_size));
            int ra_x = ra_y + Math.min((int)c[0], src[0].width - 1);
            for (int xi = gaussianMask.width - 1; xi >= 0; --xi) {
                int pt = Math.max(ra_y, Math.min(ra_y + src[0].width - 2, ra_x + xi - half_size));
                gradientROI[0].data[p] = src[0].data[pt];
                gradientROI[1].data[p] = src[1].data[pt];
                --p;
            }
        }
        for (i = 0; i < gradientROI[0].data.length; ++i) {
            int n = i;
            gradientROI[0].data[n] = gradientROI[0].data[n] * gaussianMask.data[i];
        }
        for (i = 0; i < gradientROI[0].data.length; ++i) {
            int bin;
            int n = bin = Math.max(0, (int)(((double)gradientROI[1].data[i] + Math.PI) / 0.1745329350233078));
            histogram_bins[n] = histogram_bins[n] + gradientROI[0].data[i];
        }
        int max_i = 0;
        for (int i2 = 0; i2 < 36; ++i2) {
            if (!(histogram_bins[i2] > histogram_bins[max_i])) continue;
            max_i = i2;
        }
        float e0 = histogram_bins[(max_i + 36 - 1) % 36];
        float e1 = histogram_bins[max_i];
        float e2 = histogram_bins[(max_i + 1) % 36];
        float offset = (e0 - e2) / 2.0f / (e0 - 2.0f * e1 + e2);
        float orientation = ((float)max_i + offset) * 0.17453294f - (float)Math.PI;
        features.addElement(new Feature(octave_sigma * (float)scale, orientation, new float[]{c[0] * (float)scale, c[1] * (float)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
        for (int i3 = 0; i3 < 36; ++i3) {
            if (i3 == max_i || (max_i + 1) % 36 == i3 || (max_i - 1 + 36) % 36 == i3 || !((double)histogram_bins[i3] > 0.8 * (double)histogram_bins[max_i])) continue;
            e0 = histogram_bins[(i3 + 36 - 1) % 36];
            e1 = histogram_bins[i3];
            e2 = histogram_bins[(i3 + 1) % 36];
            if (!(e0 < e1) || !(e2 < e1)) continue;
            offset = (e0 - e2) / 2.0f / (e0 - 2.0f * e1 + e2);
            orientation = ((float)i3 + 0.5f + offset) * 0.17453294f - (float)Math.PI;
            features.addElement(new Feature(octave_sigma * (float)scale, orientation, new float[]{c[0] * (float)scale, c[1] * (float)scale}, this.createDescriptor(c, o, octave_sigma, orientation)));
        }
    }

    public Vector<Feature> runOctave(int o) {
        Vector<Feature> features = new Vector<Feature>();
        FloatArray2DScaleOctave octave = this.octaves[o];
        octave.build();
        this.dog.run(octave);
        Vector<float[]> candidates = this.dog.getCandidates();
        for (float[] c : candidates) {
            this.processCandidate(c, o, features);
        }
        return features;
    }

    public Vector<Feature> run() {
        Vector<Feature> features = new Vector<Feature>();
        for (int o = 0; o < this.octaves.length; ++o) {
            if (this.octaves[o].state == FloatArray2DScaleOctave.State.EMPTY) continue;
            Vector<Feature> more = this.runOctave(o);
            features.addAll(more);
        }
        return features;
    }

    public Vector<Feature> run(int max_size) {
        Vector<Feature> features = new Vector<Feature>();
        for (int o = 0; o < this.octaves.length; ++o) {
            if (this.octaves[o].width > max_size || this.octaves[o].height > max_size) continue;
            Vector<Feature> more = this.runOctave(o);
            features.addAll(more);
        }
        return features;
    }

    public static Vector<PointMatch> createMatches(List<Feature> fs1, List<Feature> fs2, float max_sd, Model model, float max_id) {
        Vector<PointMatch> matches = new Vector<PointMatch>();
        float min_sd = 1.0f / max_sd;
        int size = fs2.size();
        int size_1 = size - 1;
        for (Feature f1 : fs1) {
            Feature best = null;
            float best_d = Float.MAX_VALUE;
            float second_best_d = Float.MAX_VALUE;
            int first = 0;
            int last = size_1;
            int s = size / 2 + size % 2;
            if (max_sd < Float.MAX_VALUE) {
                while (s > 1) {
                    Feature f2 = fs2.get(last);
                    last = f2.scale / f1.scale < min_sd ? Math.max(0, last - s) : Math.min(size_1, last + s);
                    f2 = fs2.get(first);
                    first = f2.scale / f1.scale < max_sd ? Math.max(0, first - s) : Math.min(size_1, first + s);
                    s = s / 2 + s % 2;
                }
            }
            for (int i = first; i <= last; ++i) {
                Feature f2 = fs2.get(i);
                float d = f1.descriptorDistance(f2);
                if (d < best_d) {
                    second_best_d = best_d;
                    best_d = d;
                    best = f2;
                    continue;
                }
                if (!(d < second_best_d)) continue;
                second_best_d = d;
            }
            if (best == null || !(second_best_d < Float.MAX_VALUE) || !((double)(best_d / second_best_d) < 0.92)) continue;
            matches.addElement(new PointMatch(new Point(new float[]{f1.location[0], f1.location[1]}), new Point(new float[]{best.location[0], best.location[1]}), (f1.scale + best.scale) / 2.0f));
        }
        int i = 0;
        while (i < matches.size()) {
            boolean amb = false;
            PointMatch m = matches.get(i);
            float[] m_p2 = m.getP2().getL();
            int j = i + 1;
            while (j < matches.size()) {
                PointMatch n = matches.get(j);
                float[] n_p2 = n.getP2().getL();
                if (m_p2[0] == n_p2[0] && m_p2[1] == n_p2[1]) {
                    amb = true;
                    matches.removeElementAt(j);
                    continue;
                }
                ++j;
            }
            if (amb) {
                matches.removeElementAt(i);
                continue;
            }
            ++i;
        }
        return matches;
    }

    public static float[] featureSizeHistogram(Vector<Feature> features, float min, float max, int bins) {
        System.out.print("estimating feature size histogram ...");
        int num_features = features.size();
        float[] h = new float[bins];
        int[] hb = new int[bins];
        for (Feature f : features) {
            int bin;
            int n = bin = Math.max(0, Math.min(bins - 1, (int)(Math.log(f.scale) / Math.log(2.0) * 28.0)));
            hb[n] = hb[n] + 1;
        }
        for (int i = 0; i < bins; ++i) {
            h[i] = (float)hb[i] / (float)num_features;
        }
        System.out.println(" done");
        return h;
    }
}

