/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.impl.SimpleImageSearchHits;
import net.semanticmetadata.lire.impl.SimpleResult;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.Bits;

public class TopDocsImageSearcher {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    Class<?> descriptorClass;
    String fieldName;
    private int maxHits = 10;
    protected TreeSet<SimpleResult> docs;

    public TopDocsImageSearcher(int maxHits, Class<?> descriptorClass, String fieldName) {
        this.maxHits = maxHits;
        this.docs = new TreeSet();
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
    }

    public ImageSearchHits search(BufferedImage image, IndexReader reader, TopDocs results) throws IOException {
        this.logger.finer("Starting extraction.");
        LireFeature lireFeature = null;
        SimpleImageSearchHits searchHits = null;
        try {
            lireFeature = (LireFeature)this.descriptorClass.newInstance();
            BufferedImage bimg = image;
            if (Math.max(image.getHeight(), image.getWidth()) > 1024) {
                bimg = ImageUtils.scaleImage(image, 1024);
            }
            lireFeature.extract(bimg);
            this.logger.fine("Extraction from image finished");
            float maxDistance = this.findSimilar(results, reader, lireFeature);
            searchHits = new SimpleImageSearchHits(this.docs, maxDistance);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    protected float findSimilar(TopDocs results, IndexReader reader, LireFeature lireFeature) throws IOException {
        float maxDistance = -1.0f;
        float overallMaxDistance = -1.0f;
        boolean hasDeletions = reader.hasDeletions();
        this.docs.clear();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        int docs = results.totalHits;
        for (int i = 0; i < docs; ++i) {
            if (reader.hasDeletions() && !liveDocs.get(i)) continue;
            Document d = reader.document(results.scoreDocs[i].doc);
            float distance = this.getDistance(d, lireFeature);
            assert (distance >= 0.0f);
            if (overallMaxDistance < distance) {
                overallMaxDistance = distance;
            }
            if (maxDistance < 0.0f) {
                maxDistance = distance;
            }
            if (this.docs.size() < this.maxHits) {
                this.docs.add(new SimpleResult(distance, d, i));
                if (!(distance > maxDistance)) continue;
                maxDistance = distance;
                continue;
            }
            if (!(distance < maxDistance)) continue;
            this.docs.remove(this.docs.last());
            this.docs.add(new SimpleResult(distance, d, i));
            maxDistance = this.docs.last().getDistance();
        }
        return maxDistance;
    }

    protected float getDistance(Document d, LireFeature lireFeature) {
        float distance = 0.0f;
        try {
            LireFeature lf = (LireFeature)this.descriptorClass.newInstance();
            String[] cls = d.getValues(this.fieldName);
            if (cls != null && cls.length > 0) {
                lf.setStringRepresentation(cls[0]);
                distance = lireFeature.getDistance(lf);
            } else {
                this.logger.warning("No feature stored in this document!");
            }
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return distance;
    }

    public ImageSearchHits search(TopDocs results, Document doc, IndexReader reader) throws IOException {
        SimpleImageSearchHits searchHits = null;
        try {
            LireFeature lireFeature = (LireFeature)this.descriptorClass.newInstance();
            String[] cls = doc.getValues(this.fieldName);
            if (cls != null && cls.length > 0) {
                lireFeature.setStringRepresentation(cls[0]);
            }
            float maxDistance = this.findSimilar(results, reader, lireFeature);
            searchHits = new SimpleImageSearchHits(this.docs, maxDistance);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    public String toString() {
        return "TopDocsImageSearcher using " + this.descriptorClass.getName();
    }
}

