/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.quadblob;

import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import georegression.geometry.UtilPoint2D_I32;
import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.sorting.QuickSort_F64;
import org.ddogleg.struct.GrowQueue_F64;

public class FindQuadCorners {
    int N;
    GrowQueue_F64 acuteAngles = new GrowQueue_F64();
    GrowQueue_F64 acuteCorners = new GrowQueue_F64();
    Point2D_I32 center = new Point2D_I32();
    List<Point2D_I32> candidates = new ArrayList<Point2D_I32>();

    public List<Point2D_I32> process(List<Point2D_I32> contour) {
        FindQuadCorners.findAverage(contour, this.center);
        FindQuadCorners.sortByAngleCCW(this.center, contour);
        this.N = contour.size();
        int radiusLarge = this.N / 10;
        if (radiusLarge < 3) {
            radiusLarge = 3;
        }
        this.acuteAngles.reset();
        this.acuteCorners.reset();
        this.candidates.clear();
        this.acuteAngles.resize(this.N);
        this.computeResponse(contour, radiusLarge, this.acuteAngles.data);
        for (int i = 0; i < this.N; ++i) {
            int indexBefore = UtilCalibrationGrid.incrementCircle(i, -1, this.N);
            int indexAfter = UtilCalibrationGrid.incrementCircle(i, 1, this.N);
            double r = this.acuteAngles.data[i];
            if (!(r <= this.acuteAngles.data[indexBefore]) || !(r <= this.acuteAngles.data[indexAfter])) continue;
            this.candidates.add(contour.get(i));
            this.acuteCorners.add(r);
        }
        this.removeNeighbors(this.candidates);
        int minIndex = -1;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < this.candidates.size(); ++i) {
            double r = this.acuteCorners.get(i);
            if (!(r < minValue)) continue;
            minValue = r;
            minIndex = i;
        }
        if (this.candidates.size() < 4) {
            return this.candidates;
        }
        ArrayList<Point2D_I32> corners = new ArrayList<Point2D_I32>();
        corners.add(this.candidates.remove(minIndex));
        this.selectCorner(corners, this.candidates);
        this.selectCorner(corners, this.candidates);
        this.selectCorner(corners, this.candidates);
        FindQuadCorners.sortByAngleCCW(this.center, corners);
        return corners;
    }

    private void removeNeighbors(List<Point2D_I32> corners) {
        for (int i = 0; i < corners.size(); ++i) {
            Point2D_I32 c = corners.get(i);
            int j = i + 1;
            while (j < corners.size()) {
                Point2D_I32 d = corners.get(j);
                if (Math.abs(d.x - c.x) <= 2 && Math.abs(d.y - c.y) <= 2) {
                    this.acuteCorners.remove(j);
                    corners.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    private void selectCorner(List<Point2D_I32> corners, List<Point2D_I32> candidates) {
        double maxDistance = -1.0;
        int maxIndex = -1;
        for (int i = 0; i < candidates.size(); ++i) {
            Point2D_I32 c = candidates.get(i);
            double d = 0.0;
            for (Point2D_I32 p : corners) {
                d += UtilPoint2D_I32.distance((Point2D_I32)c, (Point2D_I32)p);
            }
            if (!(d > maxDistance)) continue;
            maxDistance = d;
            maxIndex = i;
        }
        corners.add(candidates.remove(maxIndex));
    }

    protected static Point2D_I32 findAverage(List<Point2D_I32> contour, Point2D_I32 ret) {
        if (ret == null) {
            ret = new Point2D_I32();
        }
        int x = 0;
        int y = 0;
        for (int i = 0; i < contour.size(); ++i) {
            Point2D_I32 p = contour.get(i);
            x += p.x;
            y += p.y;
        }
        ret.set(x /= contour.size(), y /= contour.size());
        return ret;
    }

    protected static void sortByAngleCCW(Point2D_I32 center, List<Point2D_I32> contour) {
        double[] angles = new double[contour.size()];
        int[] indexes = new int[angles.length];
        for (int i = 0; i < contour.size(); ++i) {
            Point2D_I32 c = contour.get(i);
            int dx = c.x - center.x;
            int dy = c.y - center.y;
            angles[i] = Math.atan2(dy, dx);
        }
        QuickSort_F64 sort = new QuickSort_F64();
        sort.sort(angles, angles.length, indexes);
        ArrayList<Point2D_I32> sorted = new ArrayList<Point2D_I32>(contour.size());
        for (int i = 0; i < indexes.length; ++i) {
            sorted.add(contour.get(indexes[i]));
        }
        contour.clear();
        contour.addAll(sorted);
    }

    protected void computeResponse(List<Point2D_I32> contour, int radius, double[] response) {
        for (int i = 0; i < this.N; ++i) {
            int i0 = UtilCalibrationGrid.incrementCircle(i, -radius, this.N);
            int i1 = UtilCalibrationGrid.incrementCircle(i, radius, this.N);
            Point2D_I32 p0 = contour.get(i0);
            Point2D_I32 p1 = contour.get(i1);
            Point2D_I32 p = contour.get(i);
            double angle0 = Math.atan2(p0.y - p.y, p0.x - p.x);
            double angle1 = Math.atan2(p1.y - p.y, p1.x - p.x);
            response[i] = UtilAngle.dist((double)angle0, (double)angle1);
        }
    }
}

