/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.HashMap;
import java.util.Map;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.QueryPart;
import org.jooq.QueryPartInternal;

abstract class AbstractContext<C extends Context<C>>
implements Context<C> {
    final Configuration configuration;
    final Map<Object, Object> data;
    boolean declareFields;
    boolean declareTables;
    boolean subquery;
    int index;

    AbstractContext(Configuration configuration) {
        this.configuration = configuration;
        this.data = new HashMap<Object, Object>();
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final Map<Object, Object> data() {
        return this.data;
    }

    @Override
    public final Object data(Object key) {
        return this.data.get(key);
    }

    @Override
    public final Object data(Object key, Object value) {
        return this.data.put(key, value);
    }

    @Override
    public C start(Clause clause) {
        return (C)this;
    }

    @Override
    public C end(Clause clause) {
        return (C)this;
    }

    @Override
    public C visit(QueryPart part) {
        if (part != null) {
            QueryPartInternal internal = (QueryPartInternal)part;
            if (this.declareFields() && !internal.declaresFields()) {
                this.declareFields(false);
                this.visit0(internal);
                this.declareFields(true);
            } else if (this.declareTables() && !internal.declaresTables()) {
                this.declareTables(false);
                this.visit0(internal);
                this.declareTables(true);
            } else {
                this.visit0(internal);
            }
        }
        return (C)this;
    }

    protected abstract void visit0(QueryPartInternal var1);

    @Override
    public final boolean declareFields() {
        return this.declareFields;
    }

    @Override
    public final C declareFields(boolean d) {
        this.declareFields = d;
        return (C)this;
    }

    @Override
    public final boolean declareTables() {
        return this.declareTables;
    }

    @Override
    public final C declareTables(boolean d) {
        this.declareTables = d;
        return (C)this;
    }

    @Override
    public final boolean subquery() {
        return this.subquery;
    }

    @Override
    public final C subquery(boolean s) {
        this.subquery = s;
        return (C)this;
    }

    @Override
    public final int nextIndex() {
        return ++this.index;
    }

    @Override
    public final int peekIndex() {
        return this.index + 1;
    }

    void toString(StringBuilder sb) {
        sb.append("bind index   [");
        sb.append(this.index);
        sb.append("]");
        sb.append("\ndeclaring    [");
        if (this.declareFields) {
            sb.append("fields");
        } else if (this.declareTables) {
            sb.append("tables");
        } else {
            sb.append("-");
        }
        sb.append("]\nsubquery     [");
        sb.append(this.subquery);
        sb.append("]");
    }
}

