/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jooq.AttachableInternal;
import org.jooq.Configuration;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.conf.ParamType;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DetachedException;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.DefaultRenderContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.Utils;
import org.jooq.tools.JooqLogger;

abstract class AbstractQuery
extends AbstractQueryPart
implements Query,
AttachableInternal {
    private static final long serialVersionUID = -8046199737354507547L;
    private static final JooqLogger log = JooqLogger.getLogger(AbstractQuery.class);
    private Configuration configuration;
    private int timeout;
    private boolean keepStatement;
    private transient PreparedStatement statement;
    private transient String sql;

    AbstractQuery(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public final void attach(Configuration c) {
        this.configuration = c;
    }

    @Override
    public final void detach() {
        this.attach(null);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final List<Object> getBindValues() {
        return this.create().extractBindValues(this);
    }

    @Override
    public final Map<String, Param<?>> getParams() {
        return this.create().extractParams(this);
    }

    @Override
    public final Param<?> getParam(String name) {
        return this.create().extractParam(this, name);
    }

    @Override
    public Query bind(String param, Object value) {
        try {
            int index = Integer.valueOf(param);
            return this.bind(index, value);
        }
        catch (NumberFormatException e) {
            Param<?> p = this.getParam(param);
            if (p == null) {
                throw new IllegalArgumentException("No such parameter : " + param);
            }
            p.setConverted(value);
            this.closeIfNecessary(p);
            return this;
        }
    }

    @Override
    public Query bind(int index, Object value) {
        Param[] params = this.getParams().values().toArray(new Param[0]);
        if (index < 1 || index > params.length) {
            throw new IllegalArgumentException("Index out of range for Query parameters : " + index);
        }
        Param param = params[index - 1];
        param.setConverted(value);
        this.closeIfNecessary(param);
        return this;
    }

    private final void closeIfNecessary(Param<?> param) {
        if (this.keepStatement() && this.statement != null) {
            if (param.isInline()) {
                this.close();
            } else if (SettingsTools.getParamType(this.configuration().settings()) == ParamType.INLINED) {
                this.close();
            }
        }
    }

    @Override
    public Query queryTimeout(int t) {
        this.timeout = t;
        return this;
    }

    @Override
    public Query keepStatement(boolean k) {
        this.keepStatement = k;
        return this;
    }

    protected final boolean keepStatement() {
        return this.keepStatement;
    }

    @Override
    public final void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException e) {
                throw Utils.translate(this.sql, e);
            }
        }
    }

    @Override
    public final void cancel() {
        if (this.statement != null) {
            try {
                this.statement.cancel();
            }
            catch (SQLException e) {
                throw Utils.translate(this.sql, e);
            }
        }
    }

    @Override
    public final int execute() {
        if (this.isExecutable()) {
            Configuration c = this.configuration();
            DefaultExecuteContext ctx = new DefaultExecuteContext(c, this);
            ExecuteListeners listener = new ExecuteListeners(ctx);
            int result = 0;
            try {
                if (ctx.connection() == null) {
                    throw new DetachedException("Cannot execute query. No Connection configured");
                }
                if (this.keepStatement() && this.statement != null) {
                    ctx.sql(this.sql);
                    ctx.statement(this.statement);
                } else {
                    listener.renderStart(ctx);
                    ctx.sql(this.getSQL0(ctx));
                    listener.renderEnd(ctx);
                    this.sql = ctx.sql();
                    listener.prepareStart(ctx);
                    this.prepare(ctx);
                    listener.prepareEnd(ctx);
                    this.statement = ctx.statement();
                }
                if (this.timeout != 0) {
                    ctx.statement().setQueryTimeout(this.timeout);
                }
                if (SettingsTools.executePreparedStatements(c.settings()) && !Boolean.TRUE.equals(ctx.data("org.jooq.configuration.force-static-statement"))) {
                    listener.bindStart(ctx);
                    DSL.using(c).bindContext(ctx.statement()).visit(this);
                    listener.bindEnd(ctx);
                }
                int n = result = this.execute(ctx, listener);
                return n;
            }
            catch (SQLException e) {
                ctx.sqlException(e);
                listener.exception(ctx);
                throw ctx.exception();
            }
            finally {
                if (!this.keepResultSet() || ctx.exception() != null) {
                    Utils.safeClose(listener, ctx, this.keepStatement());
                }
                if (!this.keepStatement()) {
                    this.statement = null;
                    this.sql = null;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Query is not executable", this);
        }
        return 0;
    }

    protected boolean keepResultSet() {
        return false;
    }

    protected void prepare(ExecuteContext ctx) throws SQLException {
        ctx.statement(ctx.connection().prepareStatement(ctx.sql()));
    }

    protected int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        int result = 0;
        listener.executeStart(ctx);
        if (!ctx.statement().execute()) {
            result = ctx.statement().getUpdateCount();
            ctx.rows(result);
        }
        listener.executeEnd(ctx);
        return result;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    private final String getSQL0(ExecuteContext ctx) {
        if (SettingsTools.executePreparedStatements(this.configuration().settings())) {
            try {
                DefaultRenderContext render = new DefaultRenderContext(this.configuration);
                render.data("org.jooq.configuration.count-bind-values", true);
                return render.render(this);
            }
            catch (DefaultRenderContext.ForceInlineSignal e) {
                ctx.data("org.jooq.configuration.force-static-statement", true);
                return this.getSQL(ParamType.INLINED);
            }
        }
        return this.getSQL(ParamType.INLINED);
    }

    @Override
    public final String getSQL() {
        return this.getSQL(SettingsTools.getParamType(this.configuration().settings()));
    }

    @Override
    public final String getSQL(ParamType paramType) {
        switch (paramType) {
            case INDEXED: {
                return this.create().render(this);
            }
            case INLINED: {
                return this.create().renderInlined(this);
            }
            case NAMED: {
                return this.create().renderNamedParams(this);
            }
        }
        throw new IllegalArgumentException("ParamType not supported: " + (Object)((Object)paramType));
    }

    @Override
    @Deprecated
    public final String getSQL(boolean inline) {
        return this.getSQL(inline ? ParamType.INLINED : ParamType.INDEXED);
    }
}

