/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.ResultSetMetaData;
import java.util.List;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractResultQuery;
import org.jooq.impl.CombineOperator;
import org.jooq.impl.DSL;
import org.jooq.impl.MetaDataFieldProvider;
import org.jooq.impl.SelectQueryAsField;
import org.jooq.impl.SelectQueryAsTable;
import org.jooq.impl.Union;
import org.jooq.impl.Utils;

abstract class AbstractSelect<R extends Record>
extends AbstractResultQuery<R>
implements Select<R> {
    private static final long serialVersionUID = 5432006637149005588L;

    AbstractSelect(Configuration configuration) {
        super(configuration);
    }

    @Override
    public final int fetchCount() throws DataAccessException {
        return DSL.using(this.configuration()).fetchCount(this);
    }

    @Override
    public final Select<R> union(Select<? extends R> select) {
        return new Union<R>(this.configuration(), this, select, CombineOperator.UNION);
    }

    @Override
    public final Select<R> unionAll(Select<? extends R> select) {
        return new Union<R>(this.configuration(), this, select, CombineOperator.UNION_ALL);
    }

    @Override
    public final Select<R> except(Select<? extends R> select) {
        return new Union<R>(this.configuration(), this, select, CombineOperator.EXCEPT);
    }

    @Override
    public final Select<R> intersect(Select<? extends R> select) {
        return new Union<R>(this.configuration(), this, select, CombineOperator.INTERSECT);
    }

    @Override
    public final <T> Field<T> asField() {
        if (this.getSelect().size() != 1) {
            throw new IllegalStateException("Can only use single-column ResultProviderQuery as a field");
        }
        return new SelectQueryAsField(this, this.getSelect().get(0).getDataType());
    }

    @Override
    public final <T> Field<T> asField(String alias) {
        return this.asField().as(alias);
    }

    @Override
    public final Row fieldsRow() {
        return this.asTable().fieldsRow();
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return this.asTable().field(field);
    }

    @Override
    public final Field<?> field(String string) {
        return this.asTable().field(string);
    }

    @Override
    public final Field<?> field(int index) {
        return this.asTable().field(index);
    }

    @Override
    public final Field<?>[] fields() {
        return this.asTable().fields();
    }

    @Override
    public final Table<R> asTable() {
        return new SelectQueryAsTable(this).as("alias_" + Utils.hash(this));
    }

    @Override
    public final Table<R> asTable(String alias) {
        return new SelectQueryAsTable(this).as(alias);
    }

    @Override
    public final Table<R> asTable(String alias, String ... fieldAliases) {
        return new SelectQueryAsTable(this).as(alias, fieldAliases);
    }

    @Override
    protected final Field<?>[] getFields(ResultSetMetaData meta) {
        List<Field<?>> fields = this.getSelect();
        if (fields.isEmpty()) {
            Configuration configuration = this.configuration();
            return new MetaDataFieldProvider(configuration, meta).getFields();
        }
        return Utils.fieldArray(fields);
    }

    @Override
    final boolean isSelectingRefCursor() {
        for (Field<?> field : this.getSelect()) {
            if (!Result.class.isAssignableFrom(field.getType())) continue;
            return true;
        }
        return false;
    }
}

