/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import org.jooq.BindContext;
import org.jooq.CaseConditionStep;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.impl.AbstractField;
import org.jooq.impl.Utils;

class CaseConditionStepImpl<T>
extends AbstractField<T>
implements CaseConditionStep<T> {
    private static final long serialVersionUID = -1735676153683257465L;
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final List<Field<T>> results = new ArrayList<Field<T>>();
    private Field<T> otherwise;

    CaseConditionStepImpl(Condition condition, Field<T> result) {
        super("case", result.getDataType());
        this.when(condition, result);
    }

    @Override
    public final CaseConditionStep<T> when(Condition condition, T result) {
        return this.when(condition, Utils.field(result));
    }

    @Override
    public final CaseConditionStep<T> when(Condition condition, Field<T> result) {
        this.conditions.add(condition);
        this.results.add(result);
        return this;
    }

    @Override
    public final Field<T> otherwise(T result) {
        return this.otherwise(Utils.field(result));
    }

    @Override
    public final Field<T> otherwise(Field<T> result) {
        this.otherwise = result;
        return this;
    }

    @Override
    public final void bind(BindContext context) {
        for (int i = 0; i < this.conditions.size(); ++i) {
            context.visit(this.conditions.get(i));
            context.visit(this.results.get(i));
        }
        if (this.otherwise != null) {
            context.visit(this.otherwise);
        }
    }

    @Override
    public final void toSQL(RenderContext context) {
        context.formatIndentLockStart().keyword("case").formatIndentLockStart();
        int size = this.conditions.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                context.formatNewLine();
            }
            ((RenderContext)context.sql(" ").keyword("when").sql(" ").visit(this.conditions.get(i))).sql(" ").keyword("then").sql(" ").visit(this.results.get(i));
        }
        if (this.otherwise != null) {
            context.formatNewLine().sql(" ").keyword("else").sql(" ").visit(this.otherwise);
        }
        context.formatIndentLockEnd();
        if (size > 1 || this.otherwise != null) {
            context.formatSeparator();
        } else {
            context.sql(" ");
        }
        context.keyword("end").formatIndentLockEnd();
    }
}

