/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jooq.Cursor;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordHandler;
import org.jooq.RecordMapper;
import org.jooq.RecordType;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.Table;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.RowImpl;
import org.jooq.impl.Utils;
import org.jooq.impl.Value;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.jdbc.JDBC41ResultSet;
import org.jooq.tools.jdbc.JDBCUtils;

class CursorImpl<R extends Record>
implements Cursor<R> {
    private static final JooqLogger log = JooqLogger.getLogger(CursorImpl.class);
    private final ExecuteContext ctx;
    private final ExecuteListener listener;
    private final Field<?>[] fields;
    private final boolean[] intern;
    private final boolean keepResultSet;
    private final boolean keepStatement;
    private final Class<? extends R> type;
    private boolean isClosed;
    private transient CursorResultSet rs;
    private transient Iterator<R> iterator;
    private transient int rows;

    CursorImpl(ExecuteContext ctx, ExecuteListener listener, Field<?>[] fields, int[] internIndexes, boolean keepStatement, boolean keepResultSet) {
        this(ctx, listener, fields, internIndexes, keepStatement, keepResultSet, RecordImpl.class);
    }

    CursorImpl(ExecuteContext ctx, ExecuteListener listener, Field<?>[] fields, int[] internIndexes, boolean keepStatement, boolean keepResultSet, Class<? extends R> type) {
        this.ctx = ctx;
        this.listener = listener != null ? listener : new ExecuteListeners(ctx);
        this.fields = fields;
        this.type = type;
        this.keepStatement = keepStatement;
        this.keepResultSet = keepResultSet;
        this.rs = new CursorResultSet();
        this.intern = new boolean[fields.length];
        if (internIndexes != null) {
            for (int i : internIndexes) {
                this.intern[i] = true;
            }
        }
    }

    @Override
    public final RecordType<R> recordType() {
        return new RowImpl<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>(this.fields).fields;
    }

    @Override
    public final Row fieldsRow() {
        return new RowImpl(this.fields);
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return this.fieldsRow().field(field);
    }

    @Override
    public final Field<?> field(String name) {
        return this.fieldsRow().field(name);
    }

    @Override
    public final Field<?> field(int index) {
        return index >= 0 && index < this.fields.length ? this.fields[index] : null;
    }

    @Override
    public final Field<?>[] fields() {
        return (Field[])this.fields.clone();
    }

    @Override
    public final Iterator<R> iterator() {
        if (this.iterator == null) {
            this.iterator = new CursorIterator();
            this.listener.fetchStart(this.ctx);
        }
        return this.iterator;
    }

    @Override
    public final boolean hasNext() {
        return this.iterator().hasNext();
    }

    @Override
    public final Result<R> fetch() {
        return this.fetch(Integer.MAX_VALUE);
    }

    @Override
    public final R fetchOne() {
        Result<R> result = this.fetch(1);
        if (result.size() == 1) {
            return (R)((Record)result.get(0));
        }
        return null;
    }

    @Override
    public final Result<R> fetch(int number) {
        this.iterator();
        ResultImpl<Record> result = new ResultImpl<Record>(this.ctx.configuration(), this.fields);
        Record record = null;
        this.ctx.result(result);
        this.listener.resultStart(this.ctx);
        for (int i = 0; i < number && (record = (Record)this.iterator().next()) != null; ++i) {
            result.addRecord(record);
        }
        this.ctx.result(result);
        this.listener.resultEnd(this.ctx);
        return result;
    }

    @Override
    public final <H extends RecordHandler<? super R>> H fetchOneInto(H handler) {
        handler.next(this.fetchOne());
        return handler;
    }

    @Override
    public final <H extends RecordHandler<? super R>> H fetchInto(H handler) {
        while (this.hasNext()) {
            this.fetchOneInto(handler);
        }
        return handler;
    }

    @Override
    public final <E> E fetchOne(RecordMapper<? super R, E> mapper) {
        return mapper.map(this.fetchOne());
    }

    @Override
    public final <E> List<E> fetch(RecordMapper<? super R, E> mapper) {
        return this.fetch().map(mapper);
    }

    @Override
    public final <E> E fetchOneInto(Class<? extends E> clazz) {
        R record = this.fetchOne();
        return (E)(record == null ? null : record.into(clazz));
    }

    @Override
    public final <E> List<E> fetchInto(Class<? extends E> clazz) {
        return this.fetch().into(clazz);
    }

    @Override
    public final <Z extends Record> Z fetchOneInto(Table<Z> table) {
        return this.fetchOne().into(table);
    }

    @Override
    public final <Z extends Record> Result<Z> fetchInto(Table<Z> table) {
        return this.fetch().into(table);
    }

    @Override
    public final void close() {
        JDBCUtils.safeClose(this.rs);
        this.rs = null;
        this.isClosed = true;
    }

    @Override
    public final boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public final ResultSet resultSet() {
        return this.rs;
    }

    final class CursorIterator
    implements Iterator<R> {
        private R next;
        private Boolean hasNext;
        private final org.jooq.impl.CursorImpl$CursorIterator.CursorRecordInitialiser initialiser = new CursorRecordInitialiser();

        CursorIterator() {
        }

        @Override
        public final boolean hasNext() {
            if (this.hasNext == null) {
                this.next = this.fetchOne();
                this.hasNext = this.next != null;
            }
            return this.hasNext;
        }

        @Override
        public final R next() {
            if (this.hasNext == null) {
                return this.fetchOne();
            }
            Object result = this.next;
            this.hasNext = null;
            this.next = null;
            return result;
        }

        private final R fetchOne() {
            AbstractRecord record = null;
            try {
                if (!CursorImpl.this.isClosed && CursorImpl.this.rs.next()) {
                    if (Boolean.TRUE.equals(CursorImpl.this.ctx.data("org.jooq.configuration.lock-rows-for-update"))) {
                        CursorImpl.this.rs.updateObject(1, CursorImpl.this.rs.getObject(1));
                        CursorImpl.this.rs.updateRow();
                    }
                    record = (AbstractRecord)Utils.newRecord(CursorImpl.this.type, CursorImpl.this.fields, CursorImpl.this.ctx.configuration()).operate(this.initialiser);
                    CursorImpl.this.rows++;
                }
            }
            catch (SQLException e) {
                CursorImpl.this.ctx.sqlException(e);
                CursorImpl.this.listener.exception(CursorImpl.this.ctx);
                throw CursorImpl.this.ctx.exception();
            }
            if (record == null) {
                CursorImpl.this.close();
            }
            return record;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        private class CursorRecordInitialiser
        implements RecordOperation<AbstractRecord, SQLException> {
            private CursorRecordInitialiser() {
            }

            @Override
            public AbstractRecord operate(AbstractRecord record) throws SQLException {
                CursorImpl.this.ctx.record(record);
                CursorImpl.this.listener.recordStart(CursorImpl.this.ctx);
                for (int i = 0; i < CursorImpl.this.fields.length; ++i) {
                    this.setValue(record, CursorImpl.this.fields[i], i);
                    if (!CursorImpl.this.intern[i]) continue;
                    record.getValue0(i).intern();
                }
                CursorImpl.this.ctx.record(record);
                CursorImpl.this.listener.recordEnd(CursorImpl.this.ctx);
                return record;
            }

            private final <T> void setValue(AbstractRecord record, Field<T> field, int index) throws SQLException {
                T value = Utils.getFromResultSet(CursorImpl.this.ctx, field, index + 1);
                record.setValue(index, new Value<T>(value));
            }
        }
    }

    final class CursorResultSet
    extends JDBC41ResultSet
    implements ResultSet {
        CursorResultSet() {
        }

        @Override
        public final <T> T unwrap(Class<T> iface) throws SQLException {
            return CursorImpl.this.ctx.resultSet().unwrap(iface);
        }

        @Override
        public final boolean isWrapperFor(Class<?> iface) throws SQLException {
            return CursorImpl.this.ctx.resultSet().isWrapperFor(iface);
        }

        @Override
        public final Statement getStatement() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getStatement();
        }

        @Override
        public final SQLWarning getWarnings() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getWarnings();
        }

        @Override
        public final void clearWarnings() throws SQLException {
            CursorImpl.this.ctx.resultSet().clearWarnings();
        }

        @Override
        public final String getCursorName() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getCursorName();
        }

        @Override
        public final ResultSetMetaData getMetaData() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getMetaData();
        }

        @Override
        public final int findColumn(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().findColumn(columnLabel);
        }

        @Override
        public final void setFetchDirection(int direction) throws SQLException {
            CursorImpl.this.ctx.resultSet().setFetchDirection(direction);
        }

        @Override
        public final int getFetchDirection() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getFetchDirection();
        }

        @Override
        public final void setFetchSize(int rows) throws SQLException {
            CursorImpl.this.ctx.resultSet().setFetchSize(rows);
        }

        @Override
        public final int getFetchSize() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getFetchSize();
        }

        @Override
        public final int getType() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getType();
        }

        @Override
        public final int getConcurrency() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getConcurrency();
        }

        @Override
        public final int getHoldability() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getHoldability();
        }

        @Override
        public final boolean isBeforeFirst() throws SQLException {
            return CursorImpl.this.ctx.resultSet().isBeforeFirst();
        }

        @Override
        public final boolean isAfterLast() throws SQLException {
            return CursorImpl.this.ctx.resultSet().isAfterLast();
        }

        @Override
        public final boolean isFirst() throws SQLException {
            return CursorImpl.this.ctx.resultSet().isFirst();
        }

        @Override
        public final boolean isLast() throws SQLException {
            return CursorImpl.this.ctx.resultSet().isLast();
        }

        @Override
        public final boolean next() throws SQLException {
            return CursorImpl.this.ctx.resultSet().next();
        }

        @Override
        public final boolean previous() throws SQLException {
            return CursorImpl.this.ctx.resultSet().previous();
        }

        @Override
        public final void beforeFirst() throws SQLException {
            CursorImpl.this.ctx.resultSet().beforeFirst();
        }

        @Override
        public final void afterLast() throws SQLException {
            CursorImpl.this.ctx.resultSet().afterLast();
        }

        @Override
        public final boolean first() throws SQLException {
            return CursorImpl.this.ctx.resultSet().first();
        }

        @Override
        public final boolean last() throws SQLException {
            return CursorImpl.this.ctx.resultSet().last();
        }

        @Override
        public final int getRow() throws SQLException {
            return CursorImpl.this.ctx.resultSet().getRow();
        }

        @Override
        public final boolean absolute(int row) throws SQLException {
            return CursorImpl.this.ctx.resultSet().absolute(row);
        }

        @Override
        public final boolean relative(int r) throws SQLException {
            return CursorImpl.this.ctx.resultSet().relative(r);
        }

        @Override
        public final void moveToInsertRow() throws SQLException {
            CursorImpl.this.ctx.resultSet().moveToInsertRow();
        }

        @Override
        public final void moveToCurrentRow() throws SQLException {
            CursorImpl.this.ctx.resultSet().moveToCurrentRow();
        }

        @Override
        public final void close() throws SQLException {
            CursorImpl.this.ctx.rows(CursorImpl.this.rows);
            CursorImpl.this.listener.fetchEnd(CursorImpl.this.ctx);
            Utils.safeClose(CursorImpl.this.listener, CursorImpl.this.ctx, CursorImpl.this.keepStatement, CursorImpl.this.keepResultSet);
        }

        @Override
        public final boolean isClosed() throws SQLException {
            return CursorImpl.this.ctx.resultSet().isClosed();
        }

        @Override
        public final boolean wasNull() throws SQLException {
            return CursorImpl.this.ctx.resultSet().wasNull();
        }

        @Override
        public final Array getArray(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getArray(columnIndex);
        }

        @Override
        public final Array getArray(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getArray(columnLabel);
        }

        @Override
        public final InputStream getAsciiStream(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getAsciiStream(columnIndex);
        }

        @Override
        public final InputStream getAsciiStream(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getAsciiStream(columnLabel);
        }

        @Override
        public final BigDecimal getBigDecimal(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBigDecimal(columnIndex);
        }

        @Override
        @Deprecated
        public final BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBigDecimal(columnIndex, scale);
        }

        @Override
        public final BigDecimal getBigDecimal(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBigDecimal(columnLabel);
        }

        @Override
        @Deprecated
        public final BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBigDecimal(columnLabel, scale);
        }

        @Override
        public final InputStream getBinaryStream(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBinaryStream(columnIndex);
        }

        @Override
        public final InputStream getBinaryStream(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBinaryStream(columnLabel);
        }

        @Override
        public final Blob getBlob(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBlob(columnIndex);
        }

        @Override
        public final Blob getBlob(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBlob(columnLabel);
        }

        @Override
        public final boolean getBoolean(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBoolean(columnIndex);
        }

        @Override
        public final boolean getBoolean(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBoolean(columnLabel);
        }

        @Override
        public final byte getByte(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getByte(columnIndex);
        }

        @Override
        public final byte getByte(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getByte(columnLabel);
        }

        @Override
        public final byte[] getBytes(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBytes(columnIndex);
        }

        @Override
        public final byte[] getBytes(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getBytes(columnLabel);
        }

        @Override
        public final Reader getCharacterStream(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getCharacterStream(columnIndex);
        }

        @Override
        public final Reader getCharacterStream(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getCharacterStream(columnLabel);
        }

        @Override
        public final Clob getClob(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getClob(columnIndex);
        }

        @Override
        public final Clob getClob(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getClob(columnLabel);
        }

        @Override
        public final Date getDate(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getDate(columnIndex);
        }

        @Override
        public final Date getDate(int columnIndex, Calendar cal) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getDate(columnIndex, cal);
        }

        @Override
        public final Date getDate(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getDate(columnLabel);
        }

        @Override
        public final Date getDate(String columnLabel, Calendar cal) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getDate(columnLabel, cal);
        }

        @Override
        public final double getDouble(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getDouble(columnIndex);
        }

        @Override
        public final double getDouble(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getDouble(columnLabel);
        }

        @Override
        public final float getFloat(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getFloat(columnIndex);
        }

        @Override
        public final float getFloat(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getFloat(columnLabel);
        }

        @Override
        public final int getInt(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getInt(columnIndex);
        }

        @Override
        public final int getInt(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getInt(columnLabel);
        }

        @Override
        public final long getLong(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getLong(columnIndex);
        }

        @Override
        public final long getLong(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getLong(columnLabel);
        }

        @Override
        public final Reader getNCharacterStream(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getNCharacterStream(columnIndex);
        }

        @Override
        public final Reader getNCharacterStream(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getNCharacterStream(columnLabel);
        }

        @Override
        public final NClob getNClob(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getNClob(columnIndex);
        }

        @Override
        public final NClob getNClob(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getNClob(columnLabel);
        }

        @Override
        public final String getNString(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getNString(columnIndex);
        }

        @Override
        public final String getNString(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getNString(columnLabel);
        }

        @Override
        public final Object getObject(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getObject(columnIndex);
        }

        @Override
        public final Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getObject(columnIndex, map);
        }

        @Override
        public final Object getObject(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getObject(columnLabel);
        }

        @Override
        public final Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getObject(columnLabel, map);
        }

        @Override
        public final Ref getRef(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getRef(columnIndex);
        }

        @Override
        public final Ref getRef(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getRef(columnLabel);
        }

        @Override
        public final RowId getRowId(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getRowId(columnIndex);
        }

        @Override
        public final RowId getRowId(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getRowId(columnLabel);
        }

        @Override
        public final short getShort(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getShort(columnIndex);
        }

        @Override
        public final short getShort(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getShort(columnLabel);
        }

        @Override
        public final SQLXML getSQLXML(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getSQLXML(columnIndex);
        }

        @Override
        public final SQLXML getSQLXML(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getSQLXML(columnLabel);
        }

        @Override
        public final String getString(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getString(columnIndex);
        }

        @Override
        public final String getString(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getString(columnLabel);
        }

        @Override
        public final Time getTime(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getTime(columnIndex);
        }

        @Override
        public final Time getTime(int columnIndex, Calendar cal) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getTime(columnIndex, cal);
        }

        @Override
        public final Time getTime(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getTime(columnLabel);
        }

        @Override
        public final Time getTime(String columnLabel, Calendar cal) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getTime(columnLabel, cal);
        }

        @Override
        public final Timestamp getTimestamp(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getTimestamp(columnIndex);
        }

        @Override
        public final Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getTimestamp(columnIndex, cal);
        }

        @Override
        public final Timestamp getTimestamp(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getTimestamp(columnLabel);
        }

        @Override
        public final Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getTimestamp(columnLabel, cal);
        }

        @Override
        @Deprecated
        public final InputStream getUnicodeStream(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getUnicodeStream(columnIndex);
        }

        @Override
        @Deprecated
        public final InputStream getUnicodeStream(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getUnicodeStream(columnLabel);
        }

        @Override
        public final URL getURL(int columnIndex) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getURL(columnIndex);
        }

        @Override
        public final URL getURL(String columnLabel) throws SQLException {
            return CursorImpl.this.ctx.resultSet().getURL(columnLabel);
        }

        private final void logUpdate(int columnIndex, Object x) throws SQLException {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Updating Result", "Updating Result position " + this.getRow() + ":" + columnIndex + " with value " + x);
            }
        }

        private final void logUpdate(String columnLabel, Object x) throws SQLException {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Updating Result", "Updating Result position " + this.getRow() + ":" + columnLabel + " with value " + x);
            }
        }

        @Override
        public final boolean rowUpdated() throws SQLException {
            return CursorImpl.this.ctx.resultSet().rowUpdated();
        }

        @Override
        public final boolean rowInserted() throws SQLException {
            return CursorImpl.this.ctx.resultSet().rowInserted();
        }

        @Override
        public final boolean rowDeleted() throws SQLException {
            return CursorImpl.this.ctx.resultSet().rowDeleted();
        }

        @Override
        public final void insertRow() throws SQLException {
            CursorImpl.this.ctx.resultSet().insertRow();
        }

        @Override
        public final void updateRow() throws SQLException {
            CursorImpl.this.ctx.resultSet().updateRow();
        }

        @Override
        public final void deleteRow() throws SQLException {
            CursorImpl.this.ctx.resultSet().deleteRow();
        }

        @Override
        public final void refreshRow() throws SQLException {
            CursorImpl.this.ctx.resultSet().refreshRow();
        }

        @Override
        public final void cancelRowUpdates() throws SQLException {
            CursorImpl.this.ctx.resultSet().cancelRowUpdates();
        }

        @Override
        public final void updateNull(int columnIndex) throws SQLException {
            this.logUpdate(columnIndex, null);
            CursorImpl.this.ctx.resultSet().updateNull(columnIndex);
        }

        @Override
        public final void updateNull(String columnLabel) throws SQLException {
            this.logUpdate(columnLabel, null);
            CursorImpl.this.ctx.resultSet().updateNull(columnLabel);
        }

        @Override
        public final void updateArray(int columnIndex, Array x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateArray(columnIndex, x);
        }

        @Override
        public final void updateArray(String columnLabel, Array x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateArray(columnLabel, x);
        }

        @Override
        public final void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateAsciiStream(columnIndex, x);
        }

        @Override
        public final void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateAsciiStream(columnIndex, x, length);
        }

        @Override
        public final void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateAsciiStream(columnIndex, x, length);
        }

        @Override
        public final void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateAsciiStream(columnLabel, x);
        }

        @Override
        public final void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateAsciiStream(columnLabel, x, length);
        }

        @Override
        public final void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateAsciiStream(columnLabel, x, length);
        }

        @Override
        public final void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBigDecimal(columnIndex, x);
        }

        @Override
        public final void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBigDecimal(columnLabel, x);
        }

        @Override
        public final void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBinaryStream(columnIndex, x);
        }

        @Override
        public final void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBinaryStream(columnIndex, x, length);
        }

        @Override
        public final void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBinaryStream(columnIndex, x, length);
        }

        @Override
        public final void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBinaryStream(columnLabel, x);
        }

        @Override
        public final void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBinaryStream(columnLabel, x, length);
        }

        @Override
        public final void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBinaryStream(columnLabel, x, length);
        }

        @Override
        public final void updateBlob(int columnIndex, Blob x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBlob(columnIndex, x);
        }

        @Override
        public final void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBlob(columnIndex, x, length);
        }

        @Override
        public final void updateBlob(String columnLabel, Blob x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBlob(columnLabel, x);
        }

        @Override
        public final void updateBlob(int columnIndex, InputStream x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBlob(columnIndex, x);
        }

        @Override
        public final void updateBlob(String columnLabel, InputStream x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBlob(columnLabel, x);
        }

        @Override
        public final void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBlob(columnLabel, x, length);
        }

        @Override
        public final void updateBoolean(int columnIndex, boolean x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBoolean(columnIndex, x);
        }

        @Override
        public final void updateBoolean(String columnLabel, boolean x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBoolean(columnLabel, x);
        }

        @Override
        public final void updateByte(int columnIndex, byte x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateByte(columnIndex, x);
        }

        @Override
        public final void updateByte(String columnLabel, byte x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateByte(columnLabel, x);
        }

        @Override
        public final void updateBytes(int columnIndex, byte[] x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBytes(columnIndex, x);
        }

        @Override
        public final void updateBytes(String columnLabel, byte[] x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateBytes(columnLabel, x);
        }

        @Override
        public final void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateCharacterStream(columnIndex, x);
        }

        @Override
        public final void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateCharacterStream(columnIndex, x, length);
        }

        @Override
        public final void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateCharacterStream(columnIndex, x, length);
        }

        @Override
        public final void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateCharacterStream(columnLabel, x);
        }

        @Override
        public final void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateCharacterStream(columnLabel, x, length);
        }

        @Override
        public final void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateCharacterStream(columnLabel, x, length);
        }

        @Override
        public final void updateClob(int columnIndex, Clob x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateClob(columnIndex, x);
        }

        @Override
        public final void updateClob(int columnIndex, Reader x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateClob(columnIndex, x);
        }

        @Override
        public final void updateClob(int columnIndex, Reader x, long length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateClob(columnIndex, x, length);
        }

        @Override
        public final void updateClob(String columnLabel, Clob x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateClob(columnLabel, x);
        }

        @Override
        public final void updateClob(String columnLabel, Reader x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateClob(columnLabel, x);
        }

        @Override
        public final void updateClob(String columnLabel, Reader x, long length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateClob(columnLabel, x, length);
        }

        @Override
        public final void updateDate(int columnIndex, Date x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateDate(columnIndex, x);
        }

        @Override
        public final void updateDate(String columnLabel, Date x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateDate(columnLabel, x);
        }

        @Override
        public final void updateDouble(int columnIndex, double x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateDouble(columnIndex, x);
        }

        @Override
        public final void updateDouble(String columnLabel, double x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateDouble(columnLabel, x);
        }

        @Override
        public final void updateFloat(int columnIndex, float x) throws SQLException {
            this.logUpdate(columnIndex, (Object)Float.valueOf(x));
            CursorImpl.this.ctx.resultSet().updateFloat(columnIndex, x);
        }

        @Override
        public final void updateFloat(String columnLabel, float x) throws SQLException {
            this.logUpdate(columnLabel, (Object)Float.valueOf(x));
            CursorImpl.this.ctx.resultSet().updateFloat(columnLabel, x);
        }

        @Override
        public final void updateInt(int columnIndex, int x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateInt(columnIndex, x);
        }

        @Override
        public final void updateInt(String columnLabel, int x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateInt(columnLabel, x);
        }

        @Override
        public final void updateLong(int columnIndex, long x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateLong(columnIndex, x);
        }

        @Override
        public final void updateLong(String columnLabel, long x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateLong(columnLabel, x);
        }

        @Override
        public final void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNCharacterStream(columnIndex, x);
        }

        @Override
        public final void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNCharacterStream(columnIndex, x, length);
        }

        @Override
        public final void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNCharacterStream(columnLabel, x);
        }

        @Override
        public final void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNCharacterStream(columnLabel, x, length);
        }

        @Override
        public final void updateNClob(int columnIndex, NClob x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNClob(columnIndex, x);
        }

        @Override
        public final void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNClob(columnIndex, x, length);
        }

        @Override
        public final void updateNClob(int columnIndex, Reader x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNClob(columnIndex, x);
        }

        @Override
        public final void updateNClob(String columnLabel, NClob x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNClob(columnLabel, x);
        }

        @Override
        public final void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNClob(columnLabel, x, length);
        }

        @Override
        public final void updateNClob(String columnLabel, Reader x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNClob(columnLabel, x);
        }

        @Override
        public final void updateNString(int columnIndex, String x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNString(columnIndex, x);
        }

        @Override
        public final void updateNString(String columnLabel, String x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateNString(columnLabel, x);
        }

        @Override
        public final void updateObject(int columnIndex, Object x) throws SQLException {
            this.logUpdate(columnIndex, x);
            CursorImpl.this.ctx.resultSet().updateObject(columnIndex, x);
        }

        @Override
        public final void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
            this.logUpdate(columnIndex, x);
            CursorImpl.this.ctx.resultSet().updateObject(columnIndex, x, scaleOrLength);
        }

        @Override
        public final void updateObject(String columnLabel, Object x) throws SQLException {
            this.logUpdate(columnLabel, x);
            CursorImpl.this.ctx.resultSet().updateObject(columnLabel, x);
        }

        @Override
        public final void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
            this.logUpdate(columnLabel, x);
            CursorImpl.this.ctx.resultSet().updateObject(columnLabel, x, scaleOrLength);
        }

        @Override
        public final void updateRef(int columnIndex, Ref x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateRef(columnIndex, x);
        }

        @Override
        public final void updateRef(String columnLabel, Ref x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateRef(columnLabel, x);
        }

        @Override
        public final void updateRowId(int columnIndex, RowId x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateRowId(columnIndex, x);
        }

        @Override
        public final void updateRowId(String columnLabel, RowId x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateRowId(columnLabel, x);
        }

        @Override
        public final void updateShort(int columnIndex, short x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateShort(columnIndex, x);
        }

        @Override
        public final void updateShort(String columnLabel, short x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateShort(columnLabel, x);
        }

        @Override
        public final void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateSQLXML(columnIndex, x);
        }

        @Override
        public final void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateSQLXML(columnLabel, x);
        }

        @Override
        public final void updateString(int columnIndex, String x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateString(columnIndex, x);
        }

        @Override
        public final void updateString(String columnLabel, String x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateString(columnLabel, x);
        }

        @Override
        public final void updateTime(int columnIndex, Time x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateTime(columnIndex, x);
        }

        @Override
        public final void updateTime(String columnLabel, Time x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateTime(columnLabel, x);
        }

        @Override
        public final void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
            this.logUpdate(columnIndex, (Object)x);
            CursorImpl.this.ctx.resultSet().updateTimestamp(columnIndex, x);
        }

        @Override
        public final void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
            this.logUpdate(columnLabel, (Object)x);
            CursorImpl.this.ctx.resultSet().updateTimestamp(columnLabel, x);
        }
    }
}

