/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DAO;
import org.jooq.Field;
import org.jooq.RecordMapper;
import org.jooq.Table;
import org.jooq.UniqueKey;
import org.jooq.UpdatableRecord;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DSL;
import org.jooq.impl.Utils;

public abstract class DAOImpl<R extends UpdatableRecord<R>, P, T>
implements DAO<R, P, T> {
    private final Table<R> table;
    private final Class<P> type;
    private RecordMapper<R, P> mapper;
    private Configuration configuration;

    protected DAOImpl(Table<R> table, Class<P> type) {
        this(table, type, null);
    }

    protected DAOImpl(Table<R> table, Class<P> type, Configuration configuration) {
        this.table = table;
        this.type = type;
        this.setConfiguration(configuration);
    }

    public final void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        this.mapper = Utils.configuration(configuration).recordMapperProvider().provide(this.table.recordType(), this.type);
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public RecordMapper<R, P> mapper() {
        return this.mapper;
    }

    @Override
    public final void insert(P object) {
        this.insert((Collection<P>)Collections.singletonList(object));
    }

    @Override
    public final void insert(P ... objects) {
        this.insert((Collection<P>)Arrays.asList(objects));
    }

    @Override
    public final void insert(Collection<P> objects) {
        if (objects.size() > 1) {
            DSL.using(this.configuration).batchInsert(this.records(objects, false)).execute();
        } else if (objects.size() == 1) {
            ((UpdatableRecord)this.records(objects, false).get(0)).insert();
        }
    }

    @Override
    public final void update(P object) {
        this.update((Collection<P>)Collections.singletonList(object));
    }

    @Override
    public final void update(P ... objects) {
        this.update((Collection<P>)Arrays.asList(objects));
    }

    @Override
    public final void update(Collection<P> objects) {
        if (objects.size() > 1) {
            DSL.using(this.configuration).batchUpdate(this.records(objects, true)).execute();
        } else if (objects.size() == 1) {
            ((UpdatableRecord)this.records(objects, true).get(0)).update();
        }
    }

    @Override
    public final void delete(P ... objects) {
        this.delete((Collection<P>)Arrays.asList(objects));
    }

    @Override
    public final void delete(Collection<P> objects) {
        ArrayList<T> ids = new ArrayList<T>();
        for (P object : objects) {
            ids.add(this.getId(object));
        }
        this.deleteById((Collection<T>)ids);
    }

    @Override
    public final void deleteById(T ... ids) {
        this.deleteById((Collection<T>)Arrays.asList(ids));
    }

    @Override
    public final void deleteById(Collection<T> ids) {
        Field<?> pk = this.pk();
        if (pk != null) {
            DSL.using(this.configuration).delete(this.table).where(this.equal(pk, ids)).execute();
        }
    }

    @Override
    public final boolean exists(P object) {
        return this.existsById(this.getId(object));
    }

    @Override
    public final boolean existsById(T id) {
        Field<?> pk = this.pk();
        if (pk != null) {
            return DSL.using(this.configuration).selectCount().from(this.table).where(this.equal(pk, id)).fetchOne(0, Integer.class) > 0;
        }
        return false;
    }

    @Override
    public final long count() {
        return DSL.using(this.configuration).selectCount().from(this.table).fetchOne(0, Long.class);
    }

    @Override
    public final List<P> findAll() {
        return DSL.using(this.configuration).selectFrom(this.table).fetch().map(this.mapper());
    }

    @Override
    public final P findById(T id) {
        Field<?> pk = this.pk();
        UpdatableRecord record = null;
        if (pk != null) {
            record = (UpdatableRecord)DSL.using(this.configuration).selectFrom(this.table).where(this.equal(pk, id)).fetchOne();
        }
        return this.mapper().map(record);
    }

    @Override
    public final <Z> List<P> fetch(Field<Z> field, Z ... values) {
        return DSL.using(this.configuration).selectFrom(this.table).where(field.in(values)).fetch().map(this.mapper());
    }

    @Override
    public final <Z> P fetchOne(Field<Z> field, Z value) {
        UpdatableRecord record = (UpdatableRecord)DSL.using(this.configuration).selectFrom(this.table).where(field.equal(value)).fetchOne();
        return this.mapper().map(record);
    }

    @Override
    public final Table<R> getTable() {
        return this.table;
    }

    @Override
    public final Class<P> getType() {
        return this.type;
    }

    protected abstract T getId(P var1);

    private final <U> Condition equal(Field<U> pk, T id) {
        return pk.equal(pk.getDataType().convert((Object)id));
    }

    private final <U> Condition equal(Field<U> pk, Collection<T> ids) {
        if (ids.size() == 1) {
            return this.equal(pk, ids.iterator().next());
        }
        return pk.in((Collection<U>)pk.getDataType().convert(ids));
    }

    private final Field<?> pk() {
        UniqueKey<R> key = this.table.getPrimaryKey();
        if (key != null && key.getFields().size() == 1) {
            return key.getFields().get(0);
        }
        return null;
    }

    private final List<R> records(Collection<P> objects, boolean forUpdate) {
        ArrayList<UpdatableRecord> result = new ArrayList<UpdatableRecord>();
        Field<?> pk = this.pk();
        for (P object : objects) {
            UpdatableRecord record = (UpdatableRecord)DSL.using(this.configuration).newRecord(this.table, object);
            if (forUpdate && pk != null) {
                ((AbstractRecord)((Object)record)).getValue0(pk).setChanged(false);
            }
            result.add(record);
        }
        return result;
    }
}

