/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jooq.Converter;
import org.jooq.exception.DataTypeException;

final class DataTypes {
    private static final Map<Class<?>, Converter<?, ?>> CONVERTERS = new HashMap();
    private static final Map<String, Class<?>> UDT_RECORDS = new HashMap();

    static final synchronized <U> void registerConverter(Class<U> customType, Class<? extends Converter<?, U>> converter) {
        try {
            converter.getConstructor(new Class[0]).setAccessible(true);
            DataTypes.registerConverter(customType, converter.newInstance());
        }
        catch (Exception e) {
            throw new DataTypeException("Cannot register converter", e);
        }
    }

    static final synchronized <U> void registerConverter(Class<U> customType, Converter<?, U> converter) {
        if (!CONVERTERS.containsKey(customType)) {
            CONVERTERS.put(customType, converter);
        }
    }

    static final synchronized void registerUDTRecord(String name, Class<?> type) {
        if (!UDT_RECORDS.containsKey(name)) {
            UDT_RECORDS.put(name, type);
        }
    }

    static final <U> Converter<?, U> converter(Class<U> customType) {
        return CONVERTERS.get(customType);
    }

    static final Map<String, Class<?>> udtRecords() {
        return Collections.unmodifiableMap(UDT_RECORDS);
    }

    private DataTypes() {
    }
}

