/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXB;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.ExecuteListenerProvider;
import org.jooq.RecordListenerProvider;
import org.jooq.RecordMapperProvider;
import org.jooq.SQLDialect;
import org.jooq.SchemaMapping;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.impl.DefaultRecordMapperProvider;
import org.jooq.impl.NoConnectionProvider;

public class DefaultConfiguration
implements Configuration {
    private static final long serialVersionUID = 8193158984283234708L;
    private SQLDialect dialect;
    private Settings settings;
    private ConcurrentHashMap<Object, Object> data;
    private transient ConnectionProvider connectionProvider;
    private transient RecordMapperProvider recordMapperProvider;
    private transient RecordListenerProvider[] recordListenerProviders;
    private transient ExecuteListenerProvider[] executeListenerProviders;
    private transient VisitListenerProvider[] visitListenerProviders;
    private SchemaMapping mapping;

    public DefaultConfiguration() {
        this(SQLDialect.SQL99);
    }

    DefaultConfiguration(SQLDialect dialect) {
        this(new NoConnectionProvider(), new DefaultRecordMapperProvider(), new RecordListenerProvider[0], new ExecuteListenerProvider[0], new VisitListenerProvider[0], dialect, SettingsTools.defaultSettings(), null);
    }

    DefaultConfiguration(Configuration configuration) {
        this(configuration.connectionProvider(), configuration.recordMapperProvider(), configuration.recordListenerProviders(), configuration.executeListenerProviders(), configuration.visitListenerProviders(), configuration.dialect(), configuration.settings(), configuration.data());
    }

    DefaultConfiguration(ConnectionProvider connectionProvider, RecordMapperProvider recordMapperProvider, RecordListenerProvider[] recordListenerProviders, ExecuteListenerProvider[] executeListenerProviders, VisitListenerProvider[] visitListenerProviders, SQLDialect dialect, Settings settings, Map<Object, Object> data) {
        this.set(connectionProvider);
        this.set(recordMapperProvider);
        this.set(recordListenerProviders);
        this.set(executeListenerProviders);
        this.set(visitListenerProviders);
        this.set(dialect);
        this.set(settings);
        this.data = data != null ? new ConcurrentHashMap<Object, Object>(data) : new ConcurrentHashMap();
    }

    @Override
    public final Configuration derive() {
        return new DefaultConfiguration(this);
    }

    @Override
    public final Configuration derive(ConnectionProvider newConnectionProvider) {
        return new DefaultConfiguration(newConnectionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(RecordMapperProvider newRecordMapperProvider) {
        return new DefaultConfiguration(this.connectionProvider, newRecordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(RecordListenerProvider ... newRecordListenerProviders) {
        return new DefaultConfiguration(this.connectionProvider, this.recordMapperProvider, newRecordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(ExecuteListenerProvider ... newExecuteListenerProviders) {
        return new DefaultConfiguration(this.connectionProvider, this.recordMapperProvider, this.recordListenerProviders, newExecuteListenerProviders, this.visitListenerProviders, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(VisitListenerProvider ... newVisitListenerProviders) {
        return new DefaultConfiguration(this.connectionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, newVisitListenerProviders, this.dialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(SQLDialect newDialect) {
        return new DefaultConfiguration(this.connectionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, newDialect, this.settings, this.data);
    }

    @Override
    public final Configuration derive(Settings newSettings) {
        return new DefaultConfiguration(this.connectionProvider, this.recordMapperProvider, this.recordListenerProviders, this.executeListenerProviders, this.visitListenerProviders, this.dialect, newSettings, this.data);
    }

    @Override
    public final Configuration set(ConnectionProvider newConnectionProvider) {
        this.connectionProvider = newConnectionProvider;
        return this;
    }

    @Override
    public final Configuration set(RecordMapperProvider newRecordMapperProvider) {
        this.recordMapperProvider = newRecordMapperProvider != null ? newRecordMapperProvider : new DefaultRecordMapperProvider();
        return this;
    }

    @Override
    public final Configuration set(RecordListenerProvider ... newRecordListenerProviders) {
        this.recordListenerProviders = newRecordListenerProviders != null ? newRecordListenerProviders : new RecordListenerProvider[]{};
        return this;
    }

    @Override
    public final Configuration set(ExecuteListenerProvider ... newExecuteListenerProviders) {
        this.executeListenerProviders = newExecuteListenerProviders != null ? newExecuteListenerProviders : new ExecuteListenerProvider[]{};
        return this;
    }

    @Override
    public final Configuration set(VisitListenerProvider ... newVisitListenerProviders) {
        this.visitListenerProviders = newVisitListenerProviders != null ? newVisitListenerProviders : new VisitListenerProvider[]{};
        return this;
    }

    @Override
    public final Configuration set(SQLDialect newDialect) {
        this.dialect = newDialect;
        return this;
    }

    @Override
    public final Configuration set(Settings newSettings) {
        this.settings = newSettings != null ? SettingsTools.clone(newSettings) : SettingsTools.defaultSettings();
        this.mapping = new SchemaMapping(this);
        return this;
    }

    @Override
    public final ConnectionProvider connectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public final RecordMapperProvider recordMapperProvider() {
        return this.recordMapperProvider;
    }

    @Override
    public final RecordListenerProvider[] recordListenerProviders() {
        return this.recordListenerProviders;
    }

    @Override
    public final ExecuteListenerProvider[] executeListenerProviders() {
        return this.executeListenerProviders;
    }

    @Override
    public final VisitListenerProvider[] visitListenerProviders() {
        return this.visitListenerProviders;
    }

    @Override
    public final SQLDialect dialect() {
        return this.dialect;
    }

    @Override
    public final Settings settings() {
        return this.settings;
    }

    public final ConcurrentHashMap<Object, Object> data() {
        return this.data;
    }

    @Override
    public final Object data(Object key) {
        return this.data.get(key);
    }

    @Override
    public final Object data(Object key, Object value) {
        return this.data.put(key, value);
    }

    @Override
    @Deprecated
    public final SchemaMapping schemaMapping() {
        return this.mapping;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this.settings, (Writer)writer);
        return "DefaultConfiguration [\n\tconnected=" + (this.connectionProvider != null && !(this.connectionProvider instanceof NoConnectionProvider)) + ",\n\tdialect=" + (Object)((Object)this.dialect) + ",\n\tdata=" + this.data + ",\n\tsettings=\n\t\t" + writer.toString().trim().replace("\n", "\n\t\t") + "\n]";
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.connectionProvider instanceof Serializable ? this.connectionProvider : null);
        oos.writeObject(this.recordMapperProvider instanceof Serializable ? this.recordMapperProvider : null);
        oos.writeObject(this.cloneSerializables(this.executeListenerProviders));
        oos.writeObject(this.cloneSerializables(this.recordListenerProviders));
        oos.writeObject(this.cloneSerializables(this.visitListenerProviders));
    }

    private <E> E[] cloneSerializables(E[] array) {
        Object[] clone = (Object[])array.clone();
        for (int i = 0; i < clone.length; ++i) {
            if (clone[i] instanceof Serializable) continue;
            clone[i] = null;
        }
        return clone;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.connectionProvider = (ConnectionProvider)ois.readObject();
        this.recordMapperProvider = (RecordMapperProvider)ois.readObject();
        this.executeListenerProviders = (ExecuteListenerProvider[])ois.readObject();
        this.recordListenerProviders = (RecordListenerProvider[])ois.readObject();
        this.visitListenerProviders = (VisitListenerProvider[])ois.readObject();
    }
}

