/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.JoinType;
import org.jooq.Operator;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.TableOptionalOnStep;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Utils;

class JoinTable
extends AbstractTable<Record>
implements TableOptionalOnStep,
TableOnConditionStep {
    private static final long serialVersionUID = 8377996833996498178L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TABLE, Clause.TABLE_JOIN};
    private final Table<?> lhs;
    private final Table<?> rhs;
    private final QueryPartList<Field<?>> rhsPartitionBy;
    private final JoinType type;
    private final ConditionProviderImpl condition;
    private final QueryPartList<Field<?>> using;

    JoinTable(TableLike<?> lhs, TableLike<?> rhs, JoinType type) {
        super("join");
        this.lhs = lhs.asTable();
        this.rhs = rhs.asTable();
        this.rhsPartitionBy = new QueryPartList();
        this.type = type;
        this.condition = new ConditionProviderImpl();
        this.using = new QueryPartList();
    }

    @Override
    public final List<ForeignKey<Record, ?>> getReferences() {
        ArrayList result = new ArrayList();
        result.addAll(this.lhs.getReferences());
        result.addAll(this.rhs.getReferences());
        return result;
    }

    @Override
    public final void toSQL(RenderContext context) {
        JoinType translatedType = this.translateType(context);
        Clause translatedClause = this.translateClause(translatedType);
        ((RenderContext)((RenderContext)context.visit(this.lhs)).formatIndentStart().formatSeparator().start(translatedClause)).keyword(translatedType.toSQL()).sql(" ");
        if (this.rhs instanceof JoinTable) {
            context.sql("(").formatIndentStart().formatNewLine();
        }
        context.visit(this.rhs);
        if (this.rhs instanceof JoinTable) {
            context.formatIndentEnd().formatNewLine().sql(")");
        }
        if (!this.rhsPartitionBy.isEmpty()) {
            ((RenderContext)((RenderContext)context.formatSeparator().start(Clause.TABLE_JOIN_PARTITION_BY)).keyword("partition by").sql(" (").visit(this.rhsPartitionBy)).sql(")").end(Clause.TABLE_JOIN_PARTITION_BY);
        }
        if (!Arrays.asList(JoinType.CROSS_JOIN, JoinType.NATURAL_JOIN, JoinType.NATURAL_LEFT_OUTER_JOIN, JoinType.NATURAL_RIGHT_OUTER_JOIN).contains((Object)translatedType)) {
            this.toSQLJoinCondition(context);
        }
        ((RenderContext)context.end(translatedClause)).formatIndentEnd();
    }

    final Clause translateClause(JoinType translatedType) {
        switch (translatedType) {
            case JOIN: {
                return Clause.TABLE_JOIN_INNER;
            }
            case CROSS_JOIN: {
                return Clause.TABLE_JOIN_CROSS;
            }
            case NATURAL_JOIN: {
                return Clause.TABLE_JOIN_NATURAL;
            }
            case LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_LEFT;
            }
            case RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_RIGHT;
            }
            case FULL_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_FULL;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_LEFT;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_RIGHT;
            }
        }
        throw new IllegalArgumentException("Bad join type: " + (Object)((Object)translatedType));
    }

    final JoinType translateType(RenderContext context) {
        if (this.simulateCrossJoin(context)) {
            return JoinType.JOIN;
        }
        if (this.simulateNaturalJoin(context)) {
            return JoinType.JOIN;
        }
        if (this.simulateNaturalLeftOuterJoin(context)) {
            return JoinType.LEFT_OUTER_JOIN;
        }
        if (this.simulateNaturalRightOuterJoin(context)) {
            return JoinType.RIGHT_OUTER_JOIN;
        }
        return this.type;
    }

    private final boolean simulateCrossJoin(RenderContext context) {
        return false;
    }

    private final boolean simulateNaturalJoin(RenderContext context) {
        return this.type == JoinType.NATURAL_JOIN && Arrays.asList(SQLDialect.CUBRID).contains((Object)context.configuration().dialect().family());
    }

    private final boolean simulateNaturalLeftOuterJoin(RenderContext context) {
        return this.type == JoinType.NATURAL_LEFT_OUTER_JOIN && Arrays.asList(SQLDialect.CUBRID, SQLDialect.H2).contains((Object)context.configuration().dialect().family());
    }

    private final boolean simulateNaturalRightOuterJoin(RenderContext context) {
        return this.type == JoinType.NATURAL_RIGHT_OUTER_JOIN && Arrays.asList(SQLDialect.CUBRID, SQLDialect.H2).contains((Object)context.configuration().dialect().family());
    }

    private final void toSQLJoinCondition(RenderContext context) {
        if (!this.using.isEmpty()) {
            if (Arrays.asList(SQLDialect.CUBRID, SQLDialect.H2).contains((Object)context.configuration().dialect().family())) {
                boolean first = true;
                for (Field<?> field : this.using) {
                    context.formatSeparator();
                    if (first) {
                        first = false;
                        ((RenderContext)context.start(Clause.TABLE_JOIN_ON)).keyword("on");
                    } else {
                        context.keyword("and");
                    }
                    ((RenderContext)context.sql(" ").visit(this.lhs.field(field))).sql(" = ").visit(this.rhs.field(field));
                }
                context.end(Clause.TABLE_JOIN_ON);
            } else {
                ((RenderContext)context.formatSeparator().start(Clause.TABLE_JOIN_USING)).keyword("using").sql("( ");
                Utils.fieldNames(context, this.using);
                context.sql(")").end(Clause.TABLE_JOIN_USING);
            }
        } else if (this.simulateNaturalJoin(context) || this.simulateNaturalLeftOuterJoin(context) || this.simulateNaturalRightOuterJoin(context)) {
            boolean first = true;
            for (Field<?> field : this.lhs.fields()) {
                Field<?> other = this.rhs.field(field);
                if (other == null) continue;
                context.formatSeparator();
                if (first) {
                    first = false;
                    ((RenderContext)context.start(Clause.TABLE_JOIN_ON)).keyword("on");
                } else {
                    context.keyword("and");
                }
                ((RenderContext)context.sql(" ").visit(field)).sql(" = ").visit(other);
            }
            context.end(Clause.TABLE_JOIN_ON);
        } else {
            ((RenderContext)((RenderContext)context.formatSeparator().start(Clause.TABLE_JOIN_ON)).keyword("on").sql(" ").visit(this.condition)).end(Clause.TABLE_JOIN_ON);
        }
    }

    @Override
    public final void bind(BindContext context) throws DataAccessException {
        ((BindContext)((BindContext)context.visit(this.lhs)).visit(this.rhs)).visit(this.rhsPartitionBy);
        if (!this.using.isEmpty()) {
            context.visit(this.using);
        } else {
            context.visit(this.condition);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<Record> as(String alias) {
        return new TableAlias<Record>(this, alias, true);
    }

    @Override
    public final Table<Record> as(String alias, String ... fieldAliases) {
        return new TableAlias<Record>(this, alias, fieldAliases, true);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    final Fields<Record> fields0() {
        Field<?>[] l = this.lhs.asTable().fields();
        Field<?>[] r = this.rhs.asTable().fields();
        Field[] all = new Field[l.length + r.length];
        System.arraycopy(l, 0, all, 0, l.length);
        System.arraycopy(r, 0, all, l.length, r.length);
        return new Fields<Record>(all);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final JoinTable on(Condition ... conditions) {
        this.condition.addConditions(conditions);
        return this;
    }

    @Override
    public final JoinTable on(Field<Boolean> c) {
        return this.on(DSL.condition(c));
    }

    @Override
    public final JoinTable on(String sql) {
        this.and(sql);
        return this;
    }

    @Override
    public final JoinTable on(String sql, Object ... bindings) {
        this.and(sql, bindings);
        return this;
    }

    @Override
    public final JoinTable on(String sql, QueryPart ... parts) {
        this.and(sql, parts);
        return this;
    }

    @Override
    public final JoinTable onKey() throws DataAccessException {
        List<ForeignKey<?, ?>> leftToRight = this.lhs.getReferencesTo(this.rhs);
        List<ForeignKey<?, ?>> rightToLeft = this.rhs.getReferencesTo(this.lhs);
        if (leftToRight.size() == 1 && rightToLeft.size() == 0) {
            return this.onKey((ForeignKey)leftToRight.get(0));
        }
        if (rightToLeft.size() == 1 && leftToRight.size() == 0) {
            return this.onKey((ForeignKey)rightToLeft.get(0));
        }
        throw this.onKeyException();
    }

    @Override
    public final JoinTable onKey(TableField<?, ?> ... keyFields) throws DataAccessException {
        block2: {
            block3: {
                if (keyFields == null || keyFields.length <= 0) break block2;
                if (!keyFields[0].getTable().equals(this.lhs)) break block3;
                for (ForeignKey<?, ?> key : this.lhs.getReferences()) {
                    if (!key.getFields().containsAll(Arrays.asList(keyFields))) continue;
                    return this.onKey((ForeignKey)key);
                }
                break block2;
            }
            if (!keyFields[0].getTable().equals(this.rhs)) break block2;
            for (ForeignKey<?, ?> key : this.rhs.getReferences()) {
                if (!key.getFields().containsAll(Arrays.asList(keyFields))) continue;
                return this.onKey((ForeignKey)key);
            }
        }
        throw this.onKeyException();
    }

    @Override
    public final JoinTable onKey(ForeignKey<?, ?> key) {
        JoinTable result = this;
        TableField<R, ?>[] references = key.getFieldsArray();
        TableField<R, ?>[] referenced = key.getKey().getFieldsArray();
        for (int i = 0; i < references.length; ++i) {
            result.and(references[i].equal(referenced[i]));
        }
        return result;
    }

    private final DataAccessException onKeyException() {
        return new DataAccessException("Key ambiguous between tables " + this.lhs + " and " + this.rhs);
    }

    public final JoinTable using(Field<?> ... fields) {
        return this.using(Arrays.asList(fields));
    }

    public final JoinTable using(Collection<? extends Field<?>> fields) {
        this.using.addAll((Collection<Field<?>>)fields);
        return this;
    }

    @Override
    public final JoinTable and(Condition c) {
        this.condition.addConditions(c);
        return this;
    }

    @Override
    public final JoinTable and(Field<Boolean> c) {
        return this.and(DSL.condition(c));
    }

    @Override
    public final JoinTable and(String sql) {
        return this.and(DSL.condition(sql));
    }

    @Override
    public final JoinTable and(String sql, Object ... bindings) {
        return this.and(DSL.condition(sql, bindings));
    }

    @Override
    public final JoinTable and(String sql, QueryPart ... parts) {
        return this.and(DSL.condition(sql, parts));
    }

    @Override
    public final JoinTable andNot(Condition c) {
        return this.and(c.not());
    }

    @Override
    public final JoinTable andNot(Field<Boolean> c) {
        return this.andNot(DSL.condition(c));
    }

    @Override
    public final JoinTable andExists(Select<?> select) {
        return this.and(DSL.exists(select));
    }

    @Override
    public final JoinTable andNotExists(Select<?> select) {
        return this.and(DSL.notExists(select));
    }

    @Override
    public final JoinTable or(Condition c) {
        this.condition.addConditions(Operator.OR, c);
        return this;
    }

    @Override
    public final JoinTable or(Field<Boolean> c) {
        return this.or(DSL.condition(c));
    }

    @Override
    public final JoinTable or(String sql) {
        return this.or(DSL.condition(sql));
    }

    @Override
    public final JoinTable or(String sql, Object ... bindings) {
        return this.or(DSL.condition(sql, bindings));
    }

    @Override
    public final JoinTable or(String sql, QueryPart ... parts) {
        return this.or(DSL.condition(sql, parts));
    }

    @Override
    public final JoinTable orNot(Condition c) {
        return this.or(c.not());
    }

    @Override
    public final JoinTable orNot(Field<Boolean> c) {
        return this.orNot(DSL.condition(c));
    }

    @Override
    public final JoinTable orExists(Select<?> select) {
        return this.or(DSL.exists(select));
    }

    @Override
    public final JoinTable orNotExists(Select<?> select) {
        return this.or(DSL.notExists(select));
    }
}

