/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Configuration;
import org.jooq.ExecuteType;
import org.jooq.Record;
import org.jooq.RecordListener;
import org.jooq.RecordListenerProvider;
import org.jooq.impl.DefaultRecordContext;
import org.jooq.impl.RecordOperation;

class RecordDelegate<R extends Record> {
    private final Configuration configuration;
    private final R record;
    private final RecordLifecycleType type;

    RecordDelegate(Configuration configuration, R record) {
        this(configuration, record, RecordLifecycleType.LOAD);
    }

    RecordDelegate(Configuration configuration, R record, RecordLifecycleType type) {
        this.configuration = configuration;
        this.record = record;
        this.type = type;
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, R record) {
        return new RecordDelegate<R>(configuration, record);
    }

    static final <R extends Record> RecordDelegate<R> delegate(Configuration configuration, R record, RecordLifecycleType type) {
        return new RecordDelegate<R>(configuration, record, type);
    }

    final <E extends Exception> R operate(RecordOperation<R, E> operation) throws E {
        RecordListenerProvider[] providers = null;
        RecordListener[] listeners = null;
        DefaultRecordContext ctx = null;
        if (this.configuration != null && (providers = this.configuration.recordListenerProviders()) != null) {
            listeners = new RecordListener[providers.length];
            ctx = new DefaultRecordContext(this.configuration, this.executeType(), new Record[]{this.record});
            for (int i = 0; i < providers.length; ++i) {
                listeners[i] = providers[i].provide();
            }
        }
        if (listeners != null) {
            block17: for (RecordListener listener : listeners) {
                switch (this.type) {
                    case LOAD: {
                        listener.loadStart(ctx);
                        continue block17;
                    }
                    case REFRESH: {
                        listener.refreshStart(ctx);
                        continue block17;
                    }
                    case STORE: {
                        listener.storeStart(ctx);
                        continue block17;
                    }
                    case INSERT: {
                        listener.insertStart(ctx);
                        continue block17;
                    }
                    case UPDATE: {
                        listener.updateStart(ctx);
                        continue block17;
                    }
                    case DELETE: {
                        listener.deleteStart(ctx);
                        continue block17;
                    }
                    default: {
                        throw new IllegalStateException("Type not supported: " + (Object)((Object)this.type));
                    }
                }
            }
        }
        if (operation != null) {
            operation.operate(this.record);
        }
        if (listeners != null) {
            block18: for (RecordListener listener : listeners) {
                switch (this.type) {
                    case LOAD: {
                        listener.loadEnd(ctx);
                        continue block18;
                    }
                    case REFRESH: {
                        listener.refreshEnd(ctx);
                        continue block18;
                    }
                    case STORE: {
                        listener.storeEnd(ctx);
                        continue block18;
                    }
                    case INSERT: {
                        listener.insertEnd(ctx);
                        continue block18;
                    }
                    case UPDATE: {
                        listener.updateEnd(ctx);
                        continue block18;
                    }
                    case DELETE: {
                        listener.deleteEnd(ctx);
                        continue block18;
                    }
                    default: {
                        throw new IllegalStateException("Type not supported: " + (Object)((Object)this.type));
                    }
                }
            }
        }
        return this.record;
    }

    private final ExecuteType executeType() {
        return this.type == RecordLifecycleType.LOAD || this.type == RecordLifecycleType.REFRESH ? ExecuteType.READ : ExecuteType.WRITE;
    }

    static enum RecordLifecycleType {
        LOAD,
        REFRESH,
        STORE,
        INSERT,
        UPDATE,
        DELETE;

    }
}

