/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Comparator;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Operator;
import org.jooq.QueryPartInternal;
import org.jooq.RenderContext;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.CombinedCondition;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RowCondition;

class RowInCondition
extends AbstractCondition {
    private static final long serialVersionUID = -1806139685201770706L;
    private static final Clause[] CLAUSES_IN = new Clause[]{Clause.CONDITION, Clause.CONDITION_IN};
    private static final Clause[] CLAUSES_IN_NOT = new Clause[]{Clause.CONDITION, Clause.CONDITION_NOT_IN};
    private final Row left;
    private final QueryPartList<? extends Row> right;
    private final Comparator comparator;

    RowInCondition(Row left, QueryPartList<? extends Row> right, Comparator comparator) {
        this.left = left;
        this.right = right;
        this.comparator = comparator;
    }

    @Override
    public final void toSQL(RenderContext ctx) {
        this.delegate(ctx.configuration()).toSQL(ctx);
    }

    @Override
    public final void bind(BindContext ctx) {
        this.delegate(ctx.configuration()).bind(ctx);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.delegate(ctx.configuration()).clauses(ctx);
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        if (Arrays.asList(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.SQLITE).contains((Object)configuration.dialect().family())) {
            ArrayList<RowCondition> conditions = new ArrayList<RowCondition>();
            for (Row row : this.right) {
                conditions.add(new RowCondition(this.left, row, Comparator.EQUALS));
            }
            Condition result = new CombinedCondition(Operator.OR, conditions);
            if (this.comparator == Comparator.NOT_IN) {
                result = result.not();
            }
            return result;
        }
        return new Native();
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -7019193803316281371L;

        private Native() {
        }

        @Override
        public final void toSQL(RenderContext context) {
            ((RenderContext)((RenderContext)context.visit(RowInCondition.this.left)).sql(" ").keyword(RowInCondition.this.comparator.toSQL()).sql(" (").visit(RowInCondition.this.right)).sql(")");
        }

        @Override
        public final void bind(BindContext context) {
            ((BindContext)context.visit(RowInCondition.this.left)).visit(RowInCondition.this.right);
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return RowInCondition.this.comparator == Comparator.IN ? CLAUSES_IN : CLAUSES_IN_NOT;
        }
    }
}

