/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractFunction;
import org.jooq.impl.DSL;
import org.jooq.impl.Utils;

public class SequenceImpl<T extends Number>
implements Sequence<T> {
    private static final long serialVersionUID = 6224349401603636427L;
    final String name;
    final Schema schema;
    final DataType<T> type;

    public SequenceImpl(String name, Schema schema, DataType<T> type) {
        this.name = name;
        this.schema = schema;
        this.type = type;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Schema getSchema() {
        return this.schema;
    }

    @Override
    public final DataType<T> getDataType() {
        return this.type;
    }

    @Override
    public final Field<T> currval() {
        return this.getSequence("currval");
    }

    @Override
    public final Field<T> nextval() {
        return this.getSequence("nextval");
    }

    private final Field<T> getSequence(String sequence) {
        return new SequenceFunction(sequence);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private class SequenceFunction
    extends AbstractFunction<T> {
        private static final long serialVersionUID = 2292275568395094887L;
        private final String method;

        SequenceFunction(String method) {
            super(method, SequenceImpl.this.type, new Field[0]);
            this.method = method;
        }

        @Override
        final Field<T> getFunction0(Configuration configuration) {
            SQLDialect family = configuration.dialect().family();
            switch (family) {
                case H2: 
                case POSTGRES: {
                    String field = this.method + "('" + this.getQualifiedName(configuration) + "')";
                    return DSL.field(field, this.getDataType());
                }
                case FIREBIRD: 
                case DERBY: 
                case HSQLDB: {
                    if ("nextval".equals(this.method)) {
                        String field = "next value for " + this.getQualifiedName(configuration);
                        return DSL.field(field, this.getDataType());
                    }
                    if (family == SQLDialect.FIREBIRD) {
                        return DSL.field("gen_id(" + this.getQualifiedName(configuration) + ", 0)", this.getDataType());
                    }
                    throw new SQLDialectNotSupportedException("The sequence's current value functionality is not supported for the " + (Object)((Object)family) + " dialect.");
                }
                case CUBRID: {
                    String field = this.getQualifiedName(configuration) + ".";
                    field = "nextval".equals(this.method) ? field + "next_value" : field + "current_value";
                    return DSL.field(field, this.getDataType());
                }
            }
            String field = this.getQualifiedName(configuration) + "." + this.method;
            return DSL.field(field, this.getDataType());
        }

        private final String getQualifiedName(Configuration configuration) {
            RenderContext local = this.create(configuration).renderContext();
            Schema mappedSchema = Utils.getMappedSchema(configuration, SequenceImpl.this.schema);
            if (mappedSchema != null && configuration.dialect() != SQLDialect.CUBRID) {
                local.visit(mappedSchema);
                local.sql(".");
            }
            local.literal(SequenceImpl.this.name);
            return local.render();
        }
    }
}

