/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.impl.AbstractField;
import org.jooq.tools.StringUtils;

class TableFieldImpl<R extends Record, T>
extends AbstractField<T>
implements TableField<R, T> {
    private static final long serialVersionUID = -2211214195583539735L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.FIELD, Clause.FIELD_REFERENCE};
    private final Table<R> table;

    TableFieldImpl(String name, DataType<T> type, Table<R> table) {
        super(name, type);
        this.table = table;
    }

    @Override
    public final Table<R> getTable() {
        return this.table;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final void toSQL(RenderContext context) {
        context.data("org.jooq.configuration.omit-clause-event-emission", true);
        if (context.qualify()) {
            context.visit(this.table);
            context.sql(".");
        }
        context.literal(this.getName());
        context.data("org.jooq.configuration.omit-clause-event-emission", null);
    }

    @Override
    public final void bind(BindContext context) {
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof TableField) {
            TableField other = (TableField)that;
            return StringUtils.equals(this.getTable(), other.getTable()) && StringUtils.equals(this.getName(), other.getName());
        }
        return super.equals(that);
    }
}

