/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Schema;
import org.jooq.Table;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Alias;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Utils;
import org.jooq.tools.StringUtils;

public class TableImpl<R extends Record>
extends AbstractTable<R> {
    private static final long serialVersionUID = 261033315221985068L;
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    private final Fields<R> fields = new Fields(new Field[0]);
    private final Alias<Table<R>> alias;

    public TableImpl(String name) {
        this(name, null, null);
    }

    public TableImpl(String name, Schema schema) {
        this(name, schema, null);
    }

    public TableImpl(String name, Schema schema, Table<R> aliased) {
        super(name, schema);
        this.alias = aliased != null ? new Alias<Table<R>>(aliased, name) : null;
    }

    Table<R> getAliasedTable() {
        if (this.alias != null) {
            return this.alias.wrapped();
        }
        return null;
    }

    @Override
    final Fields<R> fields0() {
        return this.fields;
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.alias != null ? CLAUSES_TABLE_ALIAS : CLAUSES_TABLE_REFERENCE;
    }

    @Override
    public final void bind(BindContext context) {
        if (this.alias != null) {
            this.alias.bind(context);
        }
    }

    @Override
    public final void toSQL(RenderContext context) {
        if (this.alias != null) {
            this.alias.toSQL(context);
        } else {
            Schema mappedSchema;
            if (context.qualify() && (mappedSchema = Utils.getMappedSchema(context.configuration(), this.getSchema())) != null) {
                context.visit(mappedSchema);
                context.sql(".");
            }
            context.literal(Utils.getMappedTable(context.configuration(), this).getName());
        }
    }

    @Override
    public Table<R> as(String as) {
        if (this.alias != null) {
            return this.alias.wrapped().as(as);
        }
        return new TableAlias(this, as);
    }

    @Override
    public Table<R> as(String as, String ... fieldAliases) {
        if (this.alias != null) {
            return this.alias.wrapped().as(as, fieldAliases);
        }
        return new TableAlias(this, as, fieldAliases);
    }

    @Override
    public Class<? extends R> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    public boolean declaresTables() {
        if (this.alias != null) {
            return true;
        }
        return super.declaresTables();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof TableImpl) {
            TableImpl other = (TableImpl)that;
            return StringUtils.equals(this.getSchema(), other.getSchema()) && StringUtils.equals(this.getName(), other.getName());
        }
        return super.equals(that);
    }
}

