/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Table;
import org.jooq.TruncateCascadeStep;
import org.jooq.TruncateFinalStep;
import org.jooq.TruncateIdentityStep;
import org.jooq.impl.AbstractQuery;

class TruncateImpl<R extends Record>
extends AbstractQuery
implements TruncateIdentityStep<R> {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TRUNCATE};
    private final Table<R> table;
    private Boolean cascade;
    private Boolean restartIdentity;

    public TruncateImpl(Configuration configuration, Table<R> table) {
        super(configuration);
        this.table = table;
    }

    @Override
    public final TruncateFinalStep<R> cascade() {
        this.cascade = true;
        return this;
    }

    @Override
    public final TruncateFinalStep<R> restrict() {
        this.cascade = false;
        return this;
    }

    @Override
    public final TruncateCascadeStep<R> restartIdentity() {
        this.restartIdentity = true;
        return this;
    }

    @Override
    public final TruncateCascadeStep<R> continueIdentity() {
        this.restartIdentity = false;
        return this;
    }

    @Override
    public final void toSQL(RenderContext context) {
        switch (context.configuration().dialect()) {
            case FIREBIRD: 
            case SQLITE: {
                context.visit(this.create(context).delete(this.table));
                break;
            }
            default: {
                ((RenderContext)context.start(Clause.TRUNCATE_TRUNCATE)).keyword("truncate table").sql(" ").visit(this.table);
                if (this.restartIdentity != null) {
                    context.formatSeparator().keyword(this.restartIdentity != false ? "restart identity" : "continue identity");
                }
                if (this.cascade != null) {
                    context.formatSeparator().keyword(this.cascade != false ? "cascade" : "restrict");
                }
                context.end(Clause.TRUNCATE_TRUNCATE);
            }
        }
    }

    @Override
    public final void bind(BindContext context) {
        context.visit(this.table);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

