/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import org.jooq.Configuration;
import org.jooq.Field;
import org.jooq.Row;
import org.jooq.Schema;
import org.jooq.UDT;
import org.jooq.UDTRecord;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.RowImpl;
import org.jooq.impl.Utils;

public class UDTRecordImpl<R extends UDTRecord<R>>
extends AbstractRecord
implements UDTRecord<R> {
    private static final long serialVersionUID = 5671315498175872799L;
    private final UDT<R> udt;

    public UDTRecordImpl(UDT<R> udt) {
        super(udt.fields());
        this.udt = udt;
    }

    @Override
    public final UDT<R> getUDT() {
        return this.udt;
    }

    @Override
    public Row fieldsRow() {
        return this.fields;
    }

    @Override
    public Row valuesRow() {
        return new RowImpl(Utils.fields(this.intoArray(), this.fields.fields.fields()));
    }

    @Override
    public final String getSQLTypeName() throws SQLException {
        Schema schema;
        StringBuilder sb = new StringBuilder();
        Configuration configuration = DefaultExecuteContext.localConfiguration();
        if (configuration != null && (schema = Utils.getMappedSchema(configuration, this.getUDT().getSchema())) != null) {
            sb.append(schema.getName());
            sb.append(".");
        }
        sb.append(this.getUDT().getName());
        return sb.toString();
    }

    @Override
    public final void readSQL(SQLInput stream, String typeName) throws SQLException {
        Configuration configuration = DefaultExecuteContext.localConfiguration();
        for (Field<?> field : this.getUDT().fields()) {
            this.setValue(configuration, stream, field);
        }
    }

    private final <T> void setValue(Configuration configuration, SQLInput stream, Field<T> field) throws SQLException {
        this.setValue(field, Utils.getFromSQLInput(configuration, stream, field));
    }

    @Override
    public final void writeSQL(SQLOutput stream) throws SQLException {
        for (Field<?> field : this.getUDT().fields()) {
            this.setValue(stream, field);
        }
    }

    private final <T> void setValue(SQLOutput stream, Field<T> field) throws SQLException {
        Utils.writeToSQLOutput(stream, field, this.getValue(field));
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        String separator = "";
        result.append(this.create().render(this.getUDT()));
        result.append("(");
        for (Object o : this.intoArray()) {
            result.append(separator);
            result.append(o);
            separator = ", ";
        }
        result.append(")");
        return result.toString();
    }
}

