/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jooq.ConditionProvider;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DeleteQuery;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Identity;
import org.jooq.InsertQuery;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectQuery;
import org.jooq.StoreQuery;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableRecord;
import org.jooq.UniqueKey;
import org.jooq.UpdatableRecord;
import org.jooq.UpdateQuery;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataChangedException;
import org.jooq.exception.InvalidResultException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.RecordDelegate;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.TableRecordImpl;
import org.jooq.impl.Utils;
import org.jooq.impl.Value;
import org.jooq.tools.StringUtils;

public class UpdatableRecordImpl<R extends UpdatableRecord<R>>
extends TableRecordImpl<R>
implements UpdatableRecord<R> {
    private static final long serialVersionUID = -1012420583600561579L;

    public UpdatableRecordImpl(Table<R> table) {
        super(table);
    }

    @Override
    public Record key() {
        RecordImpl result = new RecordImpl(this.getPrimaryKey().getFields());
        result.setValues(result.fields.fields.fields, this);
        return result;
    }

    @Override
    public final <O extends TableRecord<O>> O fetchChild(ForeignKey<O, R> key) {
        return (O)((TableRecord)Utils.filterOne(this.fetchChildren(key)));
    }

    @Override
    public final <O extends TableRecord<O>> Result<O> fetchChildren(ForeignKey<O, R> key) {
        return key.fetchChildren((R)this);
    }

    final UniqueKey<R> getPrimaryKey() {
        return this.getTable().getPrimaryKey();
    }

    @Override
    public final int store() {
        final int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.STORE).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                result[0] = UpdatableRecordImpl.this.store0();
                return record;
            }
        });
        return result[0];
    }

    @Override
    public final int insert() {
        return this.storeInsert();
    }

    @Override
    public final int update() {
        return this.storeUpdate(this.getPrimaryKey().getFieldsArray());
    }

    private final int store0() {
        TableField<R, ?>[] keys = this.getPrimaryKey().getFieldsArray();
        boolean executeUpdate = false;
        for (TableField field : keys) {
            if (SettingsTools.updatablePrimaryKeys(Utils.settings(this))) {
                if (this.original(field) == null) {
                    executeUpdate = false;
                    break;
                }
            } else if (this.getValue(field) == null || this.getValue0(field).isChanged()) {
                executeUpdate = false;
                break;
            }
            executeUpdate = true;
        }
        int result = 0;
        result = executeUpdate ? this.storeUpdate(keys) : this.storeInsert();
        return result;
    }

    private final int storeInsert() {
        final int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.INSERT).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                result[0] = UpdatableRecordImpl.this.storeInsert0();
                return record;
            }
        });
        return result[0];
    }

    private final int storeInsert0() {
        int result;
        DSLContext create = this.create();
        InsertQuery insert = create.insertQuery(this.getTable());
        this.addChangedValues(insert);
        if (!insert.isExecutable()) {
            return 0;
        }
        BigInteger version = this.addRecordVersion(insert);
        Timestamp timestamp = this.addRecordTimestamp(insert);
        Collection<Field<?>> key = null;
        if (!Boolean.TRUE.equals(create.configuration().data("org.jooq.configuration.omit-returning-clause"))) {
            key = this.getReturning();
            insert.setReturning(key);
        }
        if ((result = insert.execute()) > 0) {
            this.setRecordVersionAndTimestamp(version, timestamp);
            if (key != null && !key.isEmpty() && insert.getReturnedRecord() != null) {
                for (Field<?> field : key) {
                    this.setValue(field, new Value(((UpdatableRecord)insert.getReturnedRecord()).getValue(field)));
                }
            }
            this.changed(false);
        }
        return result;
    }

    private final int storeUpdate(final TableField<R, ?>[] keys) {
        final int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.UPDATE).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                result[0] = UpdatableRecordImpl.this.storeUpdate0(keys);
                return record;
            }
        });
        return result[0];
    }

    private final int storeUpdate0(TableField<R, ?>[] keys) {
        UpdateQuery update = this.create().updateQuery(this.getTable());
        this.addChangedValues(update);
        Utils.addConditions(update, this, keys);
        if (!update.isExecutable()) {
            return 0;
        }
        BigInteger version = this.addRecordVersion(update);
        Timestamp timestamp = this.addRecordTimestamp(update);
        if (this.isExecuteWithOptimisticLocking()) {
            if (this.isTimestampOrVersionAvailable()) {
                this.addConditionForVersionAndTimestamp(update);
            } else {
                this.checkIfChanged(keys);
            }
        }
        int result = update.execute();
        this.checkIfChanged(result, version, timestamp);
        if (result > 0) {
            this.changed(false);
        }
        return result;
    }

    private final void addChangedValues(StoreQuery<R> query) {
        for (Field<?> field : this.fields.fields.fields) {
            if (!this.getValue0(field).isChanged()) continue;
            this.addValue(query, field);
        }
    }

    private final <T> void addValue(StoreQuery<?> store, Field<T> field, Object value) {
        store.addValue(field, Utils.field(value, field));
    }

    private final <T> void addValue(StoreQuery<?> store, Field<T> field) {
        this.addValue(store, field, this.getValue(field));
    }

    private final Timestamp addRecordTimestamp(StoreQuery<?> store) {
        TableField timestamp;
        Timestamp result = null;
        if (this.isTimestampOrVersionAvailable() && (timestamp = this.getTable().getRecordTimestamp()) != null) {
            result = new Timestamp(System.currentTimeMillis());
            this.addValue(store, timestamp, result);
        }
        return result;
    }

    private final BigInteger addRecordVersion(StoreQuery<?> store) {
        TableField version;
        BigInteger result = null;
        if (this.isTimestampOrVersionAvailable() && (version = this.getTable().getRecordVersion()) != null) {
            Number value = (Number)this.getValue(version);
            result = value == null ? BigInteger.ONE : new BigInteger(value.toString()).add(BigInteger.ONE);
            this.addValue(store, version, result);
        }
        return result;
    }

    @Override
    public final int delete() {
        final int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.DELETE).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                result[0] = UpdatableRecordImpl.this.delete0();
                return record;
            }
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int delete0() {
        TableField<R, ?>[] keys = this.getPrimaryKey().getFieldsArray();
        try {
            DeleteQuery delete1 = this.create().deleteQuery(this.getTable());
            Utils.addConditions(delete1, this, keys);
            if (this.isExecuteWithOptimisticLocking()) {
                if (this.isTimestampOrVersionAvailable()) {
                    this.addConditionForVersionAndTimestamp(delete1);
                } else {
                    this.checkIfChanged(keys);
                }
            }
            int result = delete1.execute();
            this.checkIfChanged(result, null, null);
            int n = result;
            return n;
        }
        finally {
            this.changed(true);
        }
    }

    @Override
    public final void refresh() {
        this.refresh(this.fields.fields.fields);
    }

    @Override
    public final void refresh(final Field<?> ... f) {
        SelectQuery<Record> select = this.create().selectQuery();
        select.addSelect(f);
        select.addFrom(this.getTable());
        Utils.addConditions(select, this, this.getPrimaryKey().getFieldsArray());
        if (select.execute() != 1) {
            throw new InvalidResultException("Exactly one row expected for refresh. Record does not exist in database.");
        }
        final AbstractRecord source = (AbstractRecord)select.getResult().get(0);
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.REFRESH).operate(new RecordOperation<Record, RuntimeException>(){

            @Override
            public Record operate(Record record) throws RuntimeException {
                UpdatableRecordImpl.this.setValues(f, source);
                return record;
            }
        });
    }

    private final Collection<Field<?>> getReturning() {
        LinkedHashSet result = new LinkedHashSet();
        Identity identity = this.getTable().getIdentity();
        if (identity != null) {
            result.add(identity.getField());
        }
        result.addAll(this.getPrimaryKey().getFields());
        return result;
    }

    @Override
    public final R copy() {
        return (R)((UpdatableRecord)Utils.newRecord(this.getTable(), this.configuration()).operate(new RecordOperation<R, RuntimeException>(){

            @Override
            public R operate(R copy) throws RuntimeException {
                List key = UpdatableRecordImpl.this.getPrimaryKey().getFields();
                for (Field<?> field : UpdatableRecordImpl.this.fields.fields.fields) {
                    if (key.contains(field)) continue;
                    this.setValue((Record)copy, field);
                }
                return copy;
            }

            private final <T> void setValue(Record record, Field<T> field) {
                record.setValue(field, UpdatableRecordImpl.this.getValue(field));
            }
        }));
    }

    private final boolean isExecuteWithOptimisticLocking() {
        Configuration configuration = this.configuration();
        if (configuration != null) {
            return Boolean.TRUE.equals(configuration.settings().isExecuteWithOptimisticLocking());
        }
        return false;
    }

    private final void addConditionForVersionAndTimestamp(ConditionProvider query) {
        TableField v = this.getTable().getRecordVersion();
        TableField t = this.getTable().getRecordTimestamp();
        if (v != null) {
            Utils.addCondition(query, this, v);
        }
        if (t != null) {
            Utils.addCondition(query, this, t);
        }
    }

    private final boolean isTimestampOrVersionAvailable() {
        return this.getTable().getRecordTimestamp() != null || this.getTable().getRecordVersion() != null;
    }

    private final void checkIfChanged(TableField<R, ?>[] keys) {
        UpdatableRecord record;
        SelectQuery select = this.create().selectQuery(this.getTable());
        Utils.addConditions(select, this, keys);
        if (this.create().configuration().dialect() != SQLDialect.SQLITE) {
            select.setForUpdate(true);
        }
        if ((record = (UpdatableRecord)select.fetchOne()) == null) {
            throw new DataChangedException("Database record no longer exists");
        }
        for (Field<?> field : this.fields.fields.fields) {
            Object thatObject;
            Value<?> thisValue = this.getValue0(field);
            Value<?> thatValue = ((AbstractRecord)((Object)record)).getValue0(field);
            Object thisObject = thisValue.getOriginal();
            if (StringUtils.equals(thisObject, thatObject = thatValue.getOriginal())) continue;
            throw new DataChangedException("Database record has been changed");
        }
    }

    private final void checkIfChanged(int result, BigInteger version, Timestamp timestamp) {
        if (result > 0) {
            this.setRecordVersionAndTimestamp(version, timestamp);
        } else if (this.isExecuteWithOptimisticLocking()) {
            throw new DataChangedException("Database record has been changed or doesn't exist any longer");
        }
    }

    private final void setRecordVersionAndTimestamp(BigInteger version, Timestamp timestamp) {
        TableField field;
        if (version != null) {
            field = this.getTable().getRecordVersion();
            this.setValue((Field<?>)field, (Value<?>)new Value(field.getDataType().convert((Object)version)));
        }
        if (timestamp != null) {
            field = this.getTable().getRecordTimestamp();
            this.setValue((Field<?>)field, (Value<?>)new Value(field.getDataType().convert((Object)timestamp)));
        }
    }
}

