/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.jooq.Attachable;
import org.jooq.AttachableInternal;
import org.jooq.BindContext;
import org.jooq.ConditionProvider;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.Cursor;
import org.jooq.DataType;
import org.jooq.EnumType;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordType;
import org.jooq.RenderContext;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.SchemaMapping;
import org.jooq.Table;
import org.jooq.UDT;
import org.jooq.UDTRecord;
import org.jooq.conf.ParamType;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.InvalidResultException;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.DSL;
import org.jooq.impl.DataTypes;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.DefaultRenderContext;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordDelegate;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.RecordOperation;
import org.jooq.impl.Val;
import org.jooq.impl.Value;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.reflect.Reflect;
import org.jooq.types.DayToSecond;
import org.jooq.types.UByte;
import org.jooq.types.UInteger;
import org.jooq.types.ULong;
import org.jooq.types.UNumber;
import org.jooq.types.UShort;
import org.jooq.types.YearToMonth;
import org.jooq.util.postgres.PostgresUtils;

final class Utils {
    static final JooqLogger log = JooqLogger.getLogger(Utils.class);
    static final String DATA_OMIT_RETURNING_CLAUSE = "org.jooq.configuration.omit-returning-clause";
    static final String DATA_ROW_VALUE_EXPRESSION_PREDICATE_SUBQUERY = "org.jooq.configuration.row-value-expression-subquery";
    static final String DATA_LOCK_ROWS_FOR_UPDATE = "org.jooq.configuration.lock-rows-for-update";
    static final String DATA_COUNT_BIND_VALUES = "org.jooq.configuration.count-bind-values";
    static final String DATA_FORCE_STATIC_STATEMENT = "org.jooq.configuration.force-static-statement";
    static final String DATA_OMIT_CLAUSE_EVENT_EMISSION = "org.jooq.configuration.omit-clause-event-emission";
    static final String DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES = "org.jooq.configuration.wrap-derived-tables-in-parentheses";
    static final char ESCAPE = '!';
    private static Boolean isJPAAvailable;
    private static final Pattern DASH_PATTERN;
    private static final Pattern PLUS_PATTERN;
    private static final Pattern JDBC_ESCAPE_PATTERN;

    Utils() {
    }

    static final <R extends Record> RecordDelegate<R> newRecord(Class<R> type) {
        return Utils.newRecord(type, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(Class<R> type, Field<?>[] fields) {
        return Utils.newRecord(type, fields, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(Table<R> type) {
        return Utils.newRecord(type, null);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(Table<R> type, Configuration configuration) {
        return Utils.newRecord(type.getRecordType(), type.fields(), configuration);
    }

    static final <R extends UDTRecord<R>> RecordDelegate<R> newRecord(UDT<R> type) {
        return Utils.newRecord(type, null);
    }

    static final <R extends UDTRecord<R>> RecordDelegate<R> newRecord(UDT<R> type, Configuration configuration) {
        return Utils.newRecord(type.getRecordType(), type.fields(), configuration);
    }

    static final <R extends Record> RecordDelegate<R> newRecord(Class<R> type, Field<?>[] fields, Configuration configuration) {
        try {
            Record record = type == RecordImpl.class || type == Record.class ? new RecordImpl(fields) : (Record)Reflect.accessible(type.getDeclaredConstructor(new Class[0])).newInstance(new Object[0]);
            if (Utils.attachRecords(configuration)) {
                record.attach(configuration);
            }
            return new RecordDelegate(configuration, record);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not construct new record", e);
        }
    }

    static final Configuration getConfiguration(Attachable attachable) {
        if (attachable instanceof AttachableInternal) {
            return ((AttachableInternal)attachable).configuration();
        }
        return null;
    }

    static Configuration configuration(Attachable attachable) {
        return Utils.configuration(attachable instanceof AttachableInternal ? ((AttachableInternal)attachable).configuration() : null);
    }

    static Configuration configuration(Configuration configuration) {
        return configuration != null ? configuration : new DefaultConfiguration();
    }

    static Settings settings(Attachable attachable) {
        return Utils.configuration(attachable).settings();
    }

    static Settings settings(Configuration configuration) {
        return Utils.configuration(configuration).settings();
    }

    static final boolean attachRecords(Configuration configuration) {
        Settings settings;
        if (configuration != null && (settings = configuration.settings()) != null) {
            return !Boolean.FALSE.equals(settings.isAttachRecords());
        }
        return true;
    }

    static final Field<?>[] fieldArray(Collection<? extends Field<?>> fields) {
        return fields == null ? null : fields.toArray(new Field[fields.size()]);
    }

    static final Class<?>[] getClasses(Field<?>[] fields) {
        return Utils.getClasses(Utils.getDataTypes(fields));
    }

    static final Class<?>[] getClasses(DataType<?>[] types) {
        if (types == null) {
            return null;
        }
        Class[] result = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i] != null ? types[i].getType() : Object.class;
        }
        return result;
    }

    static final Class<?>[] getClasses(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] instanceof Field ? ((Field)values[i]).getType() : (values[i] != null ? values[i].getClass() : Object.class);
        }
        return result;
    }

    static final DataType<?>[] getDataTypes(Field<?>[] fields) {
        if (fields == null) {
            return null;
        }
        DataType[] result = new DataType[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = fields[i] != null ? fields[i].getDataType() : DSL.getDataType(Object.class);
        }
        return result;
    }

    static final DataType<?>[] getDataTypes(Class<?>[] types) {
        if (types == null) {
            return null;
        }
        DataType[] result = new DataType[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = types[i] != null ? DSL.getDataType(types[i]) : DSL.getDataType(Object.class);
        }
        return result;
    }

    static final DataType<?>[] getDataTypes(Object[] values) {
        return Utils.getDataTypes(Utils.getClasses(values));
    }

    static final <T> Field<T> field(T value) {
        if (value instanceof Field) {
            return (Field)value;
        }
        return DSL.val(value);
    }

    static final <T> Field<T> field(Object value, Field<T> field) {
        if (value instanceof Field) {
            return (Field)value;
        }
        return DSL.val(value, field);
    }

    static final <T> Field<T> field(Object value, Class<T> type) {
        if (value instanceof Field) {
            return (Field)value;
        }
        return DSL.val(value, type);
    }

    static final <T> Field<T> field(Object value, DataType<T> type) {
        if (value instanceof Field) {
            return (Field)value;
        }
        return DSL.val(value, type);
    }

    static final List<Field<?>> fields(Object[] values) {
        ArrayList result = new ArrayList();
        if (values != null) {
            for (Object value : values) {
                result.add(Utils.field(value));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Field<?> field) {
        ArrayList result = new ArrayList();
        if (values != null && field != null) {
            for (int i = 0; i < values.length; ++i) {
                result.add(Utils.field(values[i], field));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Field<?>[] fields) {
        ArrayList result = new ArrayList();
        if (values != null && fields != null) {
            for (int i = 0; i < values.length && i < fields.length; ++i) {
                result.add(Utils.field(values[i], fields[i]));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Class<?> type) {
        ArrayList result = new ArrayList();
        if (values != null && type != null) {
            for (int i = 0; i < values.length; ++i) {
                result.add(Utils.field(values[i], type));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, Class<?>[] types) {
        ArrayList result = new ArrayList();
        if (values != null && types != null) {
            for (int i = 0; i < values.length && i < types.length; ++i) {
                result.add(Utils.field(values[i], types[i]));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, DataType<?> type) {
        ArrayList result = new ArrayList();
        if (values != null && type != null) {
            for (int i = 0; i < values.length; ++i) {
                result.add(Utils.field(values[i], type));
            }
        }
        return result;
    }

    static final List<Field<?>> fields(Object[] values, DataType<?>[] types) {
        ArrayList result = new ArrayList();
        if (values != null && types != null) {
            for (int i = 0; i < values.length && i < types.length; ++i) {
                result.add(Utils.field(values[i], types[i]));
            }
        }
        return result;
    }

    static final int indexOrFail(Row row, Field<?> field) {
        int result = row.indexOf(field);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + field + ") is not contained in Row " + row);
        }
        return result;
    }

    static final int indexOrFail(Row row, String fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in Row " + row);
        }
        return result;
    }

    static final int indexOrFail(RecordType<?> row, Field<?> field) {
        int result = row.indexOf(field);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + field + ") is not contained in RecordType " + row);
        }
        return result;
    }

    static final int indexOrFail(RecordType<?> row, String fieldName) {
        int result = row.indexOf(fieldName);
        if (result < 0) {
            throw new IllegalArgumentException("Field (" + fieldName + ") is not contained in RecordType " + row);
        }
        return result;
    }

    static final <T> T[] array(T ... array) {
        return array;
    }

    static final <T> List<T> list(T ... array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }

    static final Map<Field<?>, Object> map(Record record) {
        LinkedHashMap result = new LinkedHashMap();
        int size = record.size();
        for (int i = 0; i < size; ++i) {
            result.put(record.field(i), record.getValue(i));
        }
        return result;
    }

    static final <T> T first(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return null;
        }
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    static final <R extends Record> R filterOne(List<R> list) throws InvalidResultException {
        int size = list.size();
        if (size == 1) {
            return (R)((Record)list.get(0));
        }
        if (size > 1) {
            throw new InvalidResultException("Too many rows selected : " + size);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final <R extends Record> R fetchOne(Cursor<R> cursor) throws InvalidResultException {
        try {
            R record = cursor.fetchOne();
            if (cursor.hasNext()) {
                throw new InvalidResultException("Cursor returned more than one result");
            }
            R r = record;
            return r;
        }
        finally {
            cursor.close();
        }
    }

    static final <C extends Context<? super C>> C visitAll(C ctx, Collection<? extends QueryPart> parts) {
        if (parts != null) {
            for (QueryPart queryPart : parts) {
                ctx.visit(queryPart);
            }
        }
        return ctx;
    }

    static final <C extends Context<? super C>> C visitAll(C ctx, QueryPart[] parts) {
        if (parts != null) {
            for (QueryPart part : parts) {
                ctx.visit(part);
            }
        }
        return ctx;
    }

    static final void renderAndBind(RenderContext render, BindContext bind, String sql, List<QueryPart> substitutes) {
        int substituteIndex = 0;
        char[] sqlChars = sql.toCharArray();
        if (render == null) {
            render = new DefaultRenderContext(bind.configuration());
        }
        for (int i = 0; i < sqlChars.length; ++i) {
            if (Utils.peek(sqlChars, i, "--")) {
                while (i < sqlChars.length && sqlChars[i] != '\r' && sqlChars[i] != '\n') {
                    render.sql(sqlChars[i++]);
                }
                if (i >= sqlChars.length) continue;
                render.sql(sqlChars[i]);
                continue;
            }
            if (Utils.peek(sqlChars, i, "/*")) {
                while (!Utils.peek(sqlChars, i, "*/")) {
                    render.sql(sqlChars[i++]);
                }
                render.sql(sqlChars[i++]);
                render.sql(sqlChars[i]);
                continue;
            }
            if (sqlChars[i] == '\'') {
                render.sql(sqlChars[i++]);
                while (true) {
                    if (Utils.peek(sqlChars, i, "''")) {
                        render.sql(sqlChars[i++]);
                    } else if (Utils.peek(sqlChars, i, "'")) break;
                    render.sql(sqlChars[i++]);
                }
                render.sql(sqlChars[i]);
                continue;
            }
            if (sqlChars[i] == '?' && substituteIndex < substitutes.size()) {
                QueryPart substitute = substitutes.get(substituteIndex++);
                if (render.paramType() == ParamType.INLINED) {
                    render.visit(substitute);
                } else {
                    render.sql(sqlChars[i]);
                }
                if (bind == null) continue;
                bind.visit(substitute);
                continue;
            }
            if (sqlChars[i] == '{') {
                if (JDBC_ESCAPE_PATTERN.matcher(sql.substring(i)).matches()) {
                    render.sql(sqlChars[i]);
                    continue;
                }
                int start = ++i;
                while (i < sqlChars.length && sqlChars[i] != '}') {
                    ++i;
                }
                int end = i;
                String token = sql.substring(start, end);
                try {
                    QueryPart substitute = substitutes.get(Integer.valueOf(token));
                    render.visit(substitute);
                    if (bind == null) continue;
                    bind.visit(substitute);
                }
                catch (NumberFormatException e) {
                    render.keyword(token);
                }
                continue;
            }
            render.sql(sqlChars[i]);
        }
    }

    static final boolean peek(char[] sqlChars, int index, String peek) {
        char[] peekArray = peek.toCharArray();
        for (int i = 0; i < peekArray.length; ++i) {
            if (index + i >= sqlChars.length) {
                return false;
            }
            if (sqlChars[index + i] == peekArray[i]) continue;
            return false;
        }
        return true;
    }

    static final List<QueryPart> queryParts(Object ... substitutes) {
        if (substitutes == null) {
            return Utils.queryParts(new Object[]{null});
        }
        ArrayList<QueryPart> result = new ArrayList<QueryPart>();
        for (Object substitute : substitutes) {
            if (substitute instanceof QueryPart) {
                result.add((QueryPart)substitute);
                continue;
            }
            Class type = substitute != null ? substitute.getClass() : Object.class;
            result.add(new Val<Object>(substitute, DSL.getDataType(type)));
        }
        return result;
    }

    static final void fieldNames(RenderContext context, Fields<?> fields) {
        Utils.fieldNames(context, Utils.list(fields.fields));
    }

    static final void fieldNames(RenderContext context, Field<?> ... fields) {
        Utils.fieldNames(context, Utils.list(fields));
    }

    static final void fieldNames(RenderContext context, Collection<? extends Field<?>> list) {
        String separator = "";
        for (Field<?> field : list) {
            context.sql(separator).literal(field.getName());
            separator = ", ";
        }
    }

    static final void tableNames(RenderContext context, Table<?> ... list) {
        Utils.tableNames(context, Utils.list(list));
    }

    static final void tableNames(RenderContext context, Collection<? extends Table<?>> list) {
        String separator = "";
        for (Table<?> table : list) {
            context.sql(separator).literal(table.getName());
            separator = ", ";
        }
    }

    static final <T> T[] combine(T[] array, T value) {
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, result, 0, array.length);
        result[array.length] = value;
        return result;
    }

    static final Field<?>[] combine(Field<?> field, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field};
        }
        Field[] result = new Field[fields.length + 1];
        result[0] = field;
        System.arraycopy(fields, 0, result, 1, fields.length);
        return result;
    }

    static final Field<?>[] combine(Field<?> field1, Field<?> field2, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field1, field2};
        }
        Field[] result = new Field[fields.length + 2];
        result[0] = field1;
        result[1] = field2;
        System.arraycopy(fields, 0, result, 2, fields.length);
        return result;
    }

    static final Field<?>[] combine(Field<?> field1, Field<?> field2, Field<?> field3, Field<?> ... fields) {
        if (fields == null) {
            return new Field[]{field1, field2, field3};
        }
        Field[] result = new Field[fields.length + 3];
        result[0] = field1;
        result[1] = field2;
        result[2] = field3;
        System.arraycopy(fields, 0, result, 3, fields.length);
        return result;
    }

    static final DataAccessException translate(String sql, SQLException e) {
        String message = "SQL [" + sql + "]; " + e.getMessage();
        return new DataAccessException(message, e);
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx) {
        Utils.safeClose(listener, ctx, false);
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx, boolean keepStatement) {
        Utils.safeClose(listener, ctx, keepStatement, true);
    }

    static final void safeClose(ExecuteListener listener, ExecuteContext ctx, boolean keepStatement, boolean keepResultSet) {
        JDBCUtils.safeClose(ctx.resultSet());
        ctx.resultSet(null);
        if (!keepStatement) {
            JDBCUtils.safeClose(ctx.statement());
            ctx.statement(null);
        }
        if (keepResultSet) {
            listener.end(ctx);
        }
        DefaultExecuteContext.clean();
    }

    static final <T> void setValue(Record target, Field<T> targetField, Record source, Field<?> sourceField) {
        Utils.setValue(target, targetField, source.getValue(sourceField));
    }

    static final <T> void setValue(Record target, Field<T> targetField, Object value) {
        target.setValue(targetField, targetField.getDataType().convert(value));
    }

    static final <T> void copyValue(AbstractRecord target, Field<T> targetField, Record source, Field<?> sourceField) {
        Value<T> value = new Value<T>(targetField.getDataType().convert(source.getValue(sourceField)), targetField.getDataType().convert(source.original(sourceField)), source.changed(sourceField));
        target.setValue(targetField, value);
    }

    static final Schema getMappedSchema(Configuration configuration, Schema schema) {
        SchemaMapping mapping = configuration.schemaMapping();
        if (mapping != null) {
            return mapping.map(schema);
        }
        return schema;
    }

    static final <R extends Record> Table<R> getMappedTable(Configuration configuration, Table<R> table) {
        SchemaMapping mapping = configuration.schemaMapping();
        if (mapping != null) {
            return mapping.map(table);
        }
        return table;
    }

    static final int hash(Object object) {
        return 0x7FFFFFF & object.hashCode();
    }

    static final Field<String> escapeForLike(Object value) {
        if (value != null && value.getClass() == String.class) {
            return DSL.val(DSL.escape("" + value, '!'));
        }
        return DSL.val("" + value);
    }

    static final Field<String> escapeForLike(Field<?> field) {
        if (DSL.nullSafe(field).getDataType().isString()) {
            return DSL.escape(field, '!');
        }
        return field.cast(String.class);
    }

    static final boolean isVal(Field<?> field) {
        return field instanceof Param;
    }

    static final <T> T extractVal(Field<T> field) {
        if (Utils.isVal(field)) {
            return ((Param)field).getValue();
        }
        return null;
    }

    static final void addConditions(ConditionProvider query, Record record, Field<?> ... keys) {
        for (Field<?> field : keys) {
            Utils.addCondition(query, record, field);
        }
    }

    static final <T> void addCondition(ConditionProvider provider, Record record, Field<T> field) {
        if (SettingsTools.updatablePrimaryKeys(Utils.settings(record))) {
            provider.addConditions(field.equal(record.original(field)));
        } else {
            provider.addConditions(field.equal(record.getValue(field)));
        }
    }

    private static final boolean isJPAAvailable() {
        if (isJPAAvailable == null) {
            try {
                Class.forName(Column.class.getName());
                isJPAAvailable = true;
            }
            catch (Throwable e) {
                isJPAAvailable = false;
            }
        }
        return isJPAAvailable;
    }

    static final boolean hasColumnAnnotations(Class<?> type) {
        if (!Utils.isJPAAvailable()) {
            return false;
        }
        if (type.getAnnotation(Entity.class) != null || type.getAnnotation(javax.persistence.Table.class) != null) {
            return true;
        }
        for (java.lang.reflect.Field member : Utils.getInstanceMembers(type)) {
            if (member.getAnnotation(Column.class) == null) continue;
            return true;
        }
        for (Method method : Utils.getInstanceMethods(type)) {
            if (method.getAnnotation(Column.class) == null) continue;
            return true;
        }
        return false;
    }

    static final List<java.lang.reflect.Field> getAnnotatedMembers(Class<?> type, String name) {
        ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field member : Utils.getInstanceMembers(type)) {
            Column annotation = member.getAnnotation(Column.class);
            if (annotation == null || !name.equals(annotation.name())) continue;
            result.add(Reflect.accessible(member));
        }
        return result;
    }

    static final List<java.lang.reflect.Field> getMatchingMembers(Class<?> type, String name) {
        ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
        String camelCaseLC = StringUtils.toCamelCaseLC(name);
        for (java.lang.reflect.Field member : Utils.getInstanceMembers(type)) {
            if (name.equals(member.getName())) {
                result.add(Reflect.accessible(member));
                continue;
            }
            if (!camelCaseLC.equals(member.getName())) continue;
            result.add(Reflect.accessible(member));
        }
        return result;
    }

    static final List<Method> getAnnotatedSetters(Class<?> type, String name) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : Utils.getInstanceMethods(type)) {
            String m;
            Column annotation = method.getAnnotation(Column.class);
            if (annotation == null || !name.equals(annotation.name())) continue;
            if (method.getParameterTypes().length == 1) {
                result.add(Reflect.accessible(method));
                continue;
            }
            if (method.getParameterTypes().length != 0 || !(m = method.getName()).startsWith("get") && !m.startsWith("is")) continue;
            try {
                Method setter = type.getMethod("set" + m.substring(3), method.getReturnType());
                if (setter.getAnnotation(Column.class) != null) continue;
                result.add(Reflect.accessible(setter));
            }
            catch (NoSuchMethodException ignore) {}
        }
        return result;
    }

    static final Method getAnnotatedGetter(Class<?> type, String name) {
        for (Method method : Utils.getInstanceMethods(type)) {
            Method getter;
            String m;
            Column annotation = method.getAnnotation(Column.class);
            if (annotation == null || !name.equals(annotation.name())) continue;
            if (method.getParameterTypes().length == 0) {
                return Reflect.accessible(method);
            }
            if (method.getParameterTypes().length != 1 || !(m = method.getName()).startsWith("set")) continue;
            try {
                getter = type.getMethod("get" + m.substring(3), new Class[0]);
                if (getter.getAnnotation(Column.class) == null) {
                    return Reflect.accessible(getter);
                }
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            try {
                getter = type.getMethod("is" + m.substring(3), new Class[0]);
                if (getter.getAnnotation(Column.class) != null) continue;
                return Reflect.accessible(getter);
            }
            catch (NoSuchMethodException ignore) {
            }
        }
        return null;
    }

    static final List<Method> getMatchingSetters(Class<?> type, String name) {
        ArrayList<Method> result = new ArrayList<Method>();
        String camelCase = StringUtils.toCamelCase(name);
        String camelCaseLC = StringUtils.toLC(camelCase);
        for (Method method : Utils.getInstanceMethods(type)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) continue;
            if (name.equals(method.getName())) {
                result.add(Reflect.accessible(method));
                continue;
            }
            if (camelCaseLC.equals(method.getName())) {
                result.add(Reflect.accessible(method));
                continue;
            }
            if (("set" + name).equals(method.getName())) {
                result.add(Reflect.accessible(method));
                continue;
            }
            if (!("set" + camelCase).equals(method.getName())) continue;
            result.add(Reflect.accessible(method));
        }
        return result;
    }

    static final Method getMatchingGetter(Class<?> type, String name) {
        String camelCase = StringUtils.toCamelCase(name);
        String camelCaseLC = StringUtils.toLC(camelCase);
        for (Method method : Utils.getInstanceMethods(type)) {
            if (method.getParameterTypes().length != 0) continue;
            if (name.equals(method.getName())) {
                return Reflect.accessible(method);
            }
            if (camelCaseLC.equals(method.getName())) {
                return Reflect.accessible(method);
            }
            if (("get" + name).equals(method.getName())) {
                return Reflect.accessible(method);
            }
            if (("get" + camelCase).equals(method.getName())) {
                return Reflect.accessible(method);
            }
            if (("is" + name).equals(method.getName())) {
                return Reflect.accessible(method);
            }
            if (!("is" + camelCase).equals(method.getName())) continue;
            return Reflect.accessible(method);
        }
        return null;
    }

    private static final List<Method> getInstanceMethods(Class<?> type) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            result.add(method);
        }
        return result;
    }

    private static final List<java.lang.reflect.Field> getInstanceMembers(Class<?> type) {
        ArrayList<java.lang.reflect.Field> result = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : type.getFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            result.add(field);
        }
        return result;
    }

    static final String getPropertyName(String methodName) {
        String name = methodName;
        if (name.startsWith("is") && name.length() > 2) {
            name = name.substring(2, 3).toLowerCase() + name.substring(3);
        } else if (name.startsWith("get") && name.length() > 3) {
            name = name.substring(3, 4).toLowerCase() + name.substring(4);
        } else if (name.startsWith("set") && name.length() > 3) {
            name = name.substring(3, 4).toLowerCase() + name.substring(4);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final <T> T getFromSQLInput(Configuration configuration, SQLInput stream, Field<T> field) throws SQLException {
        Class<T> type = field.getType();
        DataType<T> dataType = field.getDataType();
        if (type == Blob.class) {
            return (T)stream.readBlob();
        }
        if (type == Boolean.class) {
            return (T)JDBCUtils.wasNull(stream, Boolean.valueOf(stream.readBoolean()));
        }
        if (type == BigInteger.class) {
            BigDecimal result = stream.readBigDecimal();
            return (T)(result == null ? null : result.toBigInteger());
        }
        if (type == BigDecimal.class) {
            return (T)stream.readBigDecimal();
        }
        if (type == Byte.class) {
            return (T)JDBCUtils.wasNull(stream, Byte.valueOf(stream.readByte()));
        }
        if (type == byte[].class) {
            if (dataType.isLob()) {
                Blob blob = null;
                try {
                    blob = stream.readBlob();
                    byte[] byArray = blob == null ? null : blob.getBytes(1L, (int)blob.length());
                    return (T)byArray;
                }
                finally {
                    JDBCUtils.safeFree(blob);
                }
            }
            return (T)stream.readBytes();
        }
        if (type == Clob.class) {
            return (T)stream.readClob();
        }
        if (type == java.sql.Date.class) {
            return (T)stream.readDate();
        }
        if (type == Double.class) {
            return (T)JDBCUtils.wasNull(stream, Double.valueOf(stream.readDouble()));
        }
        if (type == Float.class) {
            return (T)JDBCUtils.wasNull(stream, Float.valueOf(stream.readFloat()));
        }
        if (type == Integer.class) {
            return (T)JDBCUtils.wasNull(stream, Integer.valueOf(stream.readInt()));
        }
        if (type == Long.class) {
            return (T)JDBCUtils.wasNull(stream, Long.valueOf(stream.readLong()));
        }
        if (type == Short.class) {
            return (T)JDBCUtils.wasNull(stream, Short.valueOf(stream.readShort()));
        }
        if (type == String.class) {
            return (T)stream.readString();
        }
        if (type == Time.class) {
            return (T)stream.readTime();
        }
        if (type == Timestamp.class) {
            return (T)stream.readTimestamp();
        }
        if (type == YearToMonth.class) {
            String string = stream.readString();
            return (T)(string == null ? null : YearToMonth.valueOf(string));
        }
        if (type == DayToSecond.class) {
            String string = stream.readString();
            return (T)(string == null ? null : DayToSecond.valueOf(string));
        }
        if (type == UByte.class) {
            String string = stream.readString();
            return (T)(string == null ? null : UByte.valueOf(string));
        }
        if (type == UShort.class) {
            String string = stream.readString();
            return (T)(string == null ? null : UShort.valueOf(string));
        }
        if (type == UInteger.class) {
            String string = stream.readString();
            return (T)(string == null ? null : UInteger.valueOf(string));
        }
        if (type == ULong.class) {
            String string = stream.readString();
            return (T)(string == null ? null : ULong.valueOf(string));
        }
        if (type == UUID.class) {
            return (T)Convert.convert((Object)stream.readString(), UUID.class);
        }
        if (type.isArray()) {
            java.sql.Array result = stream.readArray();
            return (T)(result == null ? null : result.getArray());
        }
        if (EnumType.class.isAssignableFrom(type)) {
            return Utils.getEnumType(type, stream.readString());
        }
        if (UDTRecord.class.isAssignableFrom(type)) {
            return (T)stream.readObject();
        }
        return (T)Utils.unlob(stream.readObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final <T> void writeToSQLOutput(SQLOutput stream, Field<T> field, T value) throws SQLException {
        block21: {
            Class<T> type;
            block36: {
                block37: {
                    DataType<T> dataType;
                    block35: {
                        block34: {
                            block33: {
                                block32: {
                                    block31: {
                                        block30: {
                                            block29: {
                                                block27: {
                                                    block28: {
                                                        block26: {
                                                            block25: {
                                                                block24: {
                                                                    block23: {
                                                                        block22: {
                                                                            block20: {
                                                                                type = field.getType();
                                                                                dataType = field.getDataType();
                                                                                if (value != null) break block20;
                                                                                stream.writeObject(null);
                                                                                break block21;
                                                                            }
                                                                            if (type != Blob.class) break block22;
                                                                            stream.writeBlob((Blob)value);
                                                                            break block21;
                                                                        }
                                                                        if (type != Boolean.class) break block23;
                                                                        stream.writeBoolean((Boolean)value);
                                                                        break block21;
                                                                    }
                                                                    if (type != BigInteger.class) break block24;
                                                                    stream.writeBigDecimal(new BigDecimal((BigInteger)value));
                                                                    break block21;
                                                                }
                                                                if (type != BigDecimal.class) break block25;
                                                                stream.writeBigDecimal((BigDecimal)value);
                                                                break block21;
                                                            }
                                                            if (type != Byte.class) break block26;
                                                            stream.writeByte((Byte)value);
                                                            break block21;
                                                        }
                                                        if (type != byte[].class) break block27;
                                                        if (!dataType.isLob()) break block28;
                                                        Blob blob = null;
                                                        try {
                                                            blob = (Blob)Reflect.on("oracle.sql.BLOB").call("createTemporary", Reflect.on(stream).call("getSTRUCT").call("getJavaSqlConnection").get(), false, Reflect.on("oracle.sql.BLOB").get("DURATION_SESSION")).get();
                                                            blob.setBytes(1L, (byte[])value);
                                                            stream.writeBlob(blob);
                                                        }
                                                        catch (Throwable throwable) {
                                                            DefaultExecuteContext.register(blob);
                                                            throw throwable;
                                                        }
                                                        DefaultExecuteContext.register(blob);
                                                        break block21;
                                                    }
                                                    stream.writeBytes((byte[])value);
                                                    break block21;
                                                }
                                                if (type != Clob.class) break block29;
                                                stream.writeClob((Clob)value);
                                                break block21;
                                            }
                                            if (type != java.sql.Date.class) break block30;
                                            stream.writeDate((java.sql.Date)value);
                                            break block21;
                                        }
                                        if (type != Double.class) break block31;
                                        stream.writeDouble((Double)value);
                                        break block21;
                                    }
                                    if (type != Float.class) break block32;
                                    stream.writeFloat(((Float)value).floatValue());
                                    break block21;
                                }
                                if (type != Integer.class) break block33;
                                stream.writeInt((Integer)value);
                                break block21;
                            }
                            if (type != Long.class) break block34;
                            stream.writeLong((Long)value);
                            break block21;
                        }
                        if (type != Short.class) break block35;
                        stream.writeShort((Short)value);
                        break block21;
                    }
                    if (type != String.class) break block36;
                    if (!dataType.isLob()) break block37;
                    Clob clob = null;
                    try {
                        clob = (Clob)Reflect.on("oracle.sql.CLOB").call("createTemporary", Reflect.on(stream).call("getSTRUCT").call("getJavaSqlConnection").get(), false, Reflect.on("oracle.sql.CLOB").get("DURATION_SESSION")).get();
                        clob.setString(1L, (String)value);
                        stream.writeClob(clob);
                    }
                    catch (Throwable throwable) {
                        DefaultExecuteContext.register(clob);
                        throw throwable;
                    }
                    DefaultExecuteContext.register(clob);
                    break block21;
                }
                stream.writeString((String)value);
                break block21;
            }
            if (type == Time.class) {
                stream.writeTime((Time)value);
            } else if (type == Timestamp.class) {
                stream.writeTimestamp((Timestamp)value);
            } else if (type == YearToMonth.class) {
                stream.writeString(value.toString());
            } else if (type == DayToSecond.class) {
                stream.writeString(value.toString());
            } else if (UNumber.class.isAssignableFrom(type)) {
                stream.writeString(value.toString());
            } else if (type == UUID.class) {
                stream.writeString(value.toString());
            } else if (EnumType.class.isAssignableFrom(type)) {
                stream.writeString(((EnumType)value).getLiteral());
            } else if (UDTRecord.class.isAssignableFrom(type)) {
                stream.writeObject((UDTRecord)value);
            } else {
                throw new UnsupportedOperationException("Type " + type + " is not supported");
            }
        }
    }

    static final <T, U> U getFromResultSet(ExecuteContext ctx, Field<U> field, int index) throws SQLException {
        Converter<?, U> converter = DataTypes.converter(field.getType());
        if (converter != null) {
            return converter.from(Utils.getFromResultSet(ctx, converter.fromType(), index));
        }
        return Utils.getFromResultSet(ctx, field.getType(), index);
    }

    private static final <T> T getFromResultSet(ExecuteContext ctx, Class<T> type, int index) throws SQLException {
        ResultSet rs = ctx.resultSet();
        if (type == Blob.class) {
            return (T)rs.getBlob(index);
        }
        if (type == Boolean.class) {
            return (T)JDBCUtils.wasNull(rs, Boolean.valueOf(rs.getBoolean(index)));
        }
        if (type == BigInteger.class) {
            if (ctx.configuration().dialect() == SQLDialect.SQLITE) {
                return (T)Convert.convert((Object)rs.getString(index), BigInteger.class);
            }
            BigDecimal result = rs.getBigDecimal(index);
            return (T)(result == null ? null : result.toBigInteger());
        }
        if (type == BigDecimal.class) {
            if (ctx.configuration().dialect() == SQLDialect.SQLITE) {
                return (T)Convert.convert((Object)rs.getString(index), BigDecimal.class);
            }
            return (T)rs.getBigDecimal(index);
        }
        if (type == Byte.class) {
            return (T)JDBCUtils.wasNull(rs, Byte.valueOf(rs.getByte(index)));
        }
        if (type == byte[].class) {
            return (T)rs.getBytes(index);
        }
        if (type == Clob.class) {
            return (T)rs.getClob(index);
        }
        if (type == java.sql.Date.class) {
            return (T)Utils.getDate(ctx.configuration().dialect(), rs, index);
        }
        if (type == Double.class) {
            return (T)JDBCUtils.wasNull(rs, Double.valueOf(rs.getDouble(index)));
        }
        if (type == Float.class) {
            return (T)JDBCUtils.wasNull(rs, Float.valueOf(rs.getFloat(index)));
        }
        if (type == Integer.class) {
            return (T)JDBCUtils.wasNull(rs, Integer.valueOf(rs.getInt(index)));
        }
        if (type == Long.class) {
            return (T)JDBCUtils.wasNull(rs, Long.valueOf(rs.getLong(index)));
        }
        if (type == Short.class) {
            return (T)JDBCUtils.wasNull(rs, Short.valueOf(rs.getShort(index)));
        }
        if (type == String.class) {
            return (T)rs.getString(index);
        }
        if (type == Time.class) {
            return (T)Utils.getTime(ctx.configuration().dialect(), rs, index);
        }
        if (type == Timestamp.class) {
            return (T)Utils.getTimestamp(ctx.configuration().dialect(), rs, index);
        }
        if (type == YearToMonth.class) {
            if (ctx.configuration().dialect() == SQLDialect.POSTGRES) {
                Object object = rs.getObject(index);
                return (T)(object == null ? null : PostgresUtils.toYearToMonth(object));
            }
            String string = rs.getString(index);
            return (T)(string == null ? null : YearToMonth.valueOf(string));
        }
        if (type == DayToSecond.class) {
            if (ctx.configuration().dialect() == SQLDialect.POSTGRES) {
                Object object = rs.getObject(index);
                return (T)(object == null ? null : PostgresUtils.toDayToSecond(object));
            }
            String string = rs.getString(index);
            return (T)(string == null ? null : DayToSecond.valueOf(string));
        }
        if (type == UByte.class) {
            String string = rs.getString(index);
            return (T)(string == null ? null : UByte.valueOf(string));
        }
        if (type == UShort.class) {
            String string = rs.getString(index);
            return (T)(string == null ? null : UShort.valueOf(string));
        }
        if (type == UInteger.class) {
            String string = rs.getString(index);
            return (T)(string == null ? null : UInteger.valueOf(string));
        }
        if (type == ULong.class) {
            String string = rs.getString(index);
            return (T)(string == null ? null : ULong.valueOf(string));
        }
        if (type == UUID.class) {
            switch (ctx.configuration().dialect().family()) {
                case H2: 
                case POSTGRES: {
                    return (T)rs.getObject(index);
                }
            }
            return (T)Convert.convert((Object)rs.getString(index), UUID.class);
        }
        if (type.isArray()) {
            switch (ctx.configuration().dialect()) {
                case POSTGRES: {
                    return Utils.pgGetArray(ctx, type, index);
                }
            }
            return (T)Utils.convertArray(rs.getArray(index), type);
        }
        if (EnumType.class.isAssignableFrom(type)) {
            return Utils.getEnumType(type, rs.getString(index));
        }
        if (UDTRecord.class.isAssignableFrom(type)) {
            switch (ctx.configuration().dialect()) {
                case POSTGRES: {
                    return (T)Utils.pgNewUDTRecord(type, rs.getObject(index));
                }
            }
            return (T)rs.getObject(index, DataTypes.udtRecords());
        }
        if (Result.class.isAssignableFrom(type)) {
            ResultSet nested = (ResultSet)rs.getObject(index);
            return (T)DSL.using(ctx.configuration()).fetch(nested);
        }
        return (T)Utils.unlob(rs.getObject(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object unlob(Object object) throws SQLException {
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return byArray;
            }
            finally {
                blob.free();
            }
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            try {
                String string = clob.getSubString(1L, (int)clob.length());
                return string;
            }
            finally {
                clob.free();
            }
        }
        return object;
    }

    private static final Object[] convertArray(Object array, Class<? extends Object[]> type) throws SQLException {
        if (array instanceof Object[]) {
            return Convert.convert(array, type);
        }
        if (array instanceof java.sql.Array) {
            return Utils.convertArray((java.sql.Array)array, type);
        }
        return null;
    }

    private static final Object[] convertArray(java.sql.Array array, Class<? extends Object[]> type) throws SQLException {
        if (array != null) {
            return Convert.convert(array.getArray(), type);
        }
        return null;
    }

    private static final java.sql.Date getDate(SQLDialect dialect, ResultSet rs, int index) throws SQLException {
        if (dialect == SQLDialect.SQLITE) {
            String date = rs.getString(index);
            if (date != null) {
                return new java.sql.Date(Utils.parse("yyyy-MM-dd", date));
            }
            return null;
        }
        if (dialect == SQLDialect.CUBRID) {
            java.sql.Date date = rs.getDate(index);
            if (date != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(date.getTime());
                cal.set(14, 0);
                date = new java.sql.Date(cal.getTimeInMillis());
            }
            return date;
        }
        return rs.getDate(index);
    }

    private static final Time getTime(SQLDialect dialect, ResultSet rs, int index) throws SQLException {
        if (dialect == SQLDialect.SQLITE) {
            String time = rs.getString(index);
            if (time != null) {
                return new Time(Utils.parse("HH:mm:ss", time));
            }
            return null;
        }
        if (dialect == SQLDialect.CUBRID) {
            Time time = rs.getTime(index);
            if (time != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(time.getTime());
                cal.set(14, 0);
                time = new Time(cal.getTimeInMillis());
            }
            return time;
        }
        return rs.getTime(index);
    }

    private static final Timestamp getTimestamp(SQLDialect dialect, ResultSet rs, int index) throws SQLException {
        if (dialect == SQLDialect.SQLITE) {
            String timestamp = rs.getString(index);
            if (timestamp != null) {
                return new Timestamp(Utils.parse("yyyy-MM-dd HH:mm:ss", timestamp));
            }
            return null;
        }
        return rs.getTimestamp(index);
    }

    private static final long parse(String pattern, String date) throws SQLException {
        try {
            try {
                return Long.valueOf(date);
            }
            catch (NumberFormatException e) {
                return new SimpleDateFormat(pattern).parse(date).getTime();
            }
        }
        catch (ParseException e) {
            throw new SQLException("Could not parse date " + date, e);
        }
    }

    private static final <T> T getEnumType(Class<T> type, String literal) throws SQLException {
        try {
            Object[] list;
            for (Object e : list = (Object[])type.getMethod("values", new Class[0]).invoke(type, new Object[0])) {
                String l = ((EnumType)e).getLiteral();
                if (!l.equals(literal)) continue;
                return (T)e;
            }
        }
        catch (Exception e) {
            throw new SQLException("Unknown enum literal found : " + literal);
        }
        return null;
    }

    static final <T> T getFromStatement(ExecuteContext ctx, Class<T> type, int index) throws SQLException {
        CallableStatement stmt = (CallableStatement)ctx.statement();
        if (type == Blob.class) {
            return (T)stmt.getBlob(index);
        }
        if (type == Boolean.class) {
            return (T)JDBCUtils.wasNull(stmt, Boolean.valueOf(stmt.getBoolean(index)));
        }
        if (type == BigInteger.class) {
            BigDecimal result = stmt.getBigDecimal(index);
            return (T)(result == null ? null : result.toBigInteger());
        }
        if (type == BigDecimal.class) {
            return (T)stmt.getBigDecimal(index);
        }
        if (type == Byte.class) {
            return (T)JDBCUtils.wasNull(stmt, Byte.valueOf(stmt.getByte(index)));
        }
        if (type == byte[].class) {
            return (T)stmt.getBytes(index);
        }
        if (type == Clob.class) {
            return (T)stmt.getClob(index);
        }
        if (type == java.sql.Date.class) {
            return (T)stmt.getDate(index);
        }
        if (type == Double.class) {
            return (T)JDBCUtils.wasNull(stmt, Double.valueOf(stmt.getDouble(index)));
        }
        if (type == Float.class) {
            return (T)JDBCUtils.wasNull(stmt, Float.valueOf(stmt.getFloat(index)));
        }
        if (type == Integer.class) {
            return (T)JDBCUtils.wasNull(stmt, Integer.valueOf(stmt.getInt(index)));
        }
        if (type == Long.class) {
            return (T)JDBCUtils.wasNull(stmt, Long.valueOf(stmt.getLong(index)));
        }
        if (type == Short.class) {
            return (T)JDBCUtils.wasNull(stmt, Short.valueOf(stmt.getShort(index)));
        }
        if (type == String.class) {
            return (T)stmt.getString(index);
        }
        if (type == Time.class) {
            return (T)stmt.getTime(index);
        }
        if (type == Timestamp.class) {
            return (T)stmt.getTimestamp(index);
        }
        if (type == YearToMonth.class) {
            if (ctx.configuration().dialect() == SQLDialect.POSTGRES) {
                Object object = stmt.getObject(index);
                return (T)(object == null ? null : PostgresUtils.toYearToMonth(object));
            }
            String string = stmt.getString(index);
            return (T)(string == null ? null : YearToMonth.valueOf(string));
        }
        if (type == DayToSecond.class) {
            if (ctx.configuration().dialect() == SQLDialect.POSTGRES) {
                Object object = stmt.getObject(index);
                return (T)(object == null ? null : PostgresUtils.toDayToSecond(object));
            }
            String string = stmt.getString(index);
            return (T)(string == null ? null : DayToSecond.valueOf(string));
        }
        if (type == UByte.class) {
            String string = stmt.getString(index);
            return (T)(string == null ? null : UByte.valueOf(string));
        }
        if (type == UShort.class) {
            String string = stmt.getString(index);
            return (T)(string == null ? null : UShort.valueOf(string));
        }
        if (type == UInteger.class) {
            String string = stmt.getString(index);
            return (T)(string == null ? null : UInteger.valueOf(string));
        }
        if (type == ULong.class) {
            String string = stmt.getString(index);
            return (T)(string == null ? null : ULong.valueOf(string));
        }
        if (type == UUID.class) {
            switch (ctx.configuration().dialect().family()) {
                case H2: 
                case POSTGRES: {
                    return (T)stmt.getObject(index);
                }
            }
            return (T)Convert.convert((Object)stmt.getString(index), UUID.class);
        }
        if (type.isArray()) {
            return (T)Utils.convertArray(stmt.getObject(index), type);
        }
        if (EnumType.class.isAssignableFrom(type)) {
            return Utils.getEnumType(type, stmt.getString(index));
        }
        if (UDTRecord.class.isAssignableFrom(type)) {
            switch (ctx.configuration().dialect()) {
                case POSTGRES: {
                    return (T)Utils.pgNewUDTRecord(type, stmt.getObject(index));
                }
            }
            return (T)stmt.getObject(index, DataTypes.udtRecords());
        }
        if (Result.class.isAssignableFrom(type)) {
            ResultSet nested = (ResultSet)stmt.getObject(index);
            return (T)DSL.using(ctx.configuration()).fetch(nested);
        }
        return (T)stmt.getObject(index);
    }

    private static final <T> T pgFromString(Class<T> type, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        if (type != Blob.class) {
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(string);
            }
            if (type == BigInteger.class) {
                return (T)new BigInteger(string);
            }
            if (type == BigDecimal.class) {
                return (T)new BigDecimal(string);
            }
            if (type == Byte.class) {
                return (T)Byte.valueOf(string);
            }
            if (type == byte[].class) {
                return (T)PostgresUtils.toBytes(string);
            }
            if (type != Clob.class) {
                if (type == java.sql.Date.class) {
                    SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
                    return (T)new java.sql.Date(Utils.pgParseDate(string, f).getTime());
                }
                if (type == Double.class) {
                    return (T)Double.valueOf(string);
                }
                if (type == Float.class) {
                    return (T)Float.valueOf(string);
                }
                if (type == Integer.class) {
                    return (T)Integer.valueOf(string);
                }
                if (type == Long.class) {
                    return (T)Long.valueOf(string);
                }
                if (type == Short.class) {
                    return (T)Short.valueOf(string);
                }
                if (type == String.class) {
                    return (T)string;
                }
                if (type == Time.class) {
                    SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
                    return (T)new Time(Utils.pgParseDate(string, f).getTime());
                }
                if (type == Timestamp.class) {
                    SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    return (T)new Timestamp(Utils.pgParseDate(string, f).getTime());
                }
                if (type == UByte.class) {
                    return (T)UByte.valueOf(string);
                }
                if (type == UShort.class) {
                    return (T)UShort.valueOf(string);
                }
                if (type == UInteger.class) {
                    return (T)UInteger.valueOf(string);
                }
                if (type == ULong.class) {
                    return (T)ULong.valueOf(string);
                }
                if (type == UUID.class) {
                    return (T)UUID.fromString(string);
                }
                if (type.isArray()) {
                    return (T)Utils.pgNewArray(type, string);
                }
                if (EnumType.class.isAssignableFrom(type)) {
                    return Utils.getEnumType(type, string);
                }
                if (UDTRecord.class.isAssignableFrom(type)) {
                    return (T)Utils.pgNewUDTRecord(type, string);
                }
            }
        }
        throw new UnsupportedOperationException("Class " + type + " is not supported");
    }

    private static final Date pgParseDate(String string, SimpleDateFormat f) throws SQLException {
        try {
            return f.parse(string);
        }
        catch (ParseException e) {
            throw new SQLException(e);
        }
    }

    private static final UDTRecord<?> pgNewUDTRecord(Class<?> type, final Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        return (UDTRecord)Utils.newRecord(type).operate(new RecordOperation<UDTRecord<?>, SQLException>(){

            @Override
            public UDTRecord<?> operate(UDTRecord<?> record) throws SQLException {
                List<String> values = PostgresUtils.toPGObject(object.toString());
                Row row = record.fieldsRow();
                for (int i = 0; i < row.size(); ++i) {
                    Utils.pgSetValue(record, row.field(i), values.get(i));
                }
                return record;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T pgGetArray(ExecuteContext ctx, Class<T> type, int index) throws SQLException {
        ResultSet rs = ctx.resultSet();
        java.sql.Array array = rs.getArray(index);
        if (array == null) {
            return null;
        }
        try {
            return (T)Utils.convertArray(rs.getArray(index), type);
        }
        catch (Exception e) {
            ArrayList result = new ArrayList();
            try {
                ctx.resultSet(array.getResultSet());
                while (ctx.resultSet().next()) {
                    result.add(Utils.getFromResultSet(ctx, type.getComponentType(), 2));
                }
            }
            catch (Exception fatal) {
                log.error("Cannot parse Postgres array: " + rs.getString(index));
                log.error(fatal);
                T t = null;
                return t;
            }
            finally {
                ctx.resultSet(rs);
            }
            return (T)Utils.convertArray(result.toArray(), type);
        }
    }

    private static final Object[] pgNewArray(Class<?> type, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            Class<?> component = type.getComponentType();
            String values = string.replaceAll("^\\{(.*)\\}$", "$1");
            if ("".equals(values)) {
                return (Object[])Array.newInstance(component, 0);
            }
            String[] split = values.split(",");
            Object[] result = (Object[])Array.newInstance(component, split.length);
            for (int i = 0; i < split.length; ++i) {
                result[i] = Utils.pgFromString(type.getComponentType(), split[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static final <T> void pgSetValue(UDTRecord<?> record, Field<T> field, String value) throws SQLException {
        record.setValue(field, Utils.pgFromString(field.getType(), value));
    }

    static List<String[]> parseTXT(String string, String nullLiteral) {
        boolean formatted;
        String[] strings = string.split("[\\r\\n]+");
        if (strings.length < 2) {
            throw new DataAccessException("String must contain at least two lines");
        }
        boolean bl = formatted = string.charAt(0) == '+';
        if (formatted) {
            return Utils.parseTXTLines(nullLiteral, strings, PLUS_PATTERN, 0, 1, 3, strings.length - 1);
        }
        return Utils.parseTXTLines(nullLiteral, strings, DASH_PATTERN, 1, 0, 2, strings.length);
    }

    private static List<String[]> parseTXTLines(String nullLiteral, String[] strings, Pattern pattern, int matchLine, int headerLine, int dataLineStart, int dataLineEnd) {
        ArrayList<int[]> positions = new ArrayList<int[]>();
        Matcher m = pattern.matcher(strings[matchLine]);
        while (m.find()) {
            positions.add(new int[]{m.start(1), m.end(1)});
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        Utils.parseTXTLine(positions, result, strings[headerLine], nullLiteral);
        for (int j = dataLineStart; j < dataLineEnd; ++j) {
            Utils.parseTXTLine(positions, result, strings[j], nullLiteral);
        }
        return result;
    }

    private static void parseTXTLine(List<int[]> positions, List<String[]> result, String string, String nullLiteral) {
        String[] fields = new String[positions.size()];
        result.add(fields);
        int length = string.length();
        for (int i = 0; i < fields.length; ++i) {
            int[] position = positions.get(i);
            fields[i] = position[0] < length ? string.substring(position[0], Math.min(position[1], length)).trim() : null;
            if (!StringUtils.equals(fields[i], nullLiteral)) continue;
            fields[i] = null;
        }
    }

    static {
        DASH_PATTERN = Pattern.compile("(-+)");
        PLUS_PATTERN = Pattern.compile("\\+(-+)(?=\\+)");
        JDBC_ESCAPE_PATTERN = Pattern.compile("\\{(fn|d|t|ts)\\b.*");
    }
}

