/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion.mapobject;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.mapobject.AbstractReportMapObjectGenerator;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

public abstract class AbstractReportMapRectangleGenerator
extends AbstractReportMapObjectGenerator<MapRectangle> {
    private static final long serialVersionUID = -8754565176631384914L;
    protected Field m_TopLeftLatitude;
    protected Field m_TopLeftLongitude;
    protected Field m_BottomRightLatitude;
    protected Field m_BottomRightLongitude;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("top-left-latitude", "topLeftLatitude", (Object)new Field("top-left-lat", DataType.NUMERIC));
        this.m_OptionManager.add("top-left-longitude", "topLeftLongitude", (Object)new Field("top-left-lon", DataType.NUMERIC));
        this.m_OptionManager.add("bottom-right-latitude", "bottomRightLatitude", (Object)new Field("bottom-right-lat", DataType.NUMERIC));
        this.m_OptionManager.add("bottom-right-longitude", "bottomRightLongitude", (Object)new Field("bottom-right-lat", DataType.NUMERIC));
    }

    public void setTopLeftLatitude(Field value) {
        this.m_TopLeftLatitude = value;
        this.reset();
    }

    public Field getTopLeftLatitude() {
        return this.m_TopLeftLatitude;
    }

    public String topLeftLatitudeTipText() {
        return "The field containing the latitude of the top-left corner.";
    }

    public void setTopLeftLongitude(Field value) {
        this.m_TopLeftLongitude = value;
        this.reset();
    }

    public Field getTopLeftLongitude() {
        return this.m_TopLeftLongitude;
    }

    public String topLeftLongitudeTipText() {
        return "The field containing the longitude of the top-left corner.";
    }

    public void setBottomRightLatitude(Field value) {
        this.m_BottomRightLatitude = value;
        this.reset();
    }

    public Field getBottomRightLatitude() {
        return this.m_BottomRightLatitude;
    }

    public String bottomRightLatitudeTipText() {
        return "The field containing the latitude of the bottom-right corner.";
    }

    public void setBottomRightLongitude(Field value) {
        this.m_BottomRightLongitude = value;
        this.reset();
    }

    public Field getBottomRightLongitude() {
        return this.m_BottomRightLongitude;
    }

    public String bottomRightLongitudeTipText() {
        return "The field containing the longitude of the bottom-right corner.";
    }

    @Override
    public Class generates() {
        return MapRectangle.class;
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"topLeftLatitude", (Object)this.m_TopLeftLatitude, (String)", top-left-lat: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"topLeftLongitude", (Object)this.m_TopLeftLongitude, (String)", top-left-lon: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"bottomRightLatitude", (Object)this.m_BottomRightLatitude, (String)", bottom-right-lat: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"bottomRightLongitude", (Object)this.m_BottomRightLongitude, (String)", bottom-right-lon: ");
        return result;
    }

    @Override
    protected void check(Report report) {
        super.check(report);
        if (!report.hasValue((AbstractField)this.m_TopLeftLatitude)) {
            throw new IllegalStateException("Failed to locate top-left latitude field: " + this.m_TopLeftLatitude);
        }
        if (!report.hasValue((AbstractField)this.m_TopLeftLongitude)) {
            throw new IllegalStateException("Failed to locate top-left longitude field: " + this.m_TopLeftLongitude);
        }
        if (!report.hasValue((AbstractField)this.m_BottomRightLatitude)) {
            throw new IllegalStateException("Failed to locate bottom-right latitude field: " + this.m_BottomRightLatitude);
        }
        if (!report.hasValue((AbstractField)this.m_BottomRightLongitude)) {
            throw new IllegalStateException("Failed to locate bottom-right longitude field: " + this.m_BottomRightLongitude);
        }
    }
}

