/*
 * Decompiled with CFR 0.152.
 */
package adams.data.mapobject;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.data.mapobject.AbstractMapObject;
import adams.data.mapobject.HitIndicator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

@MixedCopyright(copyright="OpenStreetMap", author="Vincent", license=License.GPL2, url="http://svn.openstreetmap.org/applications/viewer/jmapviewer/releases/1.02/JMapViewer-1.02-Source.zip", note="Original class: org.openstreetmap.gui.jmapviewer.MapRectangleImpl")
public class SimpleMapRectangle
extends AbstractMapObject
implements MapRectangle,
HitIndicator {
    private Coordinate topLeft;
    private Coordinate bottomRight;

    public SimpleMapRectangle(Coordinate topLeft, Coordinate bottomRight) {
        this(null, null, topLeft, bottomRight);
    }

    public SimpleMapRectangle(String name, Coordinate topLeft, Coordinate bottomRight) {
        this(null, name, topLeft, bottomRight);
    }

    public SimpleMapRectangle(Layer layer, Coordinate topLeft, Coordinate bottomRight) {
        this(layer, null, topLeft, bottomRight);
    }

    public SimpleMapRectangle(Layer layer, String name, Coordinate topLeft, Coordinate bottomRight) {
        this(layer, name, topLeft, bottomRight, SimpleMapRectangle.getDefaultStyle());
    }

    public SimpleMapRectangle(Layer layer, String name, Coordinate topLeft, Coordinate bottomRight, Style style) {
        super(layer, name, style);
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    public Coordinate getTopLeft() {
        return this.topLeft;
    }

    public Coordinate getBottomRight() {
        return this.bottomRight;
    }

    public void paint(Graphics g, Point topLeft, Point bottomRight) {
        Color oldColor = g.getColor();
        g.setColor(this.getColor());
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            oldStroke = g2.getStroke();
            g2.setStroke(this.getStroke());
            g2.setPaint(this.getBackColor());
        }
        g.fillRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        g.setColor(this.getColor());
        g.drawRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        g.setColor(oldColor);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(oldStroke);
        }
        int width = bottomRight.x - topLeft.x;
        int height = bottomRight.y - topLeft.y;
        Point p = new Point(topLeft.x + width / 2, topLeft.y + height / 2);
        if (this.getLayer() == null || this.getLayer().isVisibleTexts().booleanValue()) {
            this.paintText(g, p);
        }
    }

    public static Style getDefaultStyle() {
        return new Style(Color.BLUE, new Color(100, 100, 100, 50), (Stroke)new BasicStroke(2.0f), SimpleMapRectangle.getDefaultFont());
    }

    @Override
    public boolean isHit(JMapViewer viewer, Coordinate coord) {
        return coord.getLat() <= this.topLeft.getLat() && coord.getLon() >= this.topLeft.getLon() && coord.getLat() >= this.bottomRight.getLat() && coord.getLon() <= this.bottomRight.getLon();
    }

    public String toString() {
        return "Rectangle: name=" + this.getName() + ", topleft=" + this.getTopLeft() + ", bottomright=" + this.getBottomRight() + ", meta=" + this.getMetaData();
    }
}

