/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.timeseries.core;

import weka.classifiers.timeseries.core.AbstractTimeSeriesFilter;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;

public class TimeSeriesTranslate
extends AbstractTimeSeriesFilter {
    private static final long serialVersionUID = -4799796255517698151L;

    public String globalInfo() {
        return "An instance filter that assumes instances form time-series data and replaces attribute values in the current instance with the equivalent attribute values of some previous (or future) instance. For instances where the desired value is unknown either the instance may be dropped, or missing values used. Skips the class attribute if it is set.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (instanceInfo.classIndex() > 0 && !this.getFillWithMissing()) {
            throw new IllegalArgumentException("TimeSeriesTranslate: Need to fill in missing values using appropriate option when class index is set.");
        }
        super.setInputFormat(instanceInfo);
        Instances outputFormat = new Instances(instanceInfo, 0);
        for (int i = 0; i < instanceInfo.numAttributes(); ++i) {
            if (i == instanceInfo.classIndex() || !this.m_SelectedCols.isInRange(i)) continue;
            if (outputFormat.attribute(i).isNominal() || outputFormat.attribute(i).isNumeric()) {
                outputFormat.renameAttribute(i, outputFormat.attribute(i).name() + (this.m_InstanceRange < 0 ? (char)'-' : '+') + Math.abs(this.m_InstanceRange));
                continue;
            }
            throw new UnsupportedAttributeTypeException("Only numeric and nominal attributes may be  manipulated in time series.");
        }
        outputFormat.setClassIndex(instanceInfo.classIndex());
        this.setOutputFormat(outputFormat);
        return true;
    }

    @Override
    protected Instance mergeInstances(Instance source, Instance dest) {
        Instances outputFormat = this.outputFormatPeek();
        double[] vals = new double[outputFormat.numAttributes()];
        for (int i = 0; i < vals.length; ++i) {
            if (i != outputFormat.classIndex() && this.m_SelectedCols.isInRange(i)) {
                if (source != null) {
                    vals[i] = source.value(i);
                    continue;
                }
                vals[i] = Utils.missingValue();
                continue;
            }
            vals[i] = dest.value(i);
        }
        Object inst = null;
        inst = dest instanceof SparseInstance ? new SparseInstance(dest.weight(), vals) : new DenseInstance(dest.weight(), vals);
        inst.setDataset(dest.dataset());
        return inst;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 45163 $");
    }

    public static void main(String[] argv) {
        TimeSeriesTranslate.runFilter((Filter)new TimeSeriesTranslate(), (String[])argv);
    }
}

